/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import java.util.Objects;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.CreativeInventoryActionEvent;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;

public final class CreativeInventoryActionListener {
    public static void listener(ClientCreativeInventoryActionPacket packet, Player player) {
        if (player.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        short slot = packet.slot();
        ItemStack sentItem = packet.item();
        if (slot == -1) {
            CreativeInventoryActionEvent event = new CreativeInventoryActionEvent(player, slot, sentItem);
            EventDispatcher.call(event);
            if (event.isCancelled()) {
                return;
            }
            player.dropItem(event.getClickedItem());
            return;
        }
        if (slot < 1 || slot > 45) {
            return;
        }
        slot = (short)PlayerInventoryUtils.convertWindow0SlotToMinestomSlot(slot);
        PlayerInventory inventory = player.getInventory();
        CreativeInventoryActionEvent event = new CreativeInventoryActionEvent(player, slot, sentItem);
        EventDispatcher.call(event);
        ItemStack setItem = event.getClickedItem();
        ItemStack previousItem = inventory.getItemStack(slot);
        if (event.isCancelled()) {
            player.getInventory().sendSlotRefresh(slot, previousItem);
            return;
        }
        boolean isEqualToSentItem = Objects.equals(setItem, sentItem);
        if (Objects.equals(previousItem, sentItem) && isEqualToSentItem) {
            return;
        }
        inventory.setItemStack(slot, setItem);
        if (!isEqualToSentItem) {
            player.getInventory().sendSlotRefresh(slot, setItem);
        }
    }
}

