/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.AsyncPlayerConfigurationEvent;
import net.minestom.server.event.player.AsyncPlayerPreLoginEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.listener.preplay.LoginListener;
import net.minestom.server.network.PlayerProvider;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.common.KeepAlivePacket;
import net.minestom.server.network.packet.server.common.PluginMessagePacket;
import net.minestom.server.network.packet.server.common.TagsPacket;
import net.minestom.server.network.packet.server.configuration.FinishConfigurationPacket;
import net.minestom.server.network.packet.server.configuration.ResetChatPacket;
import net.minestom.server.network.packet.server.configuration.SelectKnownPacksPacket;
import net.minestom.server.network.packet.server.configuration.UpdateEnabledFeaturesPacket;
import net.minestom.server.network.packet.server.login.LoginSuccessPacket;
import net.minestom.server.network.packet.server.play.StartConfigurationPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.StringUtils;
import net.minestom.server.utils.validate.Check;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private static final Component TIMEOUT_TEXT = Component.text((String)"Timeout", (TextColor)NamedTextColor.RED);
    private static final Component SHUTDOWN_TEXT = Component.text((String)"Server shutting down");
    private CachedPacket cachedTagsPacket = new CachedPacket(this::createTagsPacket);
    private final Map<PlayerConnection, Player> connectionPlayerMap = new ConcurrentHashMap<PlayerConnection, Player>();
    private final MessagePassingQueue<Player> waitingPlayers = new MpscUnboundedArrayQueue(64);
    private final Set<Player> configurationPlayers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> playPlayers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> keepAlivePlayers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> unmodifiableConfigurationPlayers = Collections.unmodifiableSet(this.configurationPlayers);
    private final Set<Player> unmodifiablePlayPlayers = Collections.unmodifiableSet(this.playPlayers);
    private volatile PlayerProvider playerProvider = Player::new;

    public int getOnlinePlayerCount() {
        return this.playPlayers.size();
    }

    @NotNull
    public @NotNull Collection<@NotNull Player> getOnlinePlayers() {
        return this.unmodifiablePlayPlayers;
    }

    @NotNull
    public @NotNull Collection<@NotNull Player> getConfigPlayers() {
        return this.unmodifiableConfigurationPlayers;
    }

    public Player getPlayer(@NotNull PlayerConnection connection) {
        return this.connectionPlayerMap.get(connection);
    }

    @Nullable
    public Player getOnlinePlayerByUsername(@NotNull String username) {
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getUsername().equalsIgnoreCase(username)) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public Player getOnlinePlayerByUuid(@NotNull UUID uuid) {
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getUuid().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public Player findOnlinePlayer(@NotNull String username) {
        Player exact = this.getOnlinePlayerByUsername(username);
        if (exact != null) {
            return exact;
        }
        String username1 = username.toLowerCase(Locale.ROOT);
        Function<Player, Double> distanceFunction = player -> {
            String username2 = player.getUsername().toLowerCase(Locale.ROOT);
            return StringUtils.jaroWinklerScore(username1, username2);
        };
        return this.getOnlinePlayers().stream().min(Comparator.comparingDouble(distanceFunction::apply)).filter(player -> (Double)distanceFunction.apply((Player)player) > 0.0).orElse(null);
    }

    public void setPlayerProvider(@Nullable PlayerProvider playerProvider) {
        this.playerProvider = playerProvider != null ? playerProvider : Player::new;
    }

    @ApiStatus.Internal
    @NotNull
    public Player createPlayer(@NotNull PlayerConnection connection, @NotNull GameProfile gameProfile) {
        assert (ServerFlag.INSIDE_TEST || Thread.currentThread().isVirtual());
        Player player = this.playerProvider.createPlayer(connection, gameProfile);
        this.connectionPlayerMap.put(connection, player);
        return player;
    }

    public void sendRegistryTags(@NotNull Player player) {
        player.sendPacket(this.cachedTagsPacket);
    }

    @ApiStatus.Internal
    public void invalidateTags() {
        this.cachedTagsPacket.invalidate();
    }

    public GameProfile transitionLoginToConfig(@NotNull PlayerConnection connection, @NotNull GameProfile gameProfile) {
        assert (ServerFlag.INSIDE_TEST || Thread.currentThread().isVirtual());
        if (connection instanceof PlayerSocketConnection) {
            PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
            int threshold = MinecraftServer.getCompressionThreshold();
            if (threshold > 0) {
                socketConnection.startCompression();
            }
        }
        LoginPluginMessageProcessor pluginMessageProcessor = connection.loginPluginMessageProcessor();
        AsyncPlayerPreLoginEvent asyncPlayerPreLoginEvent = new AsyncPlayerPreLoginEvent(connection, gameProfile, pluginMessageProcessor);
        EventDispatcher.call(asyncPlayerPreLoginEvent);
        if (!connection.isOnline()) {
            return gameProfile;
        }
        gameProfile = asyncPlayerPreLoginEvent.getGameProfile();
        try {
            pluginMessageProcessor.awaitReplies(ServerFlag.LOGIN_PLUGIN_MESSAGE_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            connection.kick(LoginListener.INVALID_PROXY_RESPONSE);
            throw new RuntimeException("Error getting replies for login plugin messages", t);
        }
        connection.sendPacket(new LoginSuccessPacket(gameProfile));
        return gameProfile;
    }

    @ApiStatus.Internal
    public void transitionPlayToConfig(@NotNull Player player) {
        player.sendPacket(new StartConfigurationPacket());
        this.configurationPlayers.add(player);
    }

    @ApiStatus.Internal
    public void doConfiguration(@NotNull Player player, boolean isFirstConfig) {
        CompletableFuture<Void> packFuture;
        assert (ServerFlag.INSIDE_TEST || Thread.currentThread().isVirtual());
        if (isFirstConfig) {
            this.configurationPlayers.add(player);
            this.keepAlivePlayers.add(player);
        }
        player.sendPacket(PluginMessagePacket.brandPacket(MinecraftServer.getBrandName()));
        CompletableFuture<List<SelectKnownPacksPacket.Entry>> knownPacksFuture = player.getPlayerConnection().requestKnownPacks(List.of(SelectKnownPacksPacket.MINECRAFT_CORE));
        AsyncPlayerConfigurationEvent event = new AsyncPlayerConfigurationEvent(player, isFirstConfig);
        EventDispatcher.call(event);
        if (!player.isOnline()) {
            return;
        }
        player.sendPacket(new UpdateEnabledFeaturesPacket(event.getFeatureFlags().stream().map(StaticProtocolObject::name).toList()));
        Instance spawningInstance = event.getSpawningInstance();
        Check.notNull(spawningInstance, "You need to specify a spawning instance in the AsyncPlayerConfigurationEvent");
        if (event.willClearChat()) {
            player.sendPacket(new ResetChatPacket());
        }
        if (event.willSendRegistryData()) {
            List<SelectKnownPacksPacket.Entry> knownPacks;
            try {
                knownPacks = knownPacksFuture.get(ServerFlag.KNOWN_PACKS_RESPONSE_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | TimeoutException e) {
                LOGGER.warn("Player {} failed to respond to known packs query", (Object)player.getUsername());
                player.getPlayerConnection().disconnect();
                return;
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Error receiving known packs", e);
            }
            boolean excludeVanilla = knownPacks.contains(SelectKnownPacksPacket.MINECRAFT_CORE);
            ServerProcess registries = MinecraftServer.process();
            player.sendPacket(registries.chatType().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.dimensionType().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.biome().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.damageType().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.trimMaterial().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.trimPattern().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.bannerPattern().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.enchantment().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.paintingVariant().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.jukeboxSong().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.instrument().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.wolfVariant().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.wolfSoundVariant().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.catVariant().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.chickenVariant().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.cowVariant().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.frogVariant().registryDataPacket(registries, excludeVanilla));
            player.sendPacket(registries.pigVariant().registryDataPacket(registries, excludeVanilla));
            this.sendRegistryTags(player);
        }
        if ((packFuture = player.getResourcePackFuture()) != null) {
            packFuture.join();
        }
        this.keepAlivePlayers.remove(player);
        player.setPendingOptions(spawningInstance, event.isHardcore());
        player.sendPacket(new FinishConfigurationPacket());
    }

    @ApiStatus.Internal
    public void transitionConfigToPlay(@NotNull Player player) {
        this.waitingPlayers.relaxedOffer((Object)player);
    }

    @ApiStatus.Internal
    public synchronized void removePlayer(@NotNull PlayerConnection connection) {
        Player player = this.connectionPlayerMap.remove(connection);
        if (player == null) {
            return;
        }
        this.configurationPlayers.remove(player);
        this.playPlayers.remove(player);
        this.keepAlivePlayers.remove(player);
    }

    public synchronized void shutdown() {
        for (PlayerConnection configPlayer : this.connectionPlayerMap.keySet()) {
            configPlayer.kick(SHUTDOWN_TEXT);
        }
        this.configurationPlayers.clear();
        for (Player playPlayer : this.playPlayers) {
            playPlayer.kick(SHUTDOWN_TEXT);
        }
        this.playPlayers.clear();
        this.keepAlivePlayers.clear();
        this.connectionPlayerMap.clear();
    }

    public void tick(long tickStart) {
        this.updateWaitingPlayers();
        this.handleKeepAlive(this.keepAlivePlayers, tickStart);
        this.configurationPlayers.forEach(Player::interpretPacketQueue);
    }

    @ApiStatus.Internal
    public void updateWaitingPlayers() {
        this.waitingPlayers.drain(player -> {
            if (!player.isOnline()) {
                return;
            }
            this.configurationPlayers.remove(player);
            this.playPlayers.add((Player)player);
            this.keepAlivePlayers.add((Player)player);
            player.refreshAnswerKeepAlive(true);
            CompletableFuture<Void> spawnFuture = player.UNSAFE_init();
            if (ServerFlag.INSIDE_TEST) {
                spawnFuture.join();
            }
        });
    }

    private void handleKeepAlive(@NotNull Collection<Player> playerGroup, long tickStart) {
        KeepAlivePacket keepAlivePacket = new KeepAlivePacket(tickStart);
        for (Player player : playerGroup) {
            long lastKeepAlive = tickStart - player.getLastKeepAlive();
            if (lastKeepAlive > ServerFlag.KEEP_ALIVE_DELAY && player.didAnswerKeepAlive()) {
                player.refreshKeepAlive(tickStart);
                player.sendPacket(keepAlivePacket);
                continue;
            }
            if (lastKeepAlive < ServerFlag.KEEP_ALIVE_KICK) continue;
            player.kick(TIMEOUT_TEXT);
        }
    }

    @NotNull
    private TagsPacket createTagsPacket() {
        ArrayList<TagsPacket.Registry> entries = new ArrayList<TagsPacket.Registry>();
        ServerProcess registries = MinecraftServer.process();
        entries.add(registries.biome().tagRegistry());
        entries.add(registries.bannerPattern().tagRegistry());
        entries.add(registries.biome().tagRegistry());
        entries.add(registries.blocks().tagRegistry());
        entries.add(registries.catVariant().tagRegistry());
        entries.add(registries.damageType().tagRegistry());
        entries.add(registries.enchantment().tagRegistry());
        entries.add(registries.entityType().tagRegistry());
        entries.add(registries.fluid().tagRegistry());
        entries.add(registries.gameEvent().tagRegistry());
        entries.add(registries.instrument().tagRegistry());
        entries.add(registries.material().tagRegistry());
        entries.add(registries.paintingVariant().tagRegistry());
        return new TagsPacket(entries);
    }
}

