/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe.display;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.item.Material;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.recipe.display.SlotDisplayType;
import net.minestom.server.registry.TagKey;
import net.minestom.server.utils.Unit;
import org.jetbrains.annotations.NotNull;

public sealed interface SlotDisplay
extends ComponentHolder<SlotDisplay> {
    @NotNull
    public static final NetworkBuffer.Type<SlotDisplay> NETWORK_TYPE = SlotDisplayType.NETWORK_TYPE.unionType(SlotDisplay::dataSerializer, SlotDisplay::slotDisplayToType);

    @Override
    @NotNull
    default public Collection<Component> components() {
        return List.of();
    }

    @Override
    @NotNull
    default public SlotDisplay copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return this;
    }

    private static NetworkBuffer.Type<SlotDisplay> dataSerializer(@NotNull SlotDisplayType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SlotDisplayType.EMPTY -> Empty.NETWORK_TYPE;
            case SlotDisplayType.ANY_FUEL -> AnyFuel.NETWORK_TYPE;
            case SlotDisplayType.ITEM -> Item.NETWORK_TYPE;
            case SlotDisplayType.ITEM_STACK -> ItemStack.NETWORK_TYPE;
            case SlotDisplayType.TAG -> Tag.NETWORK_TYPE;
            case SlotDisplayType.SMITHING_TRIM -> SmithingTrim.NETWORK_TYPE;
            case SlotDisplayType.WITH_REMAINDER -> WithRemainder.NETWORK_TYPE;
            case SlotDisplayType.COMPOSITE -> Composite.NETWORK_TYPE;
        };
    }

    private static SlotDisplayType slotDisplayToType(@NotNull SlotDisplay slotDisplay) {
        SlotDisplay slotDisplay2 = slotDisplay;
        Objects.requireNonNull(slotDisplay2);
        SlotDisplay slotDisplay3 = slotDisplay2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Empty.class, AnyFuel.class, Item.class, ItemStack.class, Tag.class, SmithingTrim.class, WithRemainder.class, Composite.class}, (Object)slotDisplay3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Empty ignored = (Empty)slotDisplay3;
                yield SlotDisplayType.EMPTY;
            }
            case 1 -> {
                AnyFuel ignored = (AnyFuel)slotDisplay3;
                yield SlotDisplayType.ANY_FUEL;
            }
            case 2 -> {
                Item ignored = (Item)slotDisplay3;
                yield SlotDisplayType.ITEM;
            }
            case 3 -> {
                ItemStack ignored = (ItemStack)slotDisplay3;
                yield SlotDisplayType.ITEM_STACK;
            }
            case 4 -> {
                Tag ignored = (Tag)slotDisplay3;
                yield SlotDisplayType.TAG;
            }
            case 5 -> {
                SmithingTrim ignored = (SmithingTrim)slotDisplay3;
                yield SlotDisplayType.SMITHING_TRIM;
            }
            case 6 -> {
                WithRemainder ignored = (WithRemainder)slotDisplay3;
                yield SlotDisplayType.WITH_REMAINDER;
            }
            case 7 -> {
                Composite ignored = (Composite)slotDisplay3;
                yield SlotDisplayType.COMPOSITE;
            }
        };
    }

    public static final class Empty
    implements SlotDisplay {
        public static final Empty INSTANCE = new Empty();
        public static final NetworkBuffer.Type<Empty> NETWORK_TYPE = NetworkBuffer.UNIT.transform(buffer -> INSTANCE, empty -> Unit.INSTANCE);

        private Empty() {
        }
    }

    public static final class AnyFuel
    implements SlotDisplay {
        public static final AnyFuel INSTANCE = new AnyFuel();
        public static final NetworkBuffer.Type<AnyFuel> NETWORK_TYPE = NetworkBuffer.UNIT.transform(buffer -> INSTANCE, empty -> Unit.INSTANCE);

        private AnyFuel() {
        }
    }

    public record Item(@NotNull Material material) implements SlotDisplay
    {
        public static final NetworkBuffer.Type<Item> NETWORK_TYPE = NetworkBufferTemplate.template(Material.NETWORK_TYPE, Item::material, Item::new);
    }

    public record ItemStack(@NotNull net.minestom.server.item.ItemStack itemStack) implements SlotDisplay
    {
        public static final NetworkBuffer.Type<ItemStack> NETWORK_TYPE = NetworkBufferTemplate.template(net.minestom.server.item.ItemStack.STRICT_NETWORK_TYPE, ItemStack::itemStack, ItemStack::new);

        @Override
        @NotNull
        public Collection<Component> components() {
            return net.minestom.server.item.ItemStack.textComponents(this.itemStack);
        }

        @Override
        @NotNull
        public SlotDisplay copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new ItemStack(net.minestom.server.item.ItemStack.copyWithOperator(this.itemStack, operator));
        }
    }

    public record Tag(@NotNull TagKey<Material> tag) implements SlotDisplay
    {
        public static final NetworkBuffer.Type<Tag> NETWORK_TYPE = NetworkBufferTemplate.template(TagKey.networkType(ignored -> Material.staticRegistry()), Tag::tag, Tag::new);
    }

    public record SmithingTrim(@NotNull SlotDisplay base, @NotNull SlotDisplay trimMaterial, @NotNull SlotDisplay trimPattern) implements SlotDisplay
    {
        public static final NetworkBuffer.Type<SmithingTrim> NETWORK_TYPE = NetworkBufferTemplate.template(NETWORK_TYPE, SmithingTrim::base, NETWORK_TYPE, SmithingTrim::trimMaterial, NETWORK_TYPE, SmithingTrim::trimPattern, SmithingTrim::new);

        @Override
        @NotNull
        public Collection<Component> components() {
            ArrayList<Component> components = new ArrayList<Component>(this.base.components());
            components.addAll(this.trimMaterial.components());
            components.addAll(this.trimPattern.components());
            return List.copyOf(components);
        }

        @Override
        @NotNull
        public SlotDisplay copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new SmithingTrim((SlotDisplay)this.base.copyWithOperator((UnaryOperator)operator), (SlotDisplay)this.trimMaterial.copyWithOperator((UnaryOperator)operator), (SlotDisplay)this.trimPattern.copyWithOperator((UnaryOperator)operator));
        }
    }

    public record WithRemainder(@NotNull SlotDisplay input, @NotNull SlotDisplay remainder) implements SlotDisplay
    {
        public static final NetworkBuffer.Type<WithRemainder> NETWORK_TYPE = NetworkBufferTemplate.template(NETWORK_TYPE, WithRemainder::input, NETWORK_TYPE, WithRemainder::remainder, WithRemainder::new);

        @Override
        @NotNull
        public Collection<Component> components() {
            ArrayList<Component> components = new ArrayList<Component>(this.input.components());
            components.addAll(this.remainder.components());
            return List.copyOf(components);
        }

        @Override
        @NotNull
        public SlotDisplay copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new WithRemainder((SlotDisplay)this.input.copyWithOperator((UnaryOperator)operator), (SlotDisplay)this.remainder.copyWithOperator((UnaryOperator)operator));
        }
    }

    public record Composite(@NotNull List<SlotDisplay> contents) implements SlotDisplay
    {
        public static final NetworkBuffer.Type<Composite> NETWORK_TYPE = NetworkBufferTemplate.template(NETWORK_TYPE.list(), Composite::contents, Composite::new);

        public Composite(@NotNull List<SlotDisplay> contents) {
            contents = List.copyOf(contents);
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            ArrayList<Component> components = new ArrayList<Component>();
            for (SlotDisplay display : this.contents) {
                components.addAll(display.components());
            }
            return List.copyOf(components);
        }

        @Override
        @NotNull
        public SlotDisplay copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            ArrayList<SlotDisplay> newContents = new ArrayList<SlotDisplay>();
            for (SlotDisplay display : this.contents) {
                newContents.add((SlotDisplay)display.copyWithOperator((UnaryOperator)operator));
            }
            return new Composite(newContents);
        }
    }
}

