/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.ServerFlag;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.common.TagsPacket;
import net.minestom.server.network.packet.server.configuration.RegistryDataPacket;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryKeyImpl;
import net.minestom.server.registry.RegistryTag;
import net.minestom.server.registry.RegistryTagImpl;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.registry.TagKey;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Internal
final class DynamicRegistryImpl<T>
implements DynamicRegistry<T> {
    private static final UnsupportedOperationException UNSAFE_REMOVE_EXCEPTION = new UnsupportedOperationException("Unsafe remove is disabled. Enable by setting the system property 'minestom.registry.unsafe-ops' to 'true'");
    private Registries registries = null;
    private final CachedPacket vanillaRegistryDataPacket = new CachedPacket(() -> this.createRegistryDataPacket(this.registries, true));
    private final ReentrantLock lock = new ReentrantLock();
    private final List<T> idToValue = new CopyOnWriteArrayList<T>();
    private final List<RegistryKey<T>> idToKey = new CopyOnWriteArrayList<RegistryKey<T>>();
    private final Map<Key, T> keyToValue = new ConcurrentHashMap<Key, T>();
    private final Map<T, RegistryKey<T>> valueToKey = new ConcurrentHashMap<T, RegistryKey<T>>();
    private final List<DataPack> packById = new CopyOnWriteArrayList<DataPack>();
    private final Map<TagKey<T>, RegistryTagImpl.Backed<T>> tags = new ConcurrentHashMap<TagKey<T>, RegistryTagImpl.Backed<T>>();
    private final Key key;
    private final Codec<T> codec;

    DynamicRegistryImpl(@NotNull Key key, @Nullable Codec<T> codec) {
        this.key = key;
        this.codec = codec;
    }

    @NotNull
    public Key key() {
        return this.key;
    }

    public @UnknownNullability Codec<T> codec() {
        return this.codec;
    }

    @Override
    @Nullable
    public T get(int id) {
        if (id < 0 || id >= this.idToValue.size()) {
            return null;
        }
        return this.idToValue.get(id);
    }

    @Override
    @Nullable
    public T get(@NotNull Key key) {
        return this.keyToValue.get(key);
    }

    @Override
    @Nullable
    public RegistryKey<T> getKey(int id) {
        if (id < 0 || id >= this.idToKey.size()) {
            return null;
        }
        return this.idToKey.get(id);
    }

    @Override
    @Nullable
    public RegistryKey<T> getKey(@NotNull T value) {
        return this.valueToKey.get(value);
    }

    @Override
    @Nullable
    public RegistryKey<T> getKey(@NotNull Key key) {
        if (!this.keyToValue.containsKey(key)) {
            return null;
        }
        return new RegistryKeyImpl(key);
    }

    @Override
    public int getId(@NotNull RegistryKey<T> key) {
        return this.idToKey.indexOf(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RegistryKey<T> register(@NotNull Key key, @NotNull T object, @Nullable DataPack pack) {
        this.lock.lock();
        try {
            RegistryKeyImpl registryKey = new RegistryKeyImpl(key);
            int id = this.idToKey.indexOf(registryKey);
            this.keyToValue.put(key, object);
            this.valueToKey.put(object, registryKey);
            if (id == -1) {
                this.idToValue.add(object);
                this.idToKey.add(registryKey);
                this.packById.add(pack);
            } else {
                this.idToValue.set(id, object);
                this.idToKey.set(id, registryKey);
                this.packById.set(id, pack);
            }
            this.vanillaRegistryDataPacket.invalidate();
            RegistryKeyImpl registryKeyImpl = registryKey;
            return registryKeyImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NotNull Key key) throws UnsupportedOperationException {
        if (!ServerFlag.REGISTRY_UNSAFE_OPS) {
            throw UNSAFE_REMOVE_EXCEPTION;
        }
        this.lock.lock();
        try {
            RegistryKeyImpl registryKey = new RegistryKeyImpl(key);
            int id = this.idToKey.indexOf(registryKey);
            if (id == -1) {
                boolean bl = false;
                return bl;
            }
            this.idToValue.remove(id);
            this.idToKey.remove(registryKey);
            T value = this.keyToValue.remove(key);
            this.valueToKey.remove(value);
            this.packById.remove(id);
            for (RegistryTagImpl.Backed tag : this.tags.values()) {
                tag.remove(registryKey);
            }
            this.vanillaRegistryDataPacket.invalidate();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public DataPack getPack(int id) {
        if (id < 0 || id >= this.packById.size()) {
            return null;
        }
        return this.packById.get(id);
    }

    @Override
    public int size() {
        return this.idToValue.size();
    }

    @Override
    @NotNull
    public Collection<RegistryKey<T>> keys() {
        return Collections.unmodifiableCollection(this.idToKey);
    }

    @Override
    @NotNull
    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.idToValue);
    }

    @Override
    @Nullable
    public RegistryTag<T> getTag(@NotNull TagKey<T> key) {
        return this.tags.get(key);
    }

    @Override
    @NotNull
    public RegistryTag<T> getOrCreateTag(@NotNull TagKey<T> key) {
        return this.tags.computeIfAbsent(key, RegistryTagImpl.Backed::new);
    }

    @Override
    public boolean removeTag(@NotNull TagKey<T> key) {
        return this.tags.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<RegistryTag<T>> tags() {
        return Collections.unmodifiableCollection(this.tags.values());
    }

    @Override
    @NotNull
    public SendablePacket registryDataPacket(@NotNull Registries registries, boolean excludeVanilla) {
        if (excludeVanilla) {
            if (this.registries != registries) {
                this.vanillaRegistryDataPacket.invalidate();
                this.registries = registries;
            }
            return this.vanillaRegistryDataPacket;
        }
        return this.createRegistryDataPacket(registries, false);
    }

    @Override
    public  @NotNull TagsPacket.Registry tagRegistry() {
        ArrayList<TagsPacket.Tag> tagList = new ArrayList<TagsPacket.Tag>(this.tags.size());
        for (RegistryTagImpl.Backed<T> tag : this.tags.values()) {
            int[] entries = new int[tag.size()];
            int i = 0;
            for (RegistryKey<T> registryKey : tag) {
                entries[i++] = this.idToKey.indexOf(registryKey);
            }
            tagList.add(new TagsPacket.Tag(tag.key().key().asString(), entries));
        }
        return new TagsPacket.Registry(this.key().asString(), tagList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private RegistryDataPacket createRegistryDataPacket(@NotNull Registries registries, boolean excludeVanilla) {
        Check.notNull(this.codec, "Cannot create registry data packet for server-only registry");
        RegistryTranscoder<BinaryTag> transcoder = new RegistryTranscoder<BinaryTag>(Transcoder.NBT, registries);
        ArrayList<RegistryDataPacket.Entry> entries = new ArrayList<RegistryDataPacket.Entry>(this.idToValue.size());
        int i = 0;
        while (i < this.idToValue.size()) {
            CompoundBinaryTag data = null;
            T entry = this.idToValue.get(i);
            DataPack pack = this.packById.get(i);
            if (!excludeVanilla || pack != DataPack.MINECRAFT_CORE) {
                BinaryTag tag;
                Result<BinaryTag> entryResult = this.codec.encode(transcoder, entry);
                if (!(entryResult instanceof Result.Ok)) {
                    throw new IllegalStateException("Failed to encode registry entry " + i + " (" + String.valueOf(this.getKey((T)i)) + ") for registry " + String.valueOf(this.key));
                }
                Result.Ok ok = (Result.Ok)entryResult;
                try {
                    BinaryTag binaryTag;
                    tag = binaryTag = (BinaryTag)ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                data = (CompoundBinaryTag)tag;
            }
            entries.add(new RegistryDataPacket.Entry(this.getKey((T)i).key().asString(), (BinaryTag)data));
            ++i;
        }
        return new RegistryDataPacket(this.key.asString(), entries);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> void loadStaticJsonRegistry(@Nullable Registries registries, @NotNull DynamicRegistryImpl<T> registry, @NotNull RegistryData.Resource resource, @Nullable Comparator<String> idComparator, @NotNull Codec<T> codec) {
        Check.argCondition(!resource.fileName().endsWith(".json"), "Resource must be a JSON file: {0}", resource.fileName());
        try (InputStream resourceStream = RegistryData.loadRegistryFile(String.format("%s.json", registry.key().value()));){
            Check.notNull(resourceStream, "Resource {0} does not exist!", new Object[]{resource});
            JsonElement json = (JsonElement)RegistryData.GSON.fromJson((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8), JsonElement.class);
            if (!(json instanceof JsonObject)) throw new IllegalStateException("Failed to load registry " + String.valueOf(registry.key()) + ": expected a JSON object, got " + String.valueOf(json));
            JsonObject root = (JsonObject)json;
            RegistryTranscoder<JsonElement> transcoder = registries != null ? new RegistryTranscoder<JsonElement>(Transcoder.JSON, registries, false, true) : Transcoder.JSON;
            ArrayList entries = new ArrayList(root.entrySet());
            if (idComparator != null) {
                entries.sort(Map.Entry.comparingByKey(idComparator));
            }
            Iterator iterator = entries.iterator();
            while (true) {
                Object value;
                if (!iterator.hasNext()) {
                    RegistryData.loadTags(registry, registry.key());
                    return;
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                String namespace = (String)entry.getKey();
                Result valueResult = codec.decode(transcoder, (JsonElement)entry.getValue());
                if (!(valueResult instanceof Result.Ok)) throw new IllegalStateException("Failed to decode registry entry " + namespace + " for registry " + String.valueOf(registry.key()) + ": " + String.valueOf(valueResult));
                Result.Ok ok = (Result.Ok)valueResult;
                try {
                    Object t;
                    value = t = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                registry.register(namespace, value, DataPack.MINECRAFT_CORE);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

