/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import net.minestom.server.timer.TaskSchedule;
import org.jetbrains.annotations.NotNull;

final class TaskScheduleImpl {
    static TaskSchedule NEXT_TICK = new TickSchedule(1);
    static TaskSchedule PARK = new Park();
    static TaskSchedule STOP = new Stop();
    static TaskSchedule IMMEDIATE = new Immediate();

    TaskScheduleImpl() {
    }

    record TickSchedule(int tick) implements TaskSchedule
    {
        public TickSchedule {
            if (tick <= 0) {
                throw new IllegalArgumentException("Tick must be greater than 0 (" + tick + ")");
            }
        }
    }

    record Park() implements TaskSchedule
    {
    }

    record Stop() implements TaskSchedule
    {
    }

    record Immediate() implements TaskSchedule
    {
    }

    record FutureSchedule(CompletableFuture<?> future) implements TaskSchedule
    {
    }

    record DurationSchedule(@NotNull Duration duration) implements TaskSchedule
    {
    }
}

