/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.position;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PositionUtils {
    public static Pos lookAlong(@NotNull Pos position, double dx, double dy, double dz) {
        float yaw = PositionUtils.getLookYaw(dx, dz);
        float pitch = PositionUtils.getLookPitch(dx, dy, dz);
        return position.withView(yaw, pitch);
    }

    public static float getLookYaw(double dx, double dz) {
        double radians = Math.atan2(dz, dx);
        float degrees = (float)Math.toDegrees(radians) - 90.0f;
        if (degrees < -180.0f) {
            return degrees + 360.0f;
        }
        if (degrees > 180.0f) {
            return degrees - 360.0f;
        }
        return degrees;
    }

    public static float getLookPitch(double dx, double dy, double dz) {
        double radians = -Math.atan2(dy, Math.max(Math.abs(dx), Math.abs(dz)));
        return (float)Math.toDegrees(radians);
    }

    @NotNull
    public static Pos getPositionWithRelativeFlags(@NotNull Pos start, @NotNull Pos modifier, int flags) {
        double x = (flags & 1) == 0 ? modifier.x() : start.x() + modifier.x();
        double y = (flags & 2) == 0 ? modifier.y() : start.y() + modifier.y();
        double z = (flags & 4) == 0 ? modifier.z() : start.z() + modifier.z();
        float yaw = (flags & 8) == 0 ? modifier.yaw() : start.yaw() + modifier.yaw();
        float pitch = (flags & 0x10) == 0 ? modifier.pitch() : start.pitch() + modifier.pitch();
        return new Pos(x, y, z, yaw, pitch);
    }

    @NotNull
    public static Vec getVelocityWithRelativeFlags(@NotNull Vec start, @NotNull Vec modifier, int flags) {
        double x = (flags & 0x20) == 0 ? modifier.x() : start.x() + modifier.x();
        double y = (flags & 0x40) == 0 ? modifier.y() : start.y() + modifier.y();
        double z = (flags & 0x80) == 0 ? modifier.z() : start.z() + modifier.z();
        return new Vec(x, y, z);
    }
}

