/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import java.util.Iterator;
import net.minestom.server.collision.RayUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.instance.block.BlockFace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BoundingBox
implements Shape {
    private static final BoundingBox sleepingBoundingBox = new BoundingBox(0.2, 0.2, 0.2);
    private static final BoundingBox sneakingBoundingBox = new BoundingBox(0.6, 1.5, 0.6);
    private static final BoundingBox smallBoundingBox = new BoundingBox(0.6, 0.6, 0.6);
    static final BoundingBox ZERO = new BoundingBox(0.0, 0.0, 0.0);
    private final double width;
    private final double height;
    private final double depth;
    private final Point offset;
    private Point relativeEnd;

    public BoundingBox(double width, double height, double depth, Point offset) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.offset = offset;
    }

    public BoundingBox(double width, double height, double depth) {
        this(width, height, depth, new Vec(-width / 2.0, 0.0, -depth / 2.0));
    }

    @Override
    public boolean isOccluded(@NotNull Shape shape, @NotNull BlockFace face) {
        return false;
    }

    @Override
    @ApiStatus.Experimental
    public boolean intersectBox(@NotNull Point positionRelative, @NotNull BoundingBox boundingBox) {
        return this.minX() + positionRelative.x() <= boundingBox.maxX() - 5.0E-7 && this.maxX() + positionRelative.x() >= boundingBox.minX() + 5.0E-7 && this.minY() + positionRelative.y() <= boundingBox.maxY() - 5.0E-7 && this.maxY() + positionRelative.y() >= boundingBox.minY() + 5.0E-7 && this.minZ() + positionRelative.z() <= boundingBox.maxZ() - 5.0E-7 && this.maxZ() + positionRelative.z() >= boundingBox.minZ() + 5.0E-7;
    }

    @Override
    @ApiStatus.Experimental
    public boolean intersectBoxSwept(@NotNull Point rayStart, @NotNull Point rayDirection, @NotNull Point shapePos, @NotNull BoundingBox moving, @NotNull SweepResult finalResult) {
        if (RayUtils.BoundingBoxIntersectionCheck(moving, rayStart, rayDirection, this, shapePos, finalResult)) {
            finalResult.collidedPositionX = rayStart.x() + rayDirection.x() * finalResult.res;
            finalResult.collidedPositionY = rayStart.y() + rayDirection.y() * finalResult.res;
            finalResult.collidedPositionZ = rayStart.z() + rayDirection.z() * finalResult.res;
            finalResult.collidedShape = this;
            return true;
        }
        return false;
    }

    @ApiStatus.Experimental
    public boolean boundingBoxRayIntersectionCheck(Vec start, Vec direction, Pos position) {
        return RayUtils.BoundingBoxRayIntersectionCheck(start, direction, this, position);
    }

    @Override
    @NotNull
    public Point relativeStart() {
        return this.offset;
    }

    @Override
    @NotNull
    public Point relativeEnd() {
        Point relativeEnd = this.relativeEnd;
        if (relativeEnd == null) {
            this.relativeEnd = relativeEnd = this.offset.add(this.width, this.height, this.depth);
        }
        return relativeEnd;
    }

    public String toString() {
        Object result = "BoundingBox";
        result = (String)result + "\n";
        result = (String)result + "[" + this.minX() + " : " + this.maxX() + "]";
        result = (String)result + "\n";
        result = (String)result + "[" + this.minY() + " : " + this.maxY() + "]";
        result = (String)result + "\n";
        result = (String)result + "[" + this.minZ() + " : " + this.maxZ() + "]";
        return result;
    }

    @NotNull
    public BoundingBox expand(double x, double y, double z) {
        return new BoundingBox(this.width + x, this.height + y, this.depth + z);
    }

    @NotNull
    public BoundingBox contract(double x, double y, double z) {
        return new BoundingBox(this.width - x, this.height - y, this.depth - z);
    }

    @NotNull
    public BoundingBox withOffset(Point offset) {
        return new BoundingBox(this.width, this.height, this.depth, offset);
    }

    public double width() {
        return this.width;
    }

    public double height() {
        return this.height;
    }

    public double depth() {
        return this.depth;
    }

    public double minX() {
        return this.relativeStart().x();
    }

    public double maxX() {
        return this.relativeEnd().x();
    }

    public double minY() {
        return this.relativeStart().y();
    }

    public double maxY() {
        return this.relativeEnd().y();
    }

    public double minZ() {
        return this.relativeStart().z();
    }

    public double maxZ() {
        return this.relativeEnd().z();
    }

    public PointIterator getBlocks(Point point) {
        return new PointIterator(this, point, AxisMask.NONE, 0.0);
    }

    public PointIterator getBlocks(Point point, AxisMask axisMask, double axis) {
        return new PointIterator(this, point, axisMask, axis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (Double.compare(that.width, this.width) != 0) {
            return false;
        }
        if (Double.compare(that.height, this.height) != 0) {
            return false;
        }
        if (Double.compare(that.depth, this.depth) != 0) {
            return false;
        }
        return this.offset.equals(that.offset);
    }

    @Nullable
    public static BoundingBox fromPose(@NotNull Entity.Pose pose) {
        return switch (pose) {
            case Entity.Pose.FALL_FLYING, Entity.Pose.SWIMMING, Entity.Pose.SPIN_ATTACK -> smallBoundingBox;
            case Entity.Pose.SLEEPING, Entity.Pose.DYING -> sleepingBoundingBox;
            case Entity.Pose.SNEAKING -> sneakingBoundingBox;
            default -> null;
        };
    }

    @NotNull
    public static BoundingBox fromPoints(@NotNull Point a, @NotNull Point b) {
        Vec aVec = Vec.fromPoint(a);
        Vec min = aVec.min(b);
        Vec max = aVec.max(b);
        Vec dimensions = max.sub(min);
        return new BoundingBox(dimensions.x(), dimensions.y(), dimensions.z(), min);
    }

    public static class PointIterator
    implements Iterator<MutablePoint> {
        private double sx;
        private double sy;
        private double sz;
        double x;
        double y;
        double z;
        private double minX;
        private double minY;
        private double minZ;
        private double maxX;
        private double maxY;
        private double maxZ;
        private final MutablePoint point = new MutablePoint();

        public PointIterator() {
        }

        public PointIterator(BoundingBox boundingBox, Point p, AxisMask axisMask, double axis) {
            this.reset(boundingBox, p, axisMask, axis);
        }

        public void reset(BoundingBox boundingBox, double pointX, double pointY, double pointZ, AxisMask axisMask, int axis) {
            this.minX = (int)Math.floor(boundingBox.minX() + pointX);
            this.minY = (int)Math.floor(boundingBox.minY() + pointY);
            this.minZ = (int)Math.floor(boundingBox.minZ() + pointZ);
            this.maxX = (int)Math.floor(boundingBox.maxX() + pointX);
            this.maxY = (int)Math.floor(boundingBox.maxY() + pointY);
            this.maxZ = (int)Math.floor(boundingBox.maxZ() + pointZ);
            this.x = this.minX;
            this.y = this.minY;
            this.z = this.minZ;
            this.sx = boundingBox.minX() + pointX - this.minX;
            this.sy = boundingBox.minY() + pointY - this.minY;
            this.sz = boundingBox.minZ() + pointZ - this.minZ;
            if (axisMask == AxisMask.X) {
                this.minX = this.x = (double)axis + pointX;
                this.maxX = this.x;
            } else if (axisMask == AxisMask.Y) {
                this.minY = this.y = (double)axis + pointY;
                this.maxY = this.y;
            } else if (axisMask == AxisMask.Z) {
                this.minZ = this.z = (double)axis + pointZ;
                this.maxZ = this.z;
            }
        }

        public void reset(BoundingBox boundingBox, Point p, AxisMask axisMask, double axis) {
            this.reset(boundingBox, p.x(), p.y(), p.z(), axisMask, (int)axis);
        }

        public void reset(BoundingBox boundingBox, double x, double y, double z, AxisMask axisMask, double axis) {
            this.reset(boundingBox, x, y, z, axisMask, (int)axis);
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.maxX && this.y <= this.maxY && this.z <= this.maxZ;
        }

        @Override
        public MutablePoint next() {
            this.point.set(this.x + this.sx, this.y + this.sy, this.z + this.sz);
            this.x += 1.0;
            if (this.x > this.maxX) {
                this.x = this.minX;
                this.y += 1.0;
                if (this.y > this.maxY) {
                    this.y = this.minY;
                    this.z += 1.0;
                }
            }
            return this.point;
        }
    }

    public static enum AxisMask {
        X,
        Y,
        Z,
        NONE;

    }

    public static class MutablePoint {
        double x;
        double y;
        double z;

        public void set(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public double z() {
            return this.z;
        }

        public int blockX() {
            return (int)Math.floor(this.x);
        }

        public int blockY() {
            return (int)Math.floor(this.y);
        }

        public int blockZ() {
            return (int)Math.floor(this.z);
        }
    }
}

