/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.AnimalMeta;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public class SnifferMeta
extends AnimalMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 19;

    public SnifferMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public State getState() {
        return this.metadata.getIndex(17, State.IDLING);
    }

    public void setState(@NotNull State value) {
        this.metadata.setIndex(17, Metadata.SnifferState(value));
    }

    public int getDropSeedAtTick() {
        return this.metadata.getIndex(18, 0);
    }

    public void setDropSeedAtTick(int value) {
        this.metadata.setIndex(18, Metadata.VarInt(value));
    }

    public static enum State {
        IDLING,
        FEELING_HAPPY,
        SCENTING,
        SNIFFING,
        SEARCHING,
        DIGGING,
        RISING;

        public static final NetworkBuffer.Type<State> NETWORK_TYPE;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(State.class);
        }
    }
}

