/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.map;

import java.util.List;
import net.minestom.server.map.Framebuffer;
import net.minestom.server.network.packet.server.play.MapDataPacket;

public interface LargeFramebuffer {
    public int width();

    public int height();

    public Framebuffer createSubView(int var1, int var2);

    public byte getMapColor(int var1, int var2);

    default public MapDataPacket preparePacket(int mapId, int left, int top) {
        byte[] colors = new byte[16384];
        int width = Math.min(this.width(), left + 128) - left;
        int height = Math.min(this.height(), top + 128) - top;
        for (int y = top; y < top + height; ++y) {
            for (int x = left; x < left + width; ++x) {
                byte color;
                colors[Framebuffer.index((int)(x - left), (int)(y - top))] = color = this.getMapColor(x, y);
            }
        }
        return new MapDataPacket(mapId, 0, false, false, List.of(), new MapDataPacket.ColorContent((byte)width, (byte)height, 0, 0, colors));
    }
}

