/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.binary;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.Either;
import net.minestom.server.utils.binary.Writeable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class BinaryWriter
extends OutputStream {
    private final NetworkBuffer buffer;

    public BinaryWriter(@NotNull NetworkBuffer buffer) {
        this.buffer = buffer;
    }

    private BinaryWriter(ByteBuffer buffer, boolean resizable) {
        this.buffer = new NetworkBuffer(buffer, resizable);
    }

    public BinaryWriter(@NotNull ByteBuffer buffer) {
        this.buffer = new NetworkBuffer(buffer);
    }

    public BinaryWriter(int initialCapacity) {
        this(ByteBuffer.allocate(initialCapacity));
    }

    public BinaryWriter() {
        this(255);
    }

    @ApiStatus.Experimental
    public static BinaryWriter view(ByteBuffer buffer) {
        return new BinaryWriter(buffer, false);
    }

    public void writeComponent(@NotNull Component component) {
        this.buffer.write(NetworkBuffer.COMPONENT, component);
    }

    public void writeByte(byte b) {
        this.buffer.write(NetworkBuffer.BYTE, b);
    }

    public void writeBoolean(boolean b) {
        this.buffer.write(NetworkBuffer.BOOLEAN, b);
    }

    public void writeShort(short s) {
        this.buffer.write(NetworkBuffer.SHORT, s);
    }

    public void writeInt(int i) {
        this.buffer.write(NetworkBuffer.INT, i);
    }

    public void writeLong(long l) {
        this.buffer.write(NetworkBuffer.LONG, l);
    }

    public void writeFloat(float f) {
        this.buffer.write(NetworkBuffer.FLOAT, Float.valueOf(f));
    }

    public void writeDouble(double d) {
        this.buffer.write(NetworkBuffer.DOUBLE, d);
    }

    public void writeVarInt(int i) {
        this.buffer.write(NetworkBuffer.VAR_INT, i);
    }

    public void writeVarLong(long l) {
        this.buffer.write(NetworkBuffer.VAR_LONG, l);
    }

    public void writeSizedString(@NotNull String string) {
        this.buffer.write(NetworkBuffer.STRING, string);
    }

    public void writeNullTerminatedString(@NotNull String string, @NotNull Charset charset) {
        byte[] bytes = (string + "\u0000").getBytes(charset);
        this.writeBytes(bytes);
    }

    public void writeVarIntArray(int[] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (int element : array) {
            this.writeVarInt(element);
        }
    }

    public void writeVarLongArray(long[] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (long element : array) {
            this.writeVarLong(element);
        }
    }

    public void writeLongArray(long[] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (long element : array) {
            this.writeLong(element);
        }
    }

    public void writeByteArray(byte[] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        this.writeBytes(array);
    }

    public void writeBytes(byte @NotNull [] bytes) {
        this.buffer.write(NetworkBuffer.RAW_BYTES, bytes);
    }

    public void writeStringArray(@NotNull String[] array) {
        this.buffer.writeCollection(NetworkBuffer.STRING, array);
    }

    public void writeUuid(@NotNull UUID uuid) {
        this.buffer.write(NetworkBuffer.UUID, uuid);
    }

    public void writeBlockPosition(@NotNull Point point) {
        this.writeBlockPosition(point.blockX(), point.blockY(), point.blockZ());
    }

    public void writeBlockPosition(int x, int y, int z) {
        this.buffer.write(NetworkBuffer.BLOCK_POSITION, new Vec(x, y, z));
    }

    public void writeItemStack(@NotNull ItemStack itemStack) {
        this.buffer.write(ItemStack.NETWORK_TYPE, itemStack);
    }

    public void writeNBT(@NotNull String name, @NotNull BinaryTag tag) {
        this.buffer.write(NetworkBuffer.NBT, tag);
    }

    public <L, R> void writeEither(Either<L, R> either, BiConsumer<BinaryWriter, L> leftWriter, BiConsumer<BinaryWriter, R> rightWriter) {
        if (either.isLeft()) {
            this.writeBoolean(true);
            leftWriter.accept(this, either.left());
        } else {
            this.writeBoolean(false);
            rightWriter.accept(this, either.right());
        }
    }

    public void write(@NotNull Writeable writeable) {
        writeable.write(this);
    }

    public void write(@NotNull ByteBuffer buffer) {
        byte[] remaining = new byte[buffer.remaining()];
        buffer.get(remaining);
        this.writeBytes(remaining);
    }

    public void write(@NotNull BinaryWriter writer) {
        this.writeBytes(writer.toByteArray());
    }

    public void writeArray(@NotNull Writeable[] writeables) {
        this.writeVarInt(writeables.length);
        for (Writeable w : writeables) {
            this.write(w);
        }
    }

    public <T> void writeVarIntList(Collection<T> list, @NotNull BiConsumer<BinaryWriter, T> consumer) {
        this.writeVarInt(list.size());
        this.writeList(list, consumer);
    }

    public <T> void writeByteList(Collection<T> list, @NotNull BiConsumer<BinaryWriter, T> consumer) {
        this.writeByte((byte)list.size());
        this.writeList(list, consumer);
    }

    private <T> void writeList(Collection<T> list, @NotNull BiConsumer<BinaryWriter, T> consumer) {
        for (T t : list) {
            consumer.accept(this, (BinaryWriter)t);
        }
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.buffer.writeIndex()];
        this.buffer.copyTo(0, bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public void write(int b) {
        this.writeByte((byte)b);
    }

    public void writeUnsignedShort(int yourShort) {
        this.buffer.write(NetworkBuffer.SHORT, (short)(yourShort & 0xFFFF));
    }

    public static byte[] makeArray(@NotNull @NotNull Consumer<@NotNull BinaryWriter> writing) {
        BinaryWriter writer = new BinaryWriter();
        writing.accept(writer);
        return writer.toByteArray();
    }
}

