/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal.tameable;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.tameable.TameableAnimalMeta;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfMeta
extends TameableAnimalMeta {
    public WolfMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public boolean isBegging() {
        return this.metadata.get(MetadataDef.Wolf.IS_BEGGING);
    }

    public void setBegging(boolean value) {
        this.metadata.set(MetadataDef.Wolf.IS_BEGGING, value);
    }

    public int getCollarColor() {
        return this.metadata.get(MetadataDef.Wolf.COLLAR_COLOR);
    }

    public void setCollarColor(int value) {
        this.metadata.set(MetadataDef.Wolf.COLLAR_COLOR, value);
    }

    public int getAngerTime() {
        return this.metadata.get(MetadataDef.Wolf.ANGER_TIME);
    }

    public void setAngerTime(int value) {
        this.metadata.set(MetadataDef.Wolf.ANGER_TIME, value);
    }

    @NotNull
    public DynamicRegistry.Key<Variant> getVariant() {
        return this.metadata.get(MetadataDef.Wolf.VARIANT);
    }

    public void setVariant(@NotNull DynamicRegistry.Key<Variant> value) {
        this.metadata.set(MetadataDef.Wolf.VARIANT, value);
    }

    static final class VariantImpl
    extends Record
    implements Variant {
        @NotNull
        private final NamespaceID wildTexture;
        @NotNull
        private final NamespaceID tameTexture;
        @NotNull
        private final NamespaceID angryTexture;
        @NotNull
        private final List<String> biomes;
        @Nullable
        private final Registry.WolfVariantEntry registry;
        private static final BinaryTagSerializer<List<String>> BIOMES_NBT_TYPE = BinaryTagSerializer.STRING.list();
        static final BinaryTagSerializer<Variant> REGISTRY_NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
            throw new UnsupportedOperationException("WolfVariant is read-only");
        }, wolfVariant -> {
            Object biomes = wolfVariant.biomes().size() == 1 ? StringBinaryTag.stringBinaryTag((String)wolfVariant.biomes().getFirst()) : BIOMES_NBT_TYPE.write(wolfVariant.biomes());
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("wild_texture", wolfVariant.wildTexture().asString())).putString("tame_texture", wolfVariant.tameTexture().asString())).putString("angry_texture", wolfVariant.angryTexture().asString())).put("biomes", biomes)).build();
        });

        VariantImpl(@NotNull NamespaceID wildTexture, @NotNull NamespaceID tameTexture, @NotNull NamespaceID angryTexture, @NotNull List<String> biomes, @Nullable Registry.WolfVariantEntry registry) {
            Check.notNull(wildTexture, "missing wild texture");
            Check.notNull(tameTexture, "missing tame texture");
            Check.notNull(angryTexture, "missing angry texture");
            Check.notNull(biomes, "missing biomes");
            this.wildTexture = wildTexture;
            this.tameTexture = tameTexture;
            this.angryTexture = angryTexture;
            this.biomes = biomes;
            this.registry = registry;
        }

        VariantImpl(@NotNull Registry.WolfVariantEntry registry) {
            this(registry.wildTexture(), registry.tameTexture(), registry.angryTexture(), registry.biomes(), registry);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{VariantImpl.class, "wildTexture;tameTexture;angryTexture;biomes;registry", "wildTexture", "tameTexture", "angryTexture", "biomes", "registry"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{VariantImpl.class, "wildTexture;tameTexture;angryTexture;biomes;registry", "wildTexture", "tameTexture", "angryTexture", "biomes", "registry"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{VariantImpl.class, "wildTexture;tameTexture;angryTexture;biomes;registry", "wildTexture", "tameTexture", "angryTexture", "biomes", "registry"}, this, o);
        }

        @Override
        @NotNull
        public NamespaceID wildTexture() {
            return this.wildTexture;
        }

        @Override
        @NotNull
        public NamespaceID tameTexture() {
            return this.tameTexture;
        }

        @Override
        @NotNull
        public NamespaceID angryTexture() {
            return this.angryTexture;
        }

        @Override
        @NotNull
        public List<String> biomes() {
            return this.biomes;
        }

        @Override
        @Nullable
        public Registry.WolfVariantEntry registry() {
            return this.registry;
        }
    }

    public static sealed interface Variant
    extends ProtocolObject,
    WolfVariants
    permits VariantImpl {
        @NotNull
        public static final NetworkBuffer.Type<DynamicRegistry.Key<Variant>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::wolfVariant);
        @NotNull
        public static final BinaryTagSerializer<DynamicRegistry.Key<Variant>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::wolfVariant);

        @NotNull
        public static Variant create(@NotNull NamespaceID wildTexture, @NotNull NamespaceID tameTexture, @NotNull NamespaceID angryTexture, @NotNull String biome) {
            return new VariantImpl(wildTexture, tameTexture, angryTexture, List.of(biome), null);
        }

        @NotNull
        public static Builder builder() {
            return new Builder();
        }

        @ApiStatus.Internal
        @NotNull
        public static DynamicRegistry<Variant> createDefaultRegistry() {
            return DynamicRegistry.create("minecraft:wolf_variant", VariantImpl.REGISTRY_NBT_TYPE, Registry.Resource.WOLF_VARIANTS, (String namespace, Registry.Properties props) -> new VariantImpl(Registry.wolfVariant(namespace, props)));
        }

        @NotNull
        public NamespaceID wildTexture();

        @NotNull
        public NamespaceID tameTexture();

        @NotNull
        public NamespaceID angryTexture();

        @NotNull
        public List<String> biomes();

        @Override
        @Nullable
        public Registry.WolfVariantEntry registry();

        public static final class Builder {
            private NamespaceID wildTexture;
            private NamespaceID tameTexture;
            private NamespaceID angryTexture;
            private List<String> biomes;

            private Builder() {
            }

            @NotNull
            public Builder wildTexture(@NotNull NamespaceID wildTexture) {
                this.wildTexture = wildTexture;
                return this;
            }

            @NotNull
            public Builder tameTexture(@NotNull NamespaceID tameTexture) {
                this.tameTexture = tameTexture;
                return this;
            }

            @NotNull
            public Builder angryTexture(@NotNull NamespaceID angryTexture) {
                this.angryTexture = angryTexture;
                return this;
            }

            @NotNull
            public Builder biome(@NotNull String biome) {
                this.biomes = List.of(biome);
                return this;
            }

            @NotNull
            public Builder biomes(@NotNull List<String> biomes) {
                this.biomes = biomes;
                return this;
            }

            @NotNull
            public Variant build() {
                return new VariantImpl(this.wildTexture, this.tameTexture, this.angryTexture, this.biomes, null);
            }
        }
    }
}

