/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.heightmap.Heightmap;
import net.minestom.server.instance.heightmap.MotionBlockingHeightmap;
import net.minestom.server.instance.heightmap.WorldSurfaceHeightmap;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.play.ChunkDataPacket;
import net.minestom.server.network.packet.server.play.UpdateLightPacket;
import net.minestom.server.network.packet.server.play.data.ChunkData;
import net.minestom.server.network.packet.server.play.data.LightData;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.snapshot.ChunkSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.utils.ArrayUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicChunk
extends Chunk {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicChunk.class);
    protected List<Section> sections;
    private boolean needsCompleteHeightmapRefresh = true;
    protected Heightmap motionBlocking = new MotionBlockingHeightmap(this);
    protected Heightmap worldSurface = new WorldSurfaceHeightmap(this);
    protected final Int2ObjectOpenHashMap<Block> entries = new Int2ObjectOpenHashMap(0);
    protected final Int2ObjectOpenHashMap<Block> tickableMap = new Int2ObjectOpenHashMap(0);
    private long lastChange;
    final CachedPacket chunkCache = new CachedPacket(this::createChunkPacket);
    private static final DynamicRegistry<Biome> BIOME_REGISTRY = MinecraftServer.getBiomeRegistry();

    public DynamicChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        super(instance, chunkX, chunkZ, true);
        Section[] sectionsTemp = new Section[this.maxSection - this.minSection];
        Arrays.setAll(sectionsTemp, value -> new Section());
        this.sections = List.of(sectionsTemp);
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block, @Nullable BlockHandler.Placement placement, @Nullable BlockHandler.Destroy destroy) {
        DimensionType instanceDim = this.instance.getCachedDimensionType();
        if (y >= instanceDim.maxY() || y < instanceDim.minY()) {
            LOGGER.warn("tried to set a block outside the world bounds, should be within [{}, {}): {}", new Object[]{instanceDim.minY(), instanceDim.maxY(), y});
            return;
        }
        this.assertLock();
        this.lastChange = System.currentTimeMillis();
        this.chunkCache.invalidate();
        Section section = this.getSectionAt(y);
        int sectionRelativeX = CoordConversion.globalToSectionRelative(x);
        int sectionRelativeZ = CoordConversion.globalToSectionRelative(z);
        section.blockPalette().set(sectionRelativeX, CoordConversion.globalToSectionRelative(y), sectionRelativeZ, block.stateId());
        int index = CoordConversion.chunkBlockIndex(x, y, z);
        BlockHandler handler = block.handler();
        Block lastCachedBlock = handler != null || block.hasNbt() || block.registry().isBlockEntity() ? (Block)this.entries.put(index, (Object)block) : (Block)this.entries.remove(index);
        if (handler != null && handler.isTickable()) {
            this.tickableMap.put(index, (Object)block);
        } else {
            this.tickableMap.remove(index);
        }
        Vec blockPosition = new Vec(x, y, z);
        if (lastCachedBlock != null && lastCachedBlock.handler() != null) {
            lastCachedBlock.handler().onDestroy(Objects.requireNonNullElseGet(destroy, () -> new BlockHandler.Destroy(lastCachedBlock, this.instance, blockPosition)));
        }
        if (handler != null) {
            Vec absoluteBlockPosition = new Vec(this.getChunkX() * 16 + x, y, this.getChunkZ() * 16 + z);
            Block finalBlock = block;
            handler.onPlace(Objects.requireNonNullElseGet(placement, () -> new BlockHandler.Placement(finalBlock, this.instance, absoluteBlockPosition)));
        }
        if (this.needsCompleteHeightmapRefresh) {
            this.calculateFullHeightmap();
        }
        this.motionBlocking.refresh(sectionRelativeX, y, sectionRelativeZ, block);
        this.worldSurface.refresh(sectionRelativeX, y, sectionRelativeZ, block);
    }

    @Override
    public void setBiome(int x, int y, int z, @NotNull DynamicRegistry.Key<Biome> biome) {
        this.assertLock();
        this.chunkCache.invalidate();
        Section section = this.getSectionAt(y);
        int id = BIOME_REGISTRY.getId(biome.namespace());
        if (id == -1) {
            throw new IllegalStateException("Biome has not been registered: " + String.valueOf(biome.namespace()));
        }
        section.biomePalette().set(CoordConversion.globalToSectionRelative(x) / 4, CoordConversion.globalToSectionRelative(y) / 4, CoordConversion.globalToSectionRelative(z) / 4, id);
    }

    @Override
    @NotNull
    public List<Section> getSections() {
        return this.sections;
    }

    @Override
    @NotNull
    public Section getSection(int section) {
        return this.sections.get(section - this.minSection);
    }

    @Override
    @NotNull
    public Heightmap motionBlockingHeightmap() {
        return this.motionBlocking;
    }

    @Override
    @NotNull
    public Heightmap worldSurfaceHeightmap() {
        return this.worldSurface;
    }

    @Override
    public void loadHeightmapsFromNBT(CompoundBinaryTag heightmapsNBT) {
        LongArrayBinaryTag array;
        BinaryTag binaryTag = heightmapsNBT.get(this.motionBlockingHeightmap().NBTName());
        if (binaryTag instanceof LongArrayBinaryTag) {
            array = (LongArrayBinaryTag)binaryTag;
            this.motionBlockingHeightmap().loadFrom(array.value());
        }
        if ((binaryTag = heightmapsNBT.get(this.worldSurfaceHeightmap().NBTName())) instanceof LongArrayBinaryTag) {
            array = (LongArrayBinaryTag)binaryTag;
            this.worldSurfaceHeightmap().loadFrom(array.value());
        }
    }

    @Override
    public void tick(long time) {
        if (this.tickableMap.isEmpty()) {
            return;
        }
        this.tickableMap.int2ObjectEntrySet().fastForEach(entry -> {
            int index = entry.getIntKey();
            Block block = (Block)entry.getValue();
            BlockHandler handler = block.handler();
            if (handler == null) {
                return;
            }
            Point blockPosition = CoordConversion.chunkBlockIndexGetGlobal(index, this.chunkX, this.chunkZ);
            handler.tick(new BlockHandler.Tick(block, this.instance, blockPosition));
        });
    }

    @Override
    @Nullable
    public Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
        this.assertLock();
        if (y < this.minSection * 16 || y >= this.maxSection * 16) {
            return Block.AIR;
        }
        if (condition != Block.Getter.Condition.TYPE) {
            Block entry;
            Block block = entry = !this.entries.isEmpty() ? (Block)this.entries.get(CoordConversion.chunkBlockIndex(x, y, z)) : null;
            if (entry != null || condition == Block.Getter.Condition.CACHED) {
                return entry;
            }
        }
        Section section = this.getSectionAt(y);
        int blockStateId = section.blockPalette().get(CoordConversion.globalToSectionRelative(x), CoordConversion.globalToSectionRelative(y), CoordConversion.globalToSectionRelative(z));
        return Objects.requireNonNullElse(Block.fromStateId((short)blockStateId), Block.AIR);
    }

    @Override
    @NotNull
    public DynamicRegistry.Key<Biome> getBiome(int x, int y, int z) {
        this.assertLock();
        Section section = this.getSectionAt(y);
        int id = section.biomePalette().get(CoordConversion.globalToSectionRelative(x) / 4, CoordConversion.globalToSectionRelative(y) / 4, CoordConversion.globalToSectionRelative(z) / 4);
        DynamicRegistry.Key<Biome> biome = BIOME_REGISTRY.getKey((Biome)id);
        Check.notNull(biome, "Biome with id {0} is not registered", id);
        return biome;
    }

    @Override
    public long getLastChangeTime() {
        return this.lastChange;
    }

    @Override
    @NotNull
    public SendablePacket getFullDataPacket() {
        return this.chunkCache;
    }

    @Override
    @NotNull
    public Chunk copy(@NotNull Instance instance, int chunkX, int chunkZ) {
        DynamicChunk dynamicChunk = new DynamicChunk(instance, chunkX, chunkZ);
        dynamicChunk.sections = this.sections.stream().map(Section::clone).toList();
        dynamicChunk.entries.putAll(this.entries);
        return dynamicChunk;
    }

    @Override
    public void reset() {
        for (Section section : this.sections) {
            section.clear();
        }
        this.entries.clear();
    }

    @Override
    public void invalidate() {
        this.chunkCache.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ChunkDataPacket createChunkPacket() {
        byte[] data;
        CompoundBinaryTag heightmapsNBT;
        DynamicChunk dynamicChunk = this;
        synchronized (dynamicChunk) {
            heightmapsNBT = this.getHeightmapNBT();
            data = NetworkBuffer.makeArray(networkBuffer -> {
                for (Section section : this.sections) {
                    networkBuffer.write(NetworkBuffer.SHORT, (short)section.blockPalette().count());
                    networkBuffer.write(Palette.BLOCK_SERIALIZER, section.blockPalette());
                    networkBuffer.write(Palette.BIOME_SERIALIZER, section.biomePalette());
                }
            });
        }
        return new ChunkDataPacket(this.chunkX, this.chunkZ, new ChunkData(heightmapsNBT, data, (Map<Integer, Block>)this.entries), this.createLightData(true));
    }

    @NotNull
    UpdateLightPacket createLightPacket() {
        return new UpdateLightPacket(this.chunkX, this.chunkZ, this.createLightData(false));
    }

    protected LightData createLightData(boolean requiredFullChunk) {
        BitSet skyMask = new BitSet();
        BitSet blockMask = new BitSet();
        BitSet emptySkyMask = new BitSet();
        BitSet emptyBlockMask = new BitSet();
        ArrayList<byte[]> skyLights = new ArrayList<byte[]>();
        ArrayList<byte[]> blockLights = new ArrayList<byte[]>();
        int index = 0;
        for (Section section : this.sections) {
            ++index;
            byte[] skyLight = section.skyLight().array();
            byte[] blockLight = section.blockLight().array();
            if (skyLight.length != 0) {
                skyLights.add(skyLight);
                skyMask.set(index);
            } else {
                emptySkyMask.set(index);
            }
            if (blockLight.length != 0) {
                blockLights.add(blockLight);
                blockMask.set(index);
                continue;
            }
            emptyBlockMask.set(index);
        }
        return new LightData(skyMask, blockMask, emptySkyMask, emptyBlockMask, skyLights, blockLights);
    }

    protected CompoundBinaryTag getHeightmapNBT() {
        if (this.needsCompleteHeightmapRefresh) {
            this.calculateFullHeightmap();
        }
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putLongArray(this.motionBlocking.NBTName(), this.motionBlocking.getNBT())).putLongArray(this.worldSurface.NBTName(), this.worldSurface.getNBT())).build();
    }

    private void calculateFullHeightmap() {
        int startY = Heightmap.getHighestBlockSection(this);
        this.motionBlocking.refresh(startY);
        this.worldSurface.refresh(startY);
        this.needsCompleteHeightmapRefresh = false;
    }

    @Override
    @NotNull
    public ChunkSnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        Section[] clonedSections = new Section[this.sections.size()];
        for (int i = 0; i < clonedSections.length; ++i) {
            clonedSections[i] = this.sections.get(i).clone();
        }
        Collection<Entity> entities = this.instance.getEntityTracker().chunkEntities(this.chunkX, this.chunkZ, EntityTracker.Target.ENTITIES);
        int[] entityIds = ArrayUtils.mapToIntArray(entities, Entity::getEntityId);
        return new SnapshotImpl.Chunk(this.minSection, this.chunkX, this.chunkZ, clonedSections, (Int2ObjectOpenHashMap<Block>)this.entries.clone(), entityIds, updater.reference(this.instance), this.tagHandler().readableCopy());
    }

    private void assertLock() {
        assert (Thread.holdsLock(this)) : "Chunk must be locked before access";
    }
}

