/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.batch;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.LightingChunk;
import net.minestom.server.instance.batch.Batch;
import net.minestom.server.instance.batch.BatchOption;
import net.minestom.server.instance.batch.ChunkBatch;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbsoluteBlockBatch
implements Batch<Runnable> {
    private final Long2ObjectMap<ChunkBatch> chunkBatchesMap = new Long2ObjectOpenHashMap();
    protected final CountDownLatch readyLatch;
    private final BatchOption options;
    private volatile BatchOption inverseOption = new BatchOption();

    public AbsoluteBlockBatch() {
        this(new BatchOption());
    }

    public AbsoluteBlockBatch(BatchOption options) {
        this(options, true);
    }

    private AbsoluteBlockBatch(BatchOption options, boolean ready) {
        this.readyLatch = new CountDownLatch(ready ? 0 : 1);
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block) {
        ChunkBatch chunkBatch;
        int chunkX = CoordConversion.globalToChunk(x);
        int chunkZ = CoordConversion.globalToChunk(z);
        long chunkIndex = CoordConversion.chunkIndex(chunkX, chunkZ);
        Long2ObjectMap<ChunkBatch> long2ObjectMap = this.chunkBatchesMap;
        synchronized (long2ObjectMap) {
            chunkBatch = (ChunkBatch)this.chunkBatchesMap.computeIfAbsent(chunkIndex, i -> new ChunkBatch(this.options));
        }
        int relativeX = x - chunkX * 16;
        int relativeZ = z - chunkZ * 16;
        chunkBatch.setBlock(relativeX, y, relativeZ, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Long2ObjectMap<ChunkBatch> long2ObjectMap = this.chunkBatchesMap;
        synchronized (long2ObjectMap) {
            this.chunkBatchesMap.clear();
        }
    }

    @Override
    public boolean isReady() {
        return this.readyLatch.getCount() == 0L;
    }

    @Override
    public void awaitReady() {
        try {
            this.readyLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("#awaitReady interrupted!", e);
        }
    }

    public AbsoluteBlockBatch apply(@NotNull Instance instance, @Nullable Runnable callback) {
        return this.apply(instance, callback, true);
    }

    public AbsoluteBlockBatch unsafeApply(@NotNull Instance instance, @Nullable Runnable callback) {
        return this.apply(instance, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbsoluteBlockBatch apply(@NotNull Instance instance, @Nullable Runnable callback, boolean safeCallback) {
        if (!this.options.isUnsafeApply()) {
            this.awaitReady();
        }
        AbsoluteBlockBatch inverse = this.options.shouldCalculateInverse() ? new AbsoluteBlockBatch(this.inverseOption) : null;
        Long2ObjectMap<ChunkBatch> long2ObjectMap = this.chunkBatchesMap;
        synchronized (long2ObjectMap) {
            AtomicInteger counter = new AtomicInteger();
            ConcurrentHashMap.KeySetView updated = ConcurrentHashMap.newKeySet();
            for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.chunkBatchesMap)) {
                long chunkIndex = entry.getLongKey();
                int chunkX = CoordConversion.chunkIndexGetX(chunkIndex);
                int chunkZ = CoordConversion.chunkIndexGetZ(chunkIndex);
                ChunkBatch batch = (ChunkBatch)entry.getValue();
                ChunkBatch chunkInverse = batch.apply(instance, chunkX, chunkZ, c -> {
                    boolean isLast;
                    boolean bl = isLast = counter.incrementAndGet() == this.chunkBatchesMap.size();
                    if (isLast) {
                        if (inverse != null) {
                            inverse.readyLatch.countDown();
                        }
                        if (instance instanceof InstanceContainer) {
                            ((InstanceContainer)instance).refreshLastBlockChangeTime();
                        }
                        if (callback != null) {
                            if (safeCallback) {
                                instance.scheduleNextTick(inst -> callback.run());
                            } else {
                                callback.run();
                            }
                        }
                        HashSet<Chunk> expanded = new HashSet<Chunk>();
                        for (Chunk chunk : updated) {
                            for (int i = -1; i <= 1; ++i) {
                                for (int j = -1; j <= 1; ++j) {
                                    Chunk toAdd = instance.getChunk(chunk.getChunkX() + i, chunk.getChunkZ() + j);
                                    if (toAdd == null) continue;
                                    expanded.add(toAdd);
                                }
                            }
                        }
                        for (Chunk chunk : expanded) {
                            if (!(chunk instanceof LightingChunk)) continue;
                            LightingChunk dc = (LightingChunk)chunk;
                            dc.sendLighting();
                        }
                    }
                });
                if (inverse == null) continue;
                inverse.chunkBatchesMap.put(chunkIndex, (Object)chunkInverse);
            }
        }
        return inverse;
    }

    @NotNull
    public BatchOption getInverseOption() {
        return this.inverseOption;
    }

    public void setInverseOption(@NotNull BatchOption inverseOption) {
        this.inverseOption = inverseOption;
    }
}

