/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.List;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.predicate.BlockPredicate;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record BlockPredicates(@NotNull List<BlockPredicate> predicates, boolean showInTooltip) implements Predicate<Block>
{
    public static final BlockPredicates NEVER = new BlockPredicates(List.of(), false);
    public static final NetworkBuffer.Type<BlockPredicates> NETWORK_TYPE = new NetworkBuffer.Type<BlockPredicates>(){
        private static final NetworkBuffer.Type<List<BlockPredicate>> PREDICATE_LIST_TYPE = BlockPredicate.NETWORK_TYPE.list(Short.MAX_VALUE);

        @Override
        public void write(@NotNull NetworkBuffer buffer, BlockPredicates value) {
            buffer.write(PREDICATE_LIST_TYPE, value.predicates);
            buffer.write(NetworkBuffer.BOOLEAN, value.showInTooltip);
        }

        @Override
        public BlockPredicates read(@NotNull NetworkBuffer buffer) {
            return new BlockPredicates(buffer.read(PREDICATE_LIST_TYPE), (boolean)buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
    public static final BinaryTagSerializer<BlockPredicates> NBT_TYPE = new BinaryTagSerializer<BlockPredicates>(){
        private static final BinaryTagSerializer<List<BlockPredicate>> PREDICATES_LIST_TYPE = BlockPredicate.NBT_TYPE.list();

        @Override
        @NotNull
        public BinaryTag write(@NotNull BlockPredicates value) {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("predicates", PREDICATES_LIST_TYPE.write(value.predicates))).putBoolean("show_in_tooltip", value.showInTooltip)).build();
        }

        @Override
        @NotNull
        public BlockPredicates read(@NotNull BinaryTag tag) {
            if (!(tag instanceof CompoundBinaryTag)) {
                return NEVER;
            }
            CompoundBinaryTag compound = (CompoundBinaryTag)tag;
            BinaryTag predicatesTag = compound.get("predicates");
            List<BlockPredicate> predicates = predicatesTag != null ? PREDICATES_LIST_TYPE.read(predicatesTag) : List.of(BlockPredicate.NBT_TYPE.read(tag));
            boolean showInTooltip = compound.getBoolean("show_in_tooltip", true);
            return new BlockPredicates(predicates, showInTooltip);
        }
    };

    public BlockPredicates(@NotNull List<BlockPredicate> predicates, boolean showInTooltip) {
        predicates = List.copyOf(predicates);
    }

    public BlockPredicates(@NotNull List<BlockPredicate> predicates) {
        this(predicates, true);
    }

    public BlockPredicates(@NotNull BlockPredicate predicate) {
        this(List.of(predicate), true);
    }

    public BlockPredicates(@NotNull BlockPredicate predicate, boolean showInTooltip) {
        this(List.of(predicate), showInTooltip);
    }

    @NotNull
    public BlockPredicates withTooltip(boolean showInTooltip) {
        return new BlockPredicates(this.predicates, showInTooltip);
    }

    @Override
    public boolean test(Block block) {
        for (BlockPredicate predicate : this.predicates) {
            if (!predicate.test(block)) continue;
            return true;
        }
        return false;
    }
}

