/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.ToNumberPolicy;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.entity.EntitySpawnType;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.Material;
import net.minestom.server.message.ChatTypeDecoration;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.collection.ObjectArray;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Registry {
    @ApiStatus.Internal
    public static BlockEntry block(String namespace, @NotNull Properties main) {
        return new BlockEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static DimensionTypeEntry dimensionType(String namespace, @NotNull Properties main) {
        return new DimensionTypeEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static BiomeEntry biome(String namespace, Properties properties) {
        return new BiomeEntry(namespace, properties, null);
    }

    @ApiStatus.Internal
    public static MaterialEntry material(String namespace, @NotNull Properties main) {
        return new MaterialEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static EntityEntry entity(String namespace, @NotNull Properties main) {
        return new EntityEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static VillagerProfessionEntry villagerProfession(String namespace, @NotNull Properties main) {
        return new VillagerProfessionEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static FeatureFlagEntry featureFlag(String namespace, @NotNull Properties main) {
        return new FeatureFlagEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static PotionEffectEntry potionEffect(String namespace, @NotNull Properties main) {
        return new PotionEffectEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static DamageTypeEntry damageType(String namespace, @NotNull Properties main) {
        return new DamageTypeEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static TrimMaterialEntry trimMaterial(String namespace, @NotNull Properties main) {
        return new TrimMaterialEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static TrimPatternEntry trimPattern(String namespace, @NotNull Properties main) {
        return new TrimPatternEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static AttributeEntry attribute(String namespace, @NotNull Properties main) {
        return new AttributeEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static BannerPatternEntry bannerPattern(String namespace, @NotNull Properties main) {
        return new BannerPatternEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static WolfVariantEntry wolfVariant(String namespace, @NotNull Properties main) {
        return new WolfVariantEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static ChatTypeEntry chatType(String namespace, @NotNull Properties main) {
        return new ChatTypeEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static EnchantmentEntry enchantment(String namespace, @NotNull Properties main) {
        return new EnchantmentEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static PaintingVariantEntry paintingVariant(String namespace, @NotNull Properties main) {
        return new PaintingVariantEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static JukeboxSongEntry jukeboxSong(String namespace, @NotNull Properties main) {
        return new JukeboxSongEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static Map<String, Map<String, Object>> load(Resource resource) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        try (InputStream resourceStream = Registry.class.getClassLoader().getResourceAsStream(resource.name);){
            Check.notNull(resourceStream, "Resource {0} does not exist!", new Object[]{resource});
            try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceStream));){
                reader.beginObject();
                while (reader.hasNext()) {
                    map.put(reader.nextName(), (Map)Registry.readObject(reader));
                }
                reader.endObject();
            }
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
        return map;
    }

    @ApiStatus.Internal
    public static <T extends StaticProtocolObject> Container<T> createStaticContainer(Resource resource, Container.Loader<T> loader) {
        Map<String, Map<String, Object>> entries = Registry.load(resource);
        HashMap<String, StaticProtocolObject> namespaces = new HashMap<String, StaticProtocolObject>(entries.size());
        ObjectArray<StaticProtocolObject> ids = ObjectArray.singleThread(entries.size());
        for (Map.Entry<String, Map<String, Object>> entry : entries.entrySet()) {
            String namespace = entry.getKey();
            Properties properties = Properties.fromMap(entry.getValue());
            StaticProtocolObject value = (StaticProtocolObject)loader.get(namespace, properties);
            ids.set(value.id(), value);
            namespaces.put(value.name(), value);
        }
        return new Container(resource, namespaces, ids);
    }

    private static Object readObject(JsonReader reader) throws IOException {
        return switch (reader.peek()) {
            case JsonToken.BEGIN_ARRAY -> {
                ArrayList<Object> list = new ArrayList<Object>();
                reader.beginArray();
                while (reader.hasNext()) {
                    list.add(Registry.readObject(reader));
                }
                reader.endArray();
                yield list;
            }
            case JsonToken.BEGIN_OBJECT -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                reader.beginObject();
                while (reader.hasNext()) {
                    map.put(reader.nextName(), Registry.readObject(reader));
                }
                reader.endObject();
                yield map;
            }
            case JsonToken.STRING -> reader.nextString();
            case JsonToken.NUMBER -> ToNumberPolicy.LONG_OR_DOUBLE.readNumber(reader);
            case JsonToken.BOOLEAN -> reader.nextBoolean();
            default -> throw new IllegalStateException("Invalid peek: " + String.valueOf(reader.peek()));
        };
    }

    public static final class BlockEntry
    implements Entry {
        private final NamespaceID namespace;
        private final int id;
        private final int stateId;
        private final String translationKey;
        private final double hardness;
        private final double explosionResistance;
        private final double friction;
        private final double speedFactor;
        private final double jumpFactor;
        private final boolean air;
        private final boolean solid;
        private final boolean liquid;
        private final boolean occludes;
        private final boolean requiresTool;
        private final int lightEmission;
        private final boolean replaceable;
        private final String blockEntity;
        private final int blockEntityId;
        private final Supplier<Material> materialSupplier;
        private final Shape shape;
        private final boolean redstoneConductor;
        private final boolean signalSource;
        private final Properties custom;

        private BlockEntry(String namespace, Properties main, Properties custom) {
            this.custom = custom;
            this.namespace = NamespaceID.from(namespace);
            this.id = main.getInt("id");
            this.stateId = main.getInt("stateId");
            this.translationKey = main.getString("translationKey");
            this.hardness = main.getDouble("hardness");
            this.explosionResistance = main.getDouble("explosionResistance");
            this.friction = main.getDouble("friction");
            this.speedFactor = main.getDouble("speedFactor", 1.0);
            this.jumpFactor = main.getDouble("jumpFactor", 1.0);
            this.air = main.getBoolean("air", false);
            this.solid = main.getBoolean("solid");
            this.liquid = main.getBoolean("liquid", false);
            this.occludes = main.getBoolean("occludes", true);
            this.requiresTool = main.getBoolean("requiresTool", true);
            this.lightEmission = main.getInt("lightEmission", 0);
            this.replaceable = main.getBoolean("replaceable", false);
            Properties blockEntity = main.section("blockEntity");
            if (blockEntity != null) {
                this.blockEntity = blockEntity.getString("namespace");
                this.blockEntityId = blockEntity.getInt("id");
            } else {
                this.blockEntity = null;
                this.blockEntityId = 0;
            }
            String materialNamespace = main.getString("correspondingItem", null);
            this.materialSupplier = materialNamespace != null ? () -> Material.fromNamespaceId(materialNamespace) : () -> null;
            String collision = main.getString("collisionShape");
            String occlusion = main.getString("occlusionShape");
            this.shape = CollisionUtils.parseBlockShape(collision, occlusion, this);
            this.redstoneConductor = main.getBoolean("redstoneConductor");
            this.signalSource = main.getBoolean("signalSource", false);
        }

        @NotNull
        public NamespaceID namespace() {
            return this.namespace;
        }

        public int id() {
            return this.id;
        }

        public int stateId() {
            return this.stateId;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public double hardness() {
            return this.hardness;
        }

        public double explosionResistance() {
            return this.explosionResistance;
        }

        public double friction() {
            return this.friction;
        }

        public double speedFactor() {
            return this.speedFactor;
        }

        public double jumpFactor() {
            return this.jumpFactor;
        }

        public boolean isAir() {
            return this.air;
        }

        public boolean isSolid() {
            return this.solid;
        }

        public boolean isLiquid() {
            return this.liquid;
        }

        public boolean occludes() {
            return this.occludes;
        }

        public boolean requiresTool() {
            return this.requiresTool;
        }

        public int lightEmission() {
            return this.lightEmission;
        }

        public boolean isReplaceable() {
            return this.replaceable;
        }

        public boolean isBlockEntity() {
            return this.blockEntity != null;
        }

        @Nullable
        public String blockEntity() {
            return this.blockEntity;
        }

        public int blockEntityId() {
            return this.blockEntityId;
        }

        @Nullable
        public Material material() {
            return this.materialSupplier.get();
        }

        public boolean isRedstoneConductor() {
            return this.redstoneConductor;
        }

        public boolean isSignalSource() {
            return this.signalSource;
        }

        public Shape collisionShape() {
            return this.shape;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public static interface Properties
    extends Iterable<Map.Entry<String, Object>> {
        public static Properties fromMap(Map<String, Object> map) {
            return new PropertiesMap(map);
        }

        public String getString(String var1, String var2);

        public String getString(String var1);

        public double getDouble(String var1, double var2);

        public double getDouble(String var1);

        public int getInt(String var1, int var2);

        public int getInt(String var1);

        public float getFloat(String var1, float var2);

        public float getFloat(String var1);

        public boolean getBoolean(String var1, boolean var2);

        public boolean getBoolean(String var1);

        public List<List<Double>> getNestedDoubleArray(String var1);

        public Properties section(String var1);

        public boolean containsKey(String var1);

        public Map<String, Object> asMap();

        @Override
        @NotNull
        default public Iterator<Map.Entry<String, Object>> iterator() {
            return this.asMap().entrySet().iterator();
        }

        default public int size() {
            return this.asMap().size();
        }
    }

    public record DimensionTypeEntry(NamespaceID namespace, boolean ultrawarm, boolean natural, double coordinateScale, boolean hasSkylight, boolean hasCeiling, float ambientLight, Long fixedTime, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasRaids, int logicalHeight, int minY, int height, String infiniburn, String effects, Properties custom) implements Entry
    {
        public DimensionTypeEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getBoolean("ultrawarm"), main.getBoolean("natural"), main.getDouble("coordinate_scale"), main.getBoolean("has_skylight"), main.getBoolean("has_ceiling"), main.getFloat("ambient_light"), (Long)main.asMap().get("fixed_time"), main.getBoolean("piglin_safe"), main.getBoolean("bed_works"), main.getBoolean("respawn_anchor_works"), main.getBoolean("has_raids"), main.getInt("logical_height"), main.getInt("min_y"), main.getInt("height"), main.getString("infiniburn"), main.getString("effects"), custom);
        }
    }

    public static final class BiomeEntry
    implements Entry {
        private final Properties custom;
        private final NamespaceID namespace;
        private final Integer foliageColor;
        private final Integer grassColor;
        private final Integer skyColor;
        private final Integer waterColor;
        private final Integer waterFogColor;
        private final Integer fogColor;
        private final float temperature;
        private final float downfall;
        private final boolean hasPrecipitation;

        private BiomeEntry(String namespace, Properties main, Properties custom) {
            this.custom = custom;
            this.namespace = NamespaceID.from(namespace);
            this.foliageColor = main.containsKey("foliageColor") ? Integer.valueOf(main.getInt("foliageColor")) : null;
            this.grassColor = main.containsKey("grassColor") ? Integer.valueOf(main.getInt("grassColor")) : null;
            this.skyColor = main.containsKey("skyColor") ? Integer.valueOf(main.getInt("skyColor")) : null;
            this.waterColor = main.containsKey("waterColor") ? Integer.valueOf(main.getInt("waterColor")) : null;
            this.waterFogColor = main.containsKey("waterFogColor") ? Integer.valueOf(main.getInt("waterFogColor")) : null;
            this.fogColor = main.containsKey("fogColor") ? Integer.valueOf(main.getInt("fogColor")) : null;
            this.temperature = (float)main.getDouble("temperature", 0.5);
            this.downfall = (float)main.getDouble("downfall", 0.5);
            this.hasPrecipitation = main.getBoolean("has_precipitation", true);
        }

        @Override
        public Properties custom() {
            return this.custom;
        }

        @NotNull
        public NamespaceID namespace() {
            return this.namespace;
        }

        @Nullable
        public Integer foliageColor() {
            return this.foliageColor;
        }

        @Nullable
        public Integer grassColor() {
            return this.grassColor;
        }

        @Nullable
        public Integer skyColor() {
            return this.skyColor;
        }

        @Nullable
        public Integer waterColor() {
            return this.waterColor;
        }

        @Nullable
        public Integer waterFogColor() {
            return this.waterFogColor;
        }

        @Nullable
        public Integer fogColor() {
            return this.fogColor;
        }

        public float temperature() {
            return this.temperature;
        }

        public float downfall() {
            return this.downfall;
        }

        public boolean hasPrecipitation() {
            return this.hasPrecipitation;
        }
    }

    public static final class MaterialEntry
    implements Entry {
        private final NamespaceID namespace;
        private final Properties main;
        private final int id;
        private final String translationKey;
        private final Supplier<Block> blockSupplier;
        private DataComponentMap prototype;
        private final EquipmentSlot equipmentSlot;
        private final EntityType entityType;
        private final Properties custom;

        private MaterialEntry(String namespace, Properties main, Properties custom) {
            Properties spawnEggProperties;
            this.main = main;
            this.custom = custom;
            this.namespace = NamespaceID.from(namespace);
            this.id = main.getInt("id");
            this.translationKey = main.getString("translationKey");
            String blockNamespace = main.getString("correspondingBlock", null);
            this.blockSupplier = blockNamespace != null ? () -> Block.fromNamespaceId(blockNamespace) : () -> null;
            Properties armorProperties = main.section("armorProperties");
            if (armorProperties != null) {
                switch (armorProperties.getString("slot")) {
                    case "feet": {
                        this.equipmentSlot = EquipmentSlot.BOOTS;
                        break;
                    }
                    case "legs": {
                        this.equipmentSlot = EquipmentSlot.LEGGINGS;
                        break;
                    }
                    case "chest": {
                        this.equipmentSlot = EquipmentSlot.CHESTPLATE;
                        break;
                    }
                    case "head": {
                        this.equipmentSlot = EquipmentSlot.HELMET;
                        break;
                    }
                    default: {
                        this.equipmentSlot = null;
                        break;
                    }
                }
            } else {
                this.equipmentSlot = null;
            }
            this.entityType = (spawnEggProperties = main.section("spawnEggProperties")) != null ? EntityType.fromNamespaceId(spawnEggProperties.getString("entityType")) : null;
        }

        @NotNull
        public NamespaceID namespace() {
            return this.namespace;
        }

        public int id() {
            return this.id;
        }

        @NotNull
        public String translationKey() {
            return this.translationKey;
        }

        @Nullable
        public Block block() {
            return this.blockSupplier.get();
        }

        @NotNull
        public DataComponentMap prototype() {
            if (this.prototype == null) {
                try {
                    BinaryTagSerializer.ContextWithRegistries context = new BinaryTagSerializer.ContextWithRegistries(MinecraftServer.process(), false);
                    DataComponentMap.Builder builder = DataComponentMap.builder();
                    for (Map.Entry<String, Object> entry : this.main.section("components")) {
                        DataComponent<?> component = ItemComponent.fromNamespaceId(entry.getKey());
                        Check.notNull(component, "Unknown component {0} in {1}", entry.getKey(), this.namespace);
                        BinaryTag tag = TagStringIOExt.readTag((String)entry.getValue());
                        builder.set(component, component.read(context, tag));
                    }
                    this.prototype = builder.build();
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to parse material registry: " + String.valueOf(this.namespace), e);
                }
            }
            return this.prototype;
        }

        public boolean isArmor() {
            return this.equipmentSlot != null;
        }

        @Nullable
        public EquipmentSlot equipmentSlot() {
            return this.equipmentSlot;
        }

        @Nullable
        public EntityType spawnEntityType() {
            return this.entityType;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public static final class EntityEntry
    implements Entry {
        private final NamespaceID namespace;
        private final int id;
        private final String translationKey;
        private final double drag;
        private final double acceleration;
        private final EntitySpawnType spawnType;
        private final double width;
        private final double height;
        private final double eyeHeight;
        private final int clientTrackingRange;
        private final boolean fireImmune;
        private final Map<String, List<Double>> entityOffsets;
        private final BoundingBox boundingBox;
        private final Properties custom;

        public EntityEntry(String namespace, Properties main, Properties custom) {
            this.namespace = NamespaceID.from(namespace);
            this.id = main.getInt("id");
            this.translationKey = main.getString("translationKey");
            this.drag = main.getDouble("drag", 0.02);
            this.acceleration = main.getDouble("acceleration", 0.08);
            this.spawnType = EntitySpawnType.valueOf(main.getString("packetType").toUpperCase(Locale.ROOT));
            this.fireImmune = main.getBoolean("fireImmune", false);
            this.clientTrackingRange = main.getInt("clientTrackingRange");
            this.width = main.getDouble("width");
            this.height = main.getDouble("height");
            this.eyeHeight = main.getDouble("eyeHeight");
            this.boundingBox = new BoundingBox(this.width, this.height, this.width);
            this.entityOffsets = new HashMap<String, List<Double>>();
            Properties attachments = main.section("attachments");
            if (attachments != null) {
                Set<String> allAttachments = attachments.asMap().keySet();
                for (String key : allAttachments) {
                    List<List<Double>> offset = attachments.getNestedDoubleArray(key);
                    this.entityOffsets.put(key, offset.getFirst());
                }
            }
            this.custom = custom;
        }

        @NotNull
        public NamespaceID namespace() {
            return this.namespace;
        }

        public int id() {
            return this.id;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public double drag() {
            return this.drag;
        }

        public double acceleration() {
            return this.acceleration;
        }

        @NotNull
        public EntitySpawnType spawnType() {
            return this.spawnType;
        }

        public double width() {
            return this.width;
        }

        public double height() {
            return this.height;
        }

        public double eyeHeight() {
            return this.eyeHeight;
        }

        public boolean fireImmune() {
            return this.fireImmune;
        }

        public int clientTrackingRange() {
            return this.clientTrackingRange;
        }

        @Nullable
        public List<Double> entityAttachment(@NotNull String attachmentName) {
            return this.entityOffsets.get(attachmentName);
        }

        @NotNull
        public BoundingBox boundingBox() {
            return this.boundingBox;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public static final class VillagerProfessionEntry
    implements Entry {
        private final NamespaceID namespace;
        private final int id;
        private final SoundEvent workSound;
        private final Properties custom;

        public VillagerProfessionEntry(String namespace, Properties main, Properties custom) {
            this.namespace = NamespaceID.from(namespace);
            this.id = main.getInt("id");
            this.workSound = main.containsKey("workSound") ? SoundEvent.fromNamespaceId(main.getString("workSound")) : null;
            this.custom = custom;
        }

        @NotNull
        public NamespaceID namespace() {
            return this.namespace;
        }

        public int id() {
            return this.id;
        }

        @Nullable
        public SoundEvent workSound() {
            return this.workSound;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public record FeatureFlagEntry(NamespaceID namespace, int id, Properties custom) implements Entry
    {
        public FeatureFlagEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getInt("id"), null);
        }
    }

    public record PotionEffectEntry(NamespaceID namespace, int id, String translationKey, int color, boolean isInstantaneous, Properties custom) implements Entry
    {
        public PotionEffectEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getInt("id"), main.getString("translationKey"), main.getInt("color"), main.getBoolean("instantaneous"), custom);
        }
    }

    public record DamageTypeEntry(NamespaceID namespace, float exhaustion, String messageId, String scaling, @Nullable String effects, @Nullable String deathMessageType, Properties custom) implements Entry
    {
        public DamageTypeEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), (float)main.getDouble("exhaustion"), main.getString("message_id"), main.getString("scaling"), main.getString("effects"), main.getString("death_message_type"), custom);
        }
    }

    public record TrimMaterialEntry(@NotNull NamespaceID namespace, @NotNull String assetName, @NotNull Material ingredient, float itemModelIndex, @NotNull Map<String, String> overrideArmorMaterials, @NotNull Component description, Properties custom) implements Entry
    {
        public TrimMaterialEntry(@NotNull String namespace, @NotNull Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getString("asset_name"), Objects.requireNonNull(Material.fromNamespaceId(main.getString("ingredient"))), (float)main.getDouble("item_model_index"), ((Properties)Objects.requireNonNullElse(main.section("override_armor_materials"), new PropertiesMap(Map.of()))).asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)entry.getValue())), JSONComponentSerializer.json().deserialize((Object)main.section("description").toString()), custom);
        }
    }

    public record TrimPatternEntry(@NotNull NamespaceID namespace, @NotNull NamespaceID assetID, @NotNull Material template, @NotNull Component description, boolean decal, Properties custom) implements Entry
    {
        public TrimPatternEntry(@NotNull String namespace, @NotNull Properties main, Properties custom) {
            this(NamespaceID.from(namespace), NamespaceID.from(main.getString("asset_id")), Objects.requireNonNull(Material.fromNamespaceId(main.getString("template_item"))), JSONComponentSerializer.json().deserialize((Object)main.section("description").toString()), main.getBoolean("decal"), custom);
        }
    }

    public record AttributeEntry(NamespaceID namespace, int id, String translationKey, double defaultValue, boolean clientSync, double maxValue, double minValue, Properties custom) implements Entry
    {
        public AttributeEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getInt("id"), main.getString("translationKey"), main.getDouble("defaultValue"), main.getBoolean("clientSync"), main.getDouble("maxValue"), main.getDouble("minValue"), custom);
        }
    }

    public record BannerPatternEntry(NamespaceID namespace, NamespaceID assetId, String translationKey, Properties custom) implements Entry
    {
        public BannerPatternEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), NamespaceID.from(main.getString("asset_id")), main.getString("translation_key"), custom);
        }
    }

    public record WolfVariantEntry(NamespaceID namespace, NamespaceID wildTexture, NamespaceID tameTexture, NamespaceID angryTexture, List<String> biomes, Properties custom) implements Entry
    {
        public WolfVariantEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), NamespaceID.from(main.getString("wild_texture")), NamespaceID.from(main.getString("tame_texture")), NamespaceID.from(main.getString("angry_texture")), WolfVariantEntry.readBiomesList(main.asMap().get("biomes")), custom);
        }

        @NotNull
        private static List<String> readBiomesList(Object biomes) {
            if (biomes instanceof List) {
                List list = (List)biomes;
                return list.stream().map(Object::toString).collect(Collectors.toList());
            }
            if (biomes instanceof String) {
                String single = (String)biomes;
                return List.of(single);
            }
            throw new IllegalArgumentException("invalid biomes entry: " + String.valueOf(biomes));
        }
    }

    public static final class ChatTypeEntry
    implements Entry {
        private final NamespaceID namespace;
        private final ChatTypeDecoration chat;
        private final ChatTypeDecoration narration;
        private final Properties custom;

        public ChatTypeEntry(String namespace, Properties main, Properties custom) {
            this.namespace = NamespaceID.from(namespace);
            this.chat = ChatTypeEntry.readChatTypeDecoration(main.section("chat"));
            this.narration = ChatTypeEntry.readChatTypeDecoration(main.section("narration"));
            this.custom = custom;
        }

        public NamespaceID namespace() {
            return this.namespace;
        }

        public ChatTypeDecoration chat() {
            return this.chat;
        }

        public ChatTypeDecoration narration() {
            return this.narration;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }

        @NotNull
        private static ChatTypeDecoration readChatTypeDecoration(Properties properties) {
            ArrayList<ChatTypeDecoration.Parameter> parameters = new ArrayList<ChatTypeDecoration.Parameter>();
            Iterator iterator = properties.asMap().get("parameters");
            if (iterator instanceof List) {
                List paramList = (List)((Object)iterator);
                for (Object param : paramList) {
                    parameters.add(ChatTypeDecoration.Parameter.valueOf(param.toString().toUpperCase(Locale.ROOT)));
                }
            }
            Style style = Style.empty();
            if (properties.containsKey("style")) {
                Gson gson = GsonComponentSerializer.gson().serializer();
                JsonObject textComponentJson = gson.toJsonTree(properties.section("style").asMap()).getAsJsonObject();
                textComponentJson.addProperty("text", "IGNORED_VALUE");
                Component textComponent = GsonComponentSerializer.gson().deserializeFromTree((JsonElement)textComponentJson);
                style = textComponent.style();
            }
            return new ChatTypeDecoration(properties.getString("translation_key"), parameters, style);
        }
    }

    public record EnchantmentEntry(NamespaceID namespace, String raw, Properties custom) implements Entry
    {
        public EnchantmentEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getString("raw"), custom);
        }
    }

    public record PaintingVariantEntry(NamespaceID namespace, NamespaceID assetId, int width, int height, Properties custom) implements Entry
    {
        public PaintingVariantEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), NamespaceID.from(main.getString("asset_id")), main.getInt("width"), main.getInt("height"), custom);
        }
    }

    public record JukeboxSongEntry(NamespaceID namespace, SoundEvent soundEvent, Component description, float lengthInSeconds, int comparatorOutput, Properties custom) implements Entry
    {
        public JukeboxSongEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), SoundEvent.fromNamespaceId(main.getString("sound_event")), GsonComponentSerializer.gson().deserialize((Object)main.section("description").toString()), (float)main.getDouble("length_in_seconds"), main.getInt("comparator_output"), custom);
        }
    }

    @ApiStatus.Internal
    public static enum Resource {
        BLOCKS("blocks.json"),
        ITEMS("items.json"),
        ENTITIES("entities.json"),
        FEATURE_FLAGS("feature_flags.json"),
        SOUNDS("sounds.json"),
        STATISTICS("custom_statistics.json"),
        POTION_EFFECTS("potion_effects.json"),
        POTION_TYPES("potions.json"),
        PARTICLES("particles.json"),
        DAMAGE_TYPES("damage_types.json"),
        TRIM_MATERIALS("trim_materials.json"),
        TRIM_PATTERNS("trim_patterns.json"),
        BLOCK_TAGS("tags/block.json"),
        ENTITY_TYPE_TAGS("tags/entity_type.json"),
        FLUID_TAGS("tags/fluid.json"),
        GAMEPLAY_TAGS("tags/game_event.json"),
        ITEM_TAGS("tags/item.json"),
        ENCHANTMENT_TAGS("tags/enchantment.json"),
        BIOME_TAGS("tags/biome.json"),
        DIMENSION_TYPES("dimension_types.json"),
        BIOMES("biomes.json"),
        ATTRIBUTES("attributes.json"),
        BANNER_PATTERNS("banner_patterns.json"),
        WOLF_VARIANTS("wolf_variants.json"),
        CHAT_TYPES("chat_types.json"),
        ENCHANTMENTS("enchantments.snbt"),
        PAINTING_VARIANTS("painting_variants.json"),
        JUKEBOX_SONGS("jukebox_songs.json"),
        VILLAGER_PROFESSIONS("villager_professions.json");

        private final String name;

        private Resource(String name) {
            this.name = name;
        }

        @NotNull
        public String fileName() {
            return this.name;
        }
    }

    @ApiStatus.Internal
    public record Container<T extends StaticProtocolObject>(Resource resource, Map<String, T> namespaces, ObjectArray<T> ids) {
        public Container {
            namespaces = Map.copyOf(namespaces);
            ids.trim();
        }

        public T get(@NotNull String namespace) {
            return (T)((StaticProtocolObject)this.namespaces.get(namespace));
        }

        public T getSafe(@NotNull String namespace) {
            return this.get((String)(namespace.contains(":") ? namespace : "minecraft:" + namespace));
        }

        public T getId(int id) {
            return (T)((StaticProtocolObject)this.ids.get(id));
        }

        public int toId(@NotNull String namespace) {
            return this.get(namespace).id();
        }

        public Collection<T> values() {
            return this.namespaces.values();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Container)) {
                return false;
            }
            Container container = (Container)o;
            return this.resource == container.resource;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.resource});
        }

        public static interface Loader<T extends ProtocolObject> {
            public T get(String var1, Properties var2);
        }
    }

    record PropertiesMap(Map<String, Object> map) implements Properties
    {
        @Override
        public String getString(String name, String defaultValue) {
            Object element = this.element(name);
            return element != null ? (String)element : defaultValue;
        }

        @Override
        public String getString(String name) {
            return (String)this.element(name);
        }

        @Override
        public double getDouble(String name, double defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).doubleValue() : defaultValue;
        }

        @Override
        public double getDouble(String name) {
            return ((Number)this.element(name)).doubleValue();
        }

        @Override
        public int getInt(String name, int defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).intValue() : defaultValue;
        }

        @Override
        public int getInt(String name) {
            return ((Number)this.element(name)).intValue();
        }

        @Override
        public float getFloat(String name, float defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).floatValue() : defaultValue;
        }

        @Override
        public float getFloat(String name) {
            return ((Number)this.element(name)).floatValue();
        }

        @Override
        public boolean getBoolean(String name, boolean defaultValue) {
            Object element = this.element(name);
            return element != null ? (Boolean)element : defaultValue;
        }

        @Override
        public List<List<Double>> getNestedDoubleArray(String name) {
            Object element = this.element(name);
            return element != null ? (List)element : List.of();
        }

        @Override
        public boolean getBoolean(String name) {
            return (Boolean)this.element(name);
        }

        @Override
        public Properties section(String name) {
            Map map = (Map)this.element(name);
            if (map == null) {
                return null;
            }
            return new PropertiesMap(map);
        }

        @Override
        public boolean containsKey(String name) {
            return this.map.containsKey(name);
        }

        @Override
        public Map<String, Object> asMap() {
            return this.map;
        }

        private <T> T element(String name) {
            return (T)this.map.get(name);
        }

        @Override
        public String toString() {
            AtomicReference<String> string = new AtomicReference<String>("{ ");
            this.map.forEach((? super K s, ? super V object) -> string.set((String)string.get() + " , \"" + s + "\" : \"" + object.toString() + "\""));
            return string.updateAndGet(s -> s.replaceFirst(" , ", "") + "}");
        }
    }

    public static interface Entry {
        @ApiStatus.Experimental
        public Properties custom();
    }
}

