/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata;

import java.util.List;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.particle.Particle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivingEntityMeta
extends EntityMeta {
    protected LivingEntityMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public boolean isHandActive() {
        return this.metadata.get(MetadataDef.LivingEntity.IS_HAND_ACTIVE);
    }

    public void setHandActive(boolean value) {
        this.metadata.set(MetadataDef.LivingEntity.IS_HAND_ACTIVE, value);
    }

    @NotNull
    public PlayerHand getActiveHand() {
        return this.metadata.get(MetadataDef.LivingEntity.ACTIVE_HAND) != false ? PlayerHand.OFF : PlayerHand.MAIN;
    }

    public void setActiveHand(@NotNull PlayerHand hand) {
        this.metadata.set(MetadataDef.LivingEntity.ACTIVE_HAND, hand == PlayerHand.OFF);
    }

    public boolean isInRiptideSpinAttack() {
        return this.metadata.get(MetadataDef.LivingEntity.IS_RIPTIDE_SPIN_ATTACK);
    }

    public void setInRiptideSpinAttack(boolean value) {
        this.metadata.set(MetadataDef.LivingEntity.IS_RIPTIDE_SPIN_ATTACK, value);
    }

    public float getHealth() {
        return this.metadata.get(MetadataDef.LivingEntity.HEALTH).floatValue();
    }

    public void setHealth(float value) {
        this.metadata.set(MetadataDef.LivingEntity.HEALTH, Float.valueOf(value));
    }

    @NotNull
    public List<Particle> getEffectParticles() {
        return this.metadata.get(MetadataDef.LivingEntity.POTION_EFFECT_PARTICLES);
    }

    public void setEffectParticles(@NotNull List<Particle> value) {
        this.metadata.set(MetadataDef.LivingEntity.POTION_EFFECT_PARTICLES, value);
    }

    public boolean isPotionEffectAmbient() {
        return this.metadata.get(MetadataDef.LivingEntity.IS_POTION_EFFECT_AMBIANT);
    }

    public void setPotionEffectAmbient(boolean value) {
        this.metadata.set(MetadataDef.LivingEntity.IS_POTION_EFFECT_AMBIANT, value);
    }

    public int getArrowCount() {
        return this.metadata.get(MetadataDef.LivingEntity.NUMBER_OF_ARROWS);
    }

    public void setArrowCount(int value) {
        this.metadata.set(MetadataDef.LivingEntity.NUMBER_OF_ARROWS, value);
    }

    public int getBeeStingerCount() {
        return this.metadata.get(MetadataDef.LivingEntity.NUMBER_OF_BEE_STINGERS);
    }

    public void setBeeStingerCount(int value) {
        this.metadata.set(MetadataDef.LivingEntity.NUMBER_OF_BEE_STINGERS, value);
    }

    @Nullable
    public Point getBedInWhichSleepingPosition() {
        return this.metadata.get(MetadataDef.LivingEntity.LOCATION_OF_BED);
    }

    public void setBedInWhichSleepingPosition(@Nullable Point value) {
        this.metadata.set(MetadataDef.LivingEntity.LOCATION_OF_BED, value);
    }
}

