/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.color;

import java.util.Objects;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.color.AlphaColor;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public class Color
implements RGBLike {
    private static final int BIT_MASK = 255;
    public static final NetworkBuffer.Type<RGBLike> NETWORK_TYPE = new NetworkBuffer.Type<RGBLike>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, RGBLike value) {
            buffer.write(NetworkBuffer.INT, Color.fromRGBLike(value).asRGB());
        }

        @Override
        public RGBLike read(@NotNull NetworkBuffer buffer) {
            return new Color(buffer.read(NetworkBuffer.INT));
        }
    };
    public static final BinaryTagSerializer<RGBLike> NBT_TYPE = BinaryTagSerializer.INT.map(Color::new, color -> Color.fromRGBLike(color).asRGB());
    private final int red;
    private final int green;
    private final int blue;

    public Color(int red, int green, int blue) {
        Check.argCondition(!MathUtils.isBetween(red, 0, 255), "Red is not between 0-255: {0}", red);
        Check.argCondition(!MathUtils.isBetween(green, 0, 255), "Green is not between 0-255: {0}", green);
        Check.argCondition(!MathUtils.isBetween(blue, 0, 255), "Blue is not between 0-255: {0}", blue);
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Color(int rgb) {
        this(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public Color(@NotNull RGBLike rgbLike) {
        this(rgbLike.red(), rgbLike.green(), rgbLike.blue());
    }

    @NotNull
    public static Color fromRGBLike(@NotNull RGBLike rgbLike) {
        if (rgbLike instanceof Color) {
            Color color = (Color)rgbLike;
            return color;
        }
        return new Color(rgbLike.red(), rgbLike.green(), rgbLike.blue());
    }

    @NotNull
    public Color withRed(int red) {
        return new Color(red, this.green, this.blue);
    }

    @NotNull
    public Color withGreen(int green) {
        return new Color(this.red, green, this.blue);
    }

    @NotNull
    public Color withBlue(int blue) {
        return new Color(this.red, this.green, blue);
    }

    @NotNull
    public AlphaColor withAlpha(int alpha) {
        return new AlphaColor(alpha, this.red, this.green, this.blue);
    }

    public int asRGB() {
        int rgb = this.red;
        rgb = (rgb << 8) + this.green;
        return (rgb << 8) + this.blue;
    }

    @NotNull
    public Color mixWith(RGBLike ... colors) {
        int r = this.red;
        int g = this.green;
        int b = this.blue;
        int max = Math.max(Math.max(r, g), b);
        for (RGBLike color : colors) {
            r += color.red();
            g += color.green();
            b += color.blue();
            max += Math.max(Math.max(color.red(), color.green()), color.blue());
        }
        float count = colors.length + 1;
        float averageRed = (float)r / count;
        float averageGreen = (float)g / count;
        float averageBlue = (float)b / count;
        float averageMax = (float)max / count;
        float maximumOfAverages = Math.max(Math.max(averageRed, averageGreen), averageBlue);
        float gainFactor = averageMax / maximumOfAverages;
        r = Math.round(averageRed * gainFactor);
        g = Math.round(averageGreen * gainFactor);
        b = Math.round(averageBlue * gainFactor);
        return new Color(r, g, b);
    }

    @Deprecated
    public int getRed() {
        return this.red;
    }

    @Deprecated
    public int getGreen() {
        return this.green;
    }

    @Deprecated
    public int getBlue() {
        return this.blue;
    }

    public int red() {
        return this.red;
    }

    public int green() {
        return this.green;
    }

    public int blue() {
        return this.blue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Color that = (Color)obj;
        return this.red == that.red && this.green == that.green && this.blue == that.blue;
    }

    public int hashCode() {
        return Objects.hash(this.red, this.green, this.blue);
    }

    public String toString() {
        return "Color[red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + "]";
    }
}

