/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.attribute;

import java.util.Collection;
import net.minestom.server.entity.attribute.AttributeImpl;
import net.minestom.server.entity.attribute.Attributes;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Attribute
extends StaticProtocolObject,
Attributes
permits AttributeImpl {
    @NotNull
    public static final NetworkBuffer.Type<Attribute> NETWORK_TYPE = NetworkBuffer.VAR_INT.map(AttributeImpl::getId, Attribute::id);
    @NotNull
    public static final BinaryTagSerializer<Attribute> NBT_TYPE = BinaryTagSerializer.STRING.map(AttributeImpl::get, StaticProtocolObject::name);

    @Override
    @Contract(pure=true)
    @NotNull
    public Registry.AttributeEntry registry();

    @Override
    @NotNull
    default public NamespaceID namespace() {
        return this.registry().namespace();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    default public double defaultValue() {
        return this.registry().defaultValue();
    }

    default public double minValue() {
        return this.registry().minValue();
    }

    default public double maxValue() {
        return this.registry().maxValue();
    }

    default public boolean isSynced() {
        return this.registry().clientSync();
    }

    @NotNull
    public static @NotNull Collection<@NotNull Attribute> values() {
        return AttributeImpl.values();
    }

    @Nullable
    public static Attribute fromNamespaceId(@NotNull String namespaceID) {
        return AttributeImpl.getSafe(namespaceID);
    }

    @Nullable
    public static Attribute fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return Attribute.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static Attribute fromId(int id) {
        return AttributeImpl.getId(id);
    }
}

