/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.entity.attribute.AttributeOperation;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class AttributeInstance {
    public static final NetworkBuffer.Type<AttributeInstance> NETWORK_TYPE = new NetworkBuffer.Type<AttributeInstance>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, AttributeInstance value) {
            buffer.write(Attribute.NETWORK_TYPE, value.attribute());
            buffer.write(NetworkBuffer.DOUBLE, value.getBaseValue());
            buffer.writeCollection(AttributeModifier.NETWORK_TYPE, value.modifiers());
        }

        @Override
        public AttributeInstance read(@NotNull NetworkBuffer buffer) {
            return new AttributeInstance(buffer.read(Attribute.NETWORK_TYPE), buffer.read(NetworkBuffer.DOUBLE), buffer.readCollection(AttributeModifier.NETWORK_TYPE, Short.MAX_VALUE), null);
        }
    };
    private final Attribute attribute;
    private final Map<NamespaceID, AttributeModifier> modifiers;
    private final Collection<AttributeModifier> unmodifiableModifiers;
    private final AtomicLong baseValueBits;
    private final Consumer<AttributeInstance> propertyChangeListener;
    private volatile double cachedValue = 0.0;

    public AttributeInstance(@NotNull Attribute attribute, @Nullable Consumer<AttributeInstance> listener) {
        this(attribute, attribute.defaultValue(), new ArrayList<AttributeModifier>(), listener);
    }

    public AttributeInstance(@NotNull Attribute attribute, double baseValue, @NotNull Collection<AttributeModifier> modifiers, @Nullable Consumer<AttributeInstance> listener) {
        this.attribute = attribute;
        this.modifiers = new ConcurrentHashMap<NamespaceID, AttributeModifier>();
        for (AttributeModifier modifier : modifiers) {
            this.modifiers.put(modifier.id(), modifier);
        }
        this.unmodifiableModifiers = Collections.unmodifiableCollection(this.modifiers.values());
        this.baseValueBits = new AtomicLong(Double.doubleToLongBits(baseValue));
        this.propertyChangeListener = listener;
        this.refreshCachedValue(baseValue);
    }

    @NotNull
    public Attribute attribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return Double.longBitsToDouble(this.baseValueBits.get());
    }

    public void setBaseValue(double baseValue) {
        long newBits = Double.doubleToLongBits(baseValue);
        long oldBits = this.baseValueBits.getAndSet(newBits);
        if (oldBits != newBits) {
            this.refreshCachedValue(baseValue);
        }
    }

    @NotNull
    public @UnmodifiableView Collection<AttributeModifier> modifiers() {
        return this.unmodifiableModifiers;
    }

    public AttributeModifier addModifier(@NotNull AttributeModifier modifier) {
        AttributeModifier previousModifier = this.modifiers.put(modifier.id(), modifier);
        if (!modifier.equals(previousModifier)) {
            this.refreshCachedValue(this.getBaseValue());
        }
        return previousModifier;
    }

    public AttributeModifier removeModifier(@NotNull AttributeModifier modifier) {
        return this.removeModifier(modifier.id());
    }

    public void clearModifiers() {
        this.modifiers.values().removeIf(modifier -> !LivingEntity.PROTECTED_MODIFIERS.contains(modifier.id()));
        this.refreshCachedValue(this.getBaseValue());
    }

    public AttributeModifier removeModifier(@NotNull NamespaceID id) {
        AttributeModifier removed = this.modifiers.remove(id);
        if (removed != null) {
            this.refreshCachedValue(this.getBaseValue());
        }
        return removed;
    }

    public double getValue() {
        return this.cachedValue;
    }

    public double applyModifiers(double baseValue) {
        return this.computeValue(baseValue);
    }

    private double computeValue(double base) {
        Collection<AttributeModifier> modifiers = this.modifiers();
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.operation() == AttributeOperation.ADD_VALUE).toArray(AttributeModifier[]::new)) {
            base += modifier.amount();
        }
        double result = base;
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.operation() == AttributeOperation.MULTIPLY_BASE).toArray(AttributeModifier[]::new)) {
            result += base * modifier.amount();
        }
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.operation() == AttributeOperation.MULTIPLY_TOTAL).toArray(AttributeModifier[]::new)) {
            result *= 1.0 + modifier.amount();
        }
        return Math.clamp(result, this.getAttribute().minValue(), this.getAttribute().maxValue());
    }

    private void refreshCachedValue(double baseValue) {
        this.cachedValue = this.computeValue(baseValue);
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.accept(this);
        }
    }

    @Deprecated
    @NotNull
    public Collection<AttributeModifier> getModifiers() {
        return this.modifiers();
    }

    @Deprecated
    @NotNull
    public Attribute getAttribute() {
        return this.attribute;
    }
}

