/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata;

import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.LivingEntityMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerMeta
extends LivingEntityMeta {
    public static final byte OFFSET = 15;
    public static final byte MAX_OFFSET = 20;
    private static final byte CAPE_BIT = 1;
    private static final byte JACKET_BIT = 2;
    private static final byte LEFT_SLEEVE_BIT = 4;
    private static final byte RIGHT_SLEEVE_BIT = 8;
    private static final byte LEFT_LEG_BIT = 16;
    private static final byte RIGHT_LEG_BIT = 32;
    private static final byte HAT_BIT = 64;

    public PlayerMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public float getAdditionalHearts() {
        return this.metadata.getIndex(15, Float.valueOf(0.0f)).floatValue();
    }

    public void setAdditionalHearts(float value) {
        this.metadata.setIndex(15, Metadata.Float(value));
    }

    public int getScore() {
        return this.metadata.getIndex(16, 0);
    }

    public void setScore(int value) {
        this.metadata.setIndex(16, Metadata.VarInt(value));
    }

    public boolean isCapeEnabled() {
        return this.getMaskBit(17, (byte)1);
    }

    public void setCapeEnabled(boolean value) {
        this.setMaskBit(17, (byte)1, value);
    }

    public boolean isJacketEnabled() {
        return this.getMaskBit(17, (byte)2);
    }

    public void setJacketEnabled(boolean value) {
        this.setMaskBit(17, (byte)2, value);
    }

    public boolean isLeftSleeveEnabled() {
        return this.getMaskBit(17, (byte)4);
    }

    public void setLeftSleeveEnabled(boolean value) {
        this.setMaskBit(17, (byte)4, value);
    }

    public boolean isRightSleeveEnabled() {
        return this.getMaskBit(17, (byte)8);
    }

    public void setRightSleeveEnabled(boolean value) {
        this.setMaskBit(17, (byte)8, value);
    }

    public boolean isLeftLegEnabled() {
        return this.getMaskBit(17, (byte)16);
    }

    public void setLeftLegEnabled(boolean value) {
        this.setMaskBit(17, (byte)16, value);
    }

    public boolean isRightLegEnabled() {
        return this.getMaskBit(17, (byte)32);
    }

    public void setRightLegEnabled(boolean value) {
        this.setMaskBit(17, (byte)32, value);
    }

    public boolean isHatEnabled() {
        return this.getMaskBit(17, (byte)64);
    }

    public void setHatEnabled(boolean value) {
        this.setMaskBit(17, (byte)64, value);
    }

    public void setDisplayedSkinParts(byte skinDisplayByte) {
        this.metadata.setIndex(17, Metadata.Byte(skinDisplayByte));
    }

    public boolean isRightMainHand() {
        return this.metadata.getIndex(18, (byte)1) == 1;
    }

    public void setRightMainHand(boolean value) {
        this.metadata.setIndex(18, Metadata.Byte(value ? (byte)1 : 0));
    }

    @Nullable
    public BinaryTag getLeftShoulderEntityData() {
        return this.metadata.getIndex(19, null);
    }

    public void setLeftShoulderEntityData(@Nullable BinaryTag value) {
        if (value == null) {
            value = CompoundBinaryTag.empty();
        }
        this.metadata.setIndex(19, Metadata.NBT(value));
    }

    @Nullable
    public BinaryTag getRightShoulderEntityData() {
        return this.metadata.getIndex(20, null);
    }

    public void setRightShoulderEntityData(@Nullable BinaryTag value) {
        if (value == null) {
            value = CompoundBinaryTag.empty();
        }
        this.metadata.setIndex(20, Metadata.NBT(value));
    }
}

