/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalDouble;
import java.util.Set;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.pathfinding.PNode;
import net.minestom.server.entity.pathfinding.generators.NodeGenerator;
import net.minestom.server.instance.Instance;
import org.jetbrains.annotations.NotNull;

public class FlyingNodeGenerator
implements NodeGenerator {
    private PNode tempNode = null;

    @Override
    @NotNull
    public Collection<? extends PNode> getWalkable(@NotNull Instance instance, @NotNull Set<PNode> visited, @NotNull PNode current, @NotNull Point goal, @NotNull BoundingBox boundingBox) {
        double downPointZ;
        double downPointY;
        double downPointX;
        PNode nodeFall;
        double upPointZ;
        double upPointY;
        ArrayList<PNode> nearby = new ArrayList<PNode>();
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, current);
        int stepSize = (int)Math.max(Math.floor(boundingBox.width() / 2.0), 1.0);
        if (stepSize < 1) {
            stepSize = 1;
        }
        for (int x = -stepSize; x <= stepSize; ++x) {
            for (int z = -stepSize; z <= stepSize; ++z) {
                PNode nodeFall2;
                PNode nodeJump;
                if (x == 0 && z == 0) continue;
                double cost = Math.sqrt(x * x + z * z) * 0.98;
                double currentLevelPointX = (double)current.blockX() + 0.5 + (double)x;
                double currentLevelPointY = (double)current.blockY() + 0.5;
                double currentLevelPointZ = (double)current.blockZ() + 0.5 + (double)z;
                double upPointX = (double)current.blockX() + 0.5 + (double)x;
                double upPointY2 = (double)(current.blockY() + 1) + 0.5;
                double upPointZ2 = (double)current.blockZ() + 0.5 + (double)z;
                double downPointX2 = (double)current.blockX() + 0.5 + (double)x;
                double downPointY2 = (double)(current.blockY() - 1) + 0.5;
                double downPointZ2 = (double)current.blockZ() + 0.5 + (double)z;
                PNode nodeWalk = this.createFly(instance, new Vec(currentLevelPointX, currentLevelPointY, currentLevelPointZ), boundingBox, cost, current, goal, visited);
                if (nodeWalk != null && !visited.contains(nodeWalk)) {
                    nearby.add(nodeWalk);
                }
                if ((nodeJump = this.createFly(instance, new Vec(upPointX, upPointY2, upPointZ2), boundingBox, cost, current, goal, visited)) != null && !visited.contains(nodeJump)) {
                    nearby.add(nodeJump);
                }
                if ((nodeFall2 = this.createFly(instance, new Vec(downPointX2, downPointY2, downPointZ2), boundingBox, cost, current, goal, visited)) == null || visited.contains(nodeFall2)) continue;
                nearby.add(nodeFall2);
            }
        }
        double upPointX = current.x();
        PNode nodeJump = this.createFly(instance, new Vec(upPointX, upPointY = (double)(current.blockY() + 1) + 0.5, upPointZ = current.z()), boundingBox, 2.0, current, goal, visited);
        if (nodeJump != null && !visited.contains(nodeJump)) {
            nearby.add(nodeJump);
        }
        if ((nodeFall = this.createFly(instance, new Vec(downPointX = current.x(), downPointY = (double)(current.blockY() - 1) + 0.5, downPointZ = current.z()), boundingBox, 2.0, current, goal, visited)) != null && !visited.contains(nodeFall)) {
            nearby.add(nodeFall);
        }
        return nearby;
    }

    @Override
    public boolean hasGravitySnap() {
        return false;
    }

    private PNode createFly(Instance instance, Point point, BoundingBox boundingBox, double cost, PNode start, Point goal, Set<PNode> closed) {
        PNode n = this.newNode(start, cost, point, goal);
        if (closed.contains(n)) {
            return null;
        }
        if (!this.canMoveTowards(instance, new Vec(start.x(), start.y(), start.z()), point, boundingBox)) {
            return null;
        }
        n.setType(PNode.NodeType.FLY);
        return n;
    }

    private PNode newNode(PNode current, double cost, Point point, Point goal) {
        this.tempNode.setG(current.g() + cost);
        this.tempNode.setH(this.heuristic(point, goal));
        this.tempNode.setPoint(point.x(), point.y(), point.z());
        PNode newNode = this.tempNode;
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, PNode.NodeType.WALK, current);
        return newNode;
    }

    @Override
    @NotNull
    public OptionalDouble gravitySnap(@NotNull Instance instance, double pointX, double pointY, double pointZ, @NotNull BoundingBox boundingBox, double maxFall) {
        return OptionalDouble.of(pointY);
    }
}

