/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.batch;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.concurrent.CountDownLatch;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.batch.Batch;
import net.minestom.server.instance.batch.BatchOption;
import net.minestom.server.instance.block.Block;
import net.minestom.server.utils.callback.OptionalCallback;
import net.minestom.server.utils.chunk.ChunkCallback;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkBatch
implements Batch<ChunkCallback> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkBatch.class);
    private final Int2ObjectMap<Block> blocks = new Int2ObjectOpenHashMap();
    protected final CountDownLatch readyLatch;
    private final BatchOption options;

    public ChunkBatch() {
        this(new BatchOption());
    }

    public ChunkBatch(BatchOption options) {
        this(options, true);
    }

    private ChunkBatch(BatchOption options, boolean ready) {
        this.readyLatch = new CountDownLatch(ready ? 0 : 1);
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block) {
        int index = ChunkUtils.getBlockIndex(x, y, z);
        Int2ObjectMap<Block> int2ObjectMap = this.blocks;
        synchronized (int2ObjectMap) {
            this.blocks.put(index, (Object)block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Int2ObjectMap<Block> int2ObjectMap = this.blocks;
        synchronized (int2ObjectMap) {
            this.blocks.clear();
        }
    }

    @Override
    public boolean isReady() {
        return this.readyLatch.getCount() == 0L;
    }

    @Override
    public void awaitReady() {
        try {
            this.readyLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("#awaitReady interrupted!", e);
        }
    }

    public ChunkBatch apply(@NotNull Instance instance, @Nullable ChunkCallback callback) {
        return this.apply(instance, 0, 0, callback);
    }

    public ChunkBatch apply(@NotNull Instance instance, int chunkX, int chunkZ, @Nullable ChunkCallback callback) {
        Chunk chunk = instance.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            LOGGER.warn("Unable to apply ChunkBatch to unloaded chunk ({}, {}) in {}.", new Object[]{chunkX, chunkZ, instance.getUniqueId()});
            return null;
        }
        return this.apply(instance, chunk, callback);
    }

    public ChunkBatch apply(@NotNull Instance instance, @NotNull Chunk chunk, @Nullable ChunkCallback callback) {
        return this.apply(instance, chunk, callback, true);
    }

    public ChunkBatch unsafeApply(@NotNull Instance instance, @NotNull Chunk chunk, @Nullable ChunkCallback callback) {
        return this.apply(instance, chunk, callback, false);
    }

    protected ChunkBatch apply(@NotNull Instance instance, @NotNull Chunk chunk, @Nullable ChunkCallback callback, boolean safeCallback) {
        if (!this.options.isUnsafeApply()) {
            this.awaitReady();
        }
        ChunkBatch inverse = this.options.shouldCalculateInverse() ? new ChunkBatch(this.options, false) : null;
        BLOCK_BATCH_POOL.execute(() -> this.singleThreadFlush(instance, chunk, inverse, callback, safeCallback));
        return inverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void singleThreadFlush(Instance instance, Chunk chunk, @Nullable ChunkBatch inverse, @Nullable ChunkCallback callback, boolean safeCallback) {
        try {
            if (!chunk.isLoaded()) {
                LOGGER.warn("Unable to apply ChunkBatch to unloaded chunk ({}, {}) in {}.", new Object[]{chunk.getChunkX(), chunk.getChunkZ(), instance.getUniqueId()});
                return;
            }
            if (this.options.isFullChunk()) {
                chunk.reset();
            }
            if (this.blocks.isEmpty()) {
                OptionalCallback.execute(callback, chunk);
                return;
            }
            IntArraySet sections = new IntArraySet();
            Int2ObjectMap<Block> int2ObjectMap = this.blocks;
            synchronized (int2ObjectMap) {
                for (Int2ObjectMap.Entry entry : this.blocks.int2ObjectEntrySet()) {
                    int position = entry.getIntKey();
                    Block block = (Block)entry.getValue();
                    int section = this.apply(chunk, position, block, inverse);
                    sections.add(section);
                }
            }
            if (inverse != null) {
                inverse.readyLatch.countDown();
            }
            this.updateChunk(instance, chunk, (IntSet)sections, callback, safeCallback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int apply(@NotNull Chunk chunk, int index, Block block, @Nullable ChunkBatch inverse) {
        int x = ChunkUtils.blockIndexToChunkPositionX(index);
        int y = ChunkUtils.blockIndexToChunkPositionY(index);
        int z = ChunkUtils.blockIndexToChunkPositionZ(index);
        if (inverse != null) {
            Block prevBlock = chunk.getBlock(x, y, z);
            inverse.setBlock(x, y, z, prevBlock);
        }
        chunk.setBlock(x, y, z, block);
        return ChunkUtils.getChunkCoordinate(y);
    }

    private void updateChunk(@NotNull Instance instance, Chunk chunk, IntSet updatedSections, @Nullable ChunkCallback callback, boolean safeCallback) {
        if (this.options.shouldSendUpdate()) {
            chunk.sendChunk();
        }
        if (instance instanceof InstanceContainer) {
            ((InstanceContainer)instance).refreshLastBlockChangeTime();
        }
        if (callback != null) {
            if (safeCallback) {
                instance.scheduleNextTick(inst -> callback.accept(chunk));
            } else {
                callback.accept(chunk);
            }
        }
    }
}

