/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.common;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientPluginMessagePacket(@NotNull String channel, byte[] data) implements ClientPacket
{
    public ClientPluginMessagePacket(@NotNull String channel, byte[] data) {
        if (channel.length() > 256) {
            throw new IllegalArgumentException("Channel cannot be more than 256 characters long");
        }
    }

    public ClientPluginMessagePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.RAW_BYTES));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.channel);
        writer.write(NetworkBuffer.RAW_BYTES, this.data);
    }
}

