/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.CompletableFuture;
import net.minestom.server.timer.TaskScheduleImpl;
import org.jetbrains.annotations.NotNull;

public sealed interface TaskSchedule
permits TaskScheduleImpl.DurationSchedule, TaskScheduleImpl.FutureSchedule, TaskScheduleImpl.Immediate, TaskScheduleImpl.Park, TaskScheduleImpl.Stop, TaskScheduleImpl.TickSchedule {
    @NotNull
    public static TaskSchedule duration(@NotNull Duration duration) {
        return new TaskScheduleImpl.DurationSchedule(duration);
    }

    @NotNull
    public static TaskSchedule tick(int tick) {
        return new TaskScheduleImpl.TickSchedule(tick);
    }

    @NotNull
    public static TaskSchedule future(@NotNull CompletableFuture<?> future) {
        return new TaskScheduleImpl.FutureSchedule(future);
    }

    @NotNull
    public static TaskSchedule park() {
        return TaskScheduleImpl.PARK;
    }

    @NotNull
    public static TaskSchedule stop() {
        return TaskScheduleImpl.STOP;
    }

    @NotNull
    public static TaskSchedule immediate() {
        return TaskScheduleImpl.IMMEDIATE;
    }

    @NotNull
    public static TaskSchedule duration(long amount, @NotNull TemporalUnit unit) {
        return TaskSchedule.duration(Duration.of(amount, unit));
    }

    @NotNull
    public static TaskSchedule nextTick() {
        return TaskScheduleImpl.NEXT_TICK;
    }

    @NotNull
    public static TaskSchedule hours(long hours) {
        return TaskSchedule.duration(Duration.ofHours(hours));
    }

    @NotNull
    public static TaskSchedule minutes(long minutes) {
        return TaskSchedule.duration(Duration.ofMinutes(minutes));
    }

    @NotNull
    public static TaskSchedule seconds(long seconds) {
        return TaskSchedule.duration(Duration.ofSeconds(seconds));
    }

    @NotNull
    public static TaskSchedule millis(long millis) {
        return TaskSchedule.duration(Duration.ofMillis(millis));
    }
}

