/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.mojang;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.UUID;
import net.minestom.server.utils.url.URLUtils;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MojangUtils {
    private static final String FROM_UUID_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    private static final String FROM_USERNAME_URL = "https://api.mojang.com/users/profiles/minecraft/%s";

    @Blocking
    @NotNull
    public static UUID getUUID(String username) throws IOException {
        return UUID.fromString(MojangUtils.retrieve(String.format(FROM_USERNAME_URL, username)).get("id").getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
    }

    @Blocking
    @NotNull
    public static String getUsername(UUID playerUUID) throws IOException {
        return MojangUtils.retrieve(String.format(FROM_UUID_URL, playerUUID)).get("name").getAsString();
    }

    @Blocking
    @Nullable
    public static JsonObject fromUuid(@NotNull UUID uuid) {
        return MojangUtils.fromUuid(uuid.toString());
    }

    @Blocking
    @Nullable
    public static JsonObject fromUuid(@NotNull String uuid) {
        try {
            return MojangUtils.retrieve(String.format(FROM_UUID_URL, uuid));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Blocking
    @Nullable
    public static JsonObject fromUsername(@NotNull String username) {
        try {
            return MojangUtils.retrieve(String.format(FROM_USERNAME_URL, username));
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static JsonObject retrieve(@NotNull String url) throws IOException {
        String response = URLUtils.getText(url);
        if (response.isEmpty()) {
            throw new IOException("The Mojang API is down");
        }
        JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
        if (jsonObject.has("errorMessage")) {
            throw new IOException(jsonObject.get("errorMessage").getAsString());
        }
        return jsonObject;
    }
}

