/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.predicate;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.predicate.BlockTypeFilter;
import net.minestom.server.instance.block.predicate.PropertiesPredicate;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockPredicate(@Nullable BlockTypeFilter blocks, @Nullable PropertiesPredicate state, @Nullable CompoundBinaryTag nbt) implements Predicate<Block>
{
    public static final BlockPredicate ALL = new BlockPredicate(null, null, null);
    public static final BlockPredicate NONE = new BlockPredicate(null, new PropertiesPredicate(Map.of("no_such_property", new PropertiesPredicate.ValuePredicate.Exact("never"))), null);
    public static final NetworkBuffer.Type<BlockPredicate> NETWORK_TYPE = NetworkBufferTemplate.template(BlockTypeFilter.NETWORK_TYPE.optional(), BlockPredicate::blocks, PropertiesPredicate.NETWORK_TYPE.optional(), BlockPredicate::state, NetworkBuffer.NBT_COMPOUND.optional(), BlockPredicate::nbt, BlockPredicate::new);
    public static final BinaryTagSerializer<BlockPredicate> NBT_TYPE = new BinaryTagSerializer<BlockPredicate>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull BlockPredicate value) {
            CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
            if (value.blocks != null) {
                builder.put("blocks", BlockTypeFilter.NBT_TYPE.write(value.blocks));
            }
            if (value.state != null) {
                builder.put("state", PropertiesPredicate.NBT_TYPE.write(value.state));
            }
            if (value.nbt != null) {
                builder.put("nbt", (BinaryTag)value.nbt);
            }
            return builder.build();
        }

        @Override
        @NotNull
        public BlockPredicate read(@NotNull BinaryTag tag) {
            if (!(tag instanceof CompoundBinaryTag)) {
                return ALL;
            }
            CompoundBinaryTag compound = (CompoundBinaryTag)tag;
            BlockTypeFilter blocks = null;
            BinaryTag entry = compound.get("blocks");
            if (entry != null) {
                blocks = BlockTypeFilter.NBT_TYPE.read(entry);
            }
            PropertiesPredicate state = null;
            entry = compound.get("state");
            if (entry != null) {
                state = PropertiesPredicate.NBT_TYPE.read(entry);
            }
            CompoundBinaryTag nbt = null;
            entry = compound.get("nbt");
            if (entry != null) {
                nbt = BinaryTagSerializer.COMPOUND_COERCED.read(entry);
            }
            return new BlockPredicate(blocks, state, nbt);
        }
    };

    public BlockPredicate(@NotNull BlockTypeFilter blocks) {
        this(blocks, null, null);
    }

    public BlockPredicate(Block ... blocks) {
        this(new BlockTypeFilter.Blocks(blocks));
    }

    public BlockPredicate(@NotNull PropertiesPredicate state) {
        this(null, state, null);
    }

    public BlockPredicate(@NotNull CompoundBinaryTag nbt) {
        this(null, null, nbt);
    }

    @Override
    public boolean test(@NotNull Block block) {
        if (this.blocks != null && !this.blocks.test(block)) {
            return false;
        }
        if (this.state != null && !this.state.test(block)) {
            return false;
        }
        return this.nbt == null || Objects.equals(this.nbt, BlockUtils.extractClientNbt(block));
    }
}

