/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.predicate;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PropertiesPredicate(@NotNull Map<String, ValuePredicate> properties) implements Predicate<Block>
{
    public static final NetworkBuffer.Type<PropertiesPredicate> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.STRING.mapValue(ValuePredicate.NETWORK_TYPE), PropertiesPredicate::properties, PropertiesPredicate::new);
    public static final BinaryTagSerializer<PropertiesPredicate> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        HashMap<String, ValuePredicate> properties = new HashMap<String, ValuePredicate>();
        for (Map.Entry entry : tag) {
            properties.put((String)entry.getKey(), ValuePredicate.NBT_TYPE.read((BinaryTag)entry.getValue()));
        }
        return new PropertiesPredicate(properties);
    }, value -> {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        for (Map.Entry<String, ValuePredicate> entry : value.properties.entrySet()) {
            builder.put(entry.getKey(), ValuePredicate.NBT_TYPE.write(entry.getValue()));
        }
        return builder.build();
    });

    public PropertiesPredicate(@NotNull Map<String, ValuePredicate> properties) {
        properties = Map.copyOf(properties);
    }

    @NotNull
    public static PropertiesPredicate exact(@NotNull String key, @NotNull String value) {
        return new PropertiesPredicate(Map.of(key, new ValuePredicate.Exact(value)));
    }

    @Override
    public boolean test(@NotNull Block block) {
        for (Map.Entry<String, ValuePredicate> entry : this.properties.entrySet()) {
            String value = block.getProperty(entry.getKey());
            if (entry.getValue().test(value)) continue;
            return false;
        }
        return true;
    }

    public static sealed interface ValuePredicate
    extends Predicate<String> {
        public static final NetworkBuffer.Type<ValuePredicate> NETWORK_TYPE = new NetworkBuffer.Type<ValuePredicate>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, ValuePredicate value) {
                ValuePredicate valuePredicate = value;
                Objects.requireNonNull(valuePredicate);
                ValuePredicate valuePredicate2 = valuePredicate;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class}, (Object)valuePredicate2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Exact exact = (Exact)valuePredicate2;
                        buffer.write(NetworkBuffer.BOOLEAN, true);
                        buffer.write(Exact.NETWORK_TYPE, exact);
                        break;
                    }
                    case 1: {
                        Range range = (Range)valuePredicate2;
                        buffer.write(NetworkBuffer.BOOLEAN, false);
                        buffer.write(Range.NETWORK_TYPE, range);
                    }
                }
            }

            @Override
            public ValuePredicate read(@NotNull NetworkBuffer buffer) {
                return buffer.read(NetworkBuffer.BOOLEAN) != false ? (ValuePredicate)buffer.read(Exact.NETWORK_TYPE) : (ValuePredicate)buffer.read(Range.NETWORK_TYPE);
            }
        };
        public static final BinaryTagSerializer<ValuePredicate> NBT_TYPE = new BinaryTagSerializer<ValuePredicate>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull ValuePredicate value) {
                ValuePredicate valuePredicate = value;
                Objects.requireNonNull(valuePredicate);
                ValuePredicate valuePredicate2 = valuePredicate;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class}, (Object)valuePredicate2, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        Exact exact = (Exact)valuePredicate2;
                        yield Exact.NBT_TYPE.write(exact);
                    }
                    case 1 -> {
                        Range range = (Range)valuePredicate2;
                        yield Range.NBT_TYPE.write(range);
                    }
                };
            }

            @Override
            @NotNull
            public ValuePredicate read(@NotNull BinaryTag tag) {
                if (tag instanceof StringBinaryTag) {
                    return Exact.NBT_TYPE.read(tag);
                }
                return Range.NBT_TYPE.read(tag);
            }
        };

        public record Range(@Nullable String min, @Nullable String max) implements ValuePredicate
        {
            public static final NetworkBuffer.Type<Range> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.STRING.optional(), Range::min, NetworkBuffer.STRING.optional(), Range::max, Range::new);
            public static final BinaryTagSerializer<Range> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
                String string;
                String string2;
                StringBinaryTag string3;
                BinaryTag patt0$temp = tag.get("min");
                if (patt0$temp instanceof StringBinaryTag) {
                    string3 = (StringBinaryTag)patt0$temp;
                    string2 = string3.value();
                } else {
                    string2 = null;
                }
                BinaryTag patt1$temp = tag.get("max");
                if (patt1$temp instanceof StringBinaryTag) {
                    string3 = (StringBinaryTag)patt1$temp;
                    string = string3.value();
                } else {
                    string = null;
                }
                return new Range(string2, string);
            }, value -> {
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                if (value.min != null) {
                    builder.putString("min", value.min);
                }
                if (value.max != null) {
                    builder.putString("max", value.max);
                }
                return builder.build();
            });

            @Override
            public boolean test(@Nullable String prop) {
                if (prop == null || this.min == null && this.max == null) {
                    return false;
                }
                try {
                    int value = Integer.parseInt(prop);
                    return !(this.min != null && value < Integer.parseInt(this.min) || this.max != null && value >= Integer.parseInt(this.max));
                }
                catch (NumberFormatException e) {
                    return !(this.min != null && prop.compareTo(this.min) < 0 || this.max != null && prop.compareTo(this.max) >= 0);
                }
            }
        }

        public record Exact(@Nullable String value) implements ValuePredicate
        {
            public static final NetworkBuffer.Type<Exact> NETWORK_TYPE = NetworkBuffer.STRING.transform(Exact::new, Exact::value);
            public static final BinaryTagSerializer<Exact> NBT_TYPE = BinaryTagSerializer.STRING.map(Exact::new, Exact::value);

            @Override
            public boolean test(@Nullable String prop) {
                return prop != null && prop.equals(this.value);
            }
        }
    }
}

