/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record EntityPositionAndRotationPacket(int entityId, short deltaX, short deltaY, short deltaZ, float yaw, float pitch, boolean onGround) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<EntityPositionAndRotationPacket> SERIALIZER = new NetworkBuffer.Type<EntityPositionAndRotationPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, EntityPositionAndRotationPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            buffer.write(NetworkBuffer.SHORT, value.deltaX);
            buffer.write(NetworkBuffer.SHORT, value.deltaY);
            buffer.write(NetworkBuffer.SHORT, value.deltaZ);
            buffer.write(NetworkBuffer.BYTE, (byte)(value.yaw * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BYTE, (byte)(value.pitch * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BOOLEAN, value.onGround);
        }

        @Override
        public EntityPositionAndRotationPacket read(@NotNull NetworkBuffer buffer) {
            return new EntityPositionAndRotationPacket(buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.SHORT), buffer.read(NetworkBuffer.SHORT), buffer.read(NetworkBuffer.SHORT), (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, buffer.read(NetworkBuffer.BOOLEAN));
        }
    };

    public static EntityPositionAndRotationPacket getPacket(int entityId, @NotNull Pos newPosition, @NotNull Pos oldPosition, boolean onGround) {
        short deltaX = (short)((newPosition.x() * 32.0 - oldPosition.x() * 32.0) * 128.0);
        short deltaY = (short)((newPosition.y() * 32.0 - oldPosition.y() * 32.0) * 128.0);
        short deltaZ = (short)((newPosition.z() * 32.0 - oldPosition.z() * 32.0) * 128.0);
        return new EntityPositionAndRotationPacket(entityId, deltaX, deltaY, deltaZ, newPosition.yaw(), newPosition.pitch(), onGround);
    }
}

