/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minestom.server.item.Material;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.recipe.display.SlotDisplay;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Ingredient(@NotNull @NotNull List<@NotNull Material> items) {
    public static final NetworkBuffer.Type<Ingredient> NETWORK_TYPE = NetworkBufferTemplate.template(new NetworkBuffer.Type<List<Material>>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, List<Material> value) {
            buffer.write(NetworkBuffer.VAR_INT, value.size() + 1);
            for (Material material : value) {
                buffer.write(Material.NETWORK_TYPE, material);
            }
        }

        @Override
        public List<Material> read(@NotNull NetworkBuffer buffer) {
            int size = buffer.read(NetworkBuffer.VAR_INT) - 1;
            Check.notNull(size > Short.MAX_VALUE, "too many ingredients");
            if (size == -1) {
                throw new UnsupportedOperationException("cannot read ingredient tags yet");
            }
            ArrayList<Material> materials = new ArrayList<Material>(size);
            for (int i = 0; i < size; ++i) {
                materials.add(buffer.read(Material.NETWORK_TYPE));
            }
            return materials;
        }
    }, Ingredient::items, Ingredient::new);

    public Ingredient(@NotNull List<Material> items) {
        items = List.copyOf(items);
        Check.argCondition(items.isEmpty(), "Ingredients can't be empty");
        Check.argCondition(items.contains(Material.AIR), "Ingredient can't contain air");
    }

    public Ingredient(Material ... items) {
        this(List.of(items));
    }

    @Nullable
    public static Ingredient fromSlotDisplay(@NotNull SlotDisplay slotDisplay) {
        SlotDisplay slotDisplay2 = slotDisplay;
        Objects.requireNonNull(slotDisplay2);
        SlotDisplay slotDisplay3 = slotDisplay2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SlotDisplay.Item.class, SlotDisplay.Tag.class}, (Object)slotDisplay3, n)) {
            case 0 -> {
                SlotDisplay.Item item = (SlotDisplay.Item)slotDisplay3;
                yield new Ingredient(item.material());
            }
            case 1 -> {
                SlotDisplay.Tag ignored = (SlotDisplay.Tag)slotDisplay3;
                yield null;
            }
            default -> null;
        };
    }
}

