/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe.display;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public enum SlotDisplayType implements StaticProtocolObject
{
    EMPTY(NamespaceID.from("minecraft:empty")),
    ANY_FUEL(NamespaceID.from("minecraft:any_fuel")),
    ITEM(NamespaceID.from("minecraft:item")),
    ITEM_STACK(NamespaceID.from("minecraft:item_stack")),
    TAG(NamespaceID.from("minecraft:tag")),
    SMITHING_TRIM(NamespaceID.from("minecraft:smithing_trim")),
    WITH_REMAINDER(NamespaceID.from("minecraft:with_remainder")),
    COMPOSITE(NamespaceID.from("minecraft:composite"));

    public static final NetworkBuffer.Type<SlotDisplayType> NETWORK_TYPE;
    public static final BinaryTagSerializer<SlotDisplayType> NBT_TYPE;
    private final NamespaceID namespace;

    private SlotDisplayType(NamespaceID namespace) {
        this.namespace = namespace;
    }

    @Override
    @NotNull
    public NamespaceID namespace() {
        return this.namespace;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        NETWORK_TYPE = NetworkBuffer.Enum(SlotDisplayType.class);
        NBT_TYPE = BinaryTagSerializer.fromEnumKeyed(SlotDisplayType.class);
    }
}

