/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.RayUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.NotNull;

public final class ShapeImpl
implements Shape {
    private static final Pattern PATTERN = Pattern.compile("\\d.\\d+", 8);
    private final BoundingBox[] collisionBoundingBoxes;
    private final Point relativeStart;
    private final Point relativeEnd;
    private final byte fullFaces;
    private final BoundingBox[] occlusionBoundingBoxes;
    private final byte blockOcclusion;
    private final byte airOcclusion;
    private final Registry.BlockEntry blockEntry;
    private Block block;

    private ShapeImpl(BoundingBox[] boundingBoxes, BoundingBox[] occlusionBoundingBoxes, Registry.BlockEntry blockEntry) {
        this.collisionBoundingBoxes = boundingBoxes;
        this.occlusionBoundingBoxes = occlusionBoundingBoxes;
        this.blockEntry = blockEntry;
        if (this.collisionBoundingBoxes.length > 0) {
            double minX = 1.0;
            double minY = 1.0;
            double minZ = 1.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxZ = 0.0;
            for (BoundingBox blockSection : this.collisionBoundingBoxes) {
                if (blockSection.minX() < minX) {
                    minX = blockSection.minX();
                }
                if (blockSection.minY() < minY) {
                    minY = blockSection.minY();
                }
                if (blockSection.minZ() < minZ) {
                    minZ = blockSection.minZ();
                }
                if (blockSection.maxX() > maxX) {
                    maxX = blockSection.maxX();
                }
                if (blockSection.maxY() > maxY) {
                    maxY = blockSection.maxY();
                }
                if (!(blockSection.maxZ() > maxZ)) continue;
                maxZ = blockSection.maxZ();
            }
            this.relativeStart = new Vec(minX, minY, minZ);
            this.relativeEnd = new Vec(maxX, maxY, maxZ);
        } else {
            this.relativeStart = Vec.ZERO;
            this.relativeEnd = Vec.ZERO;
        }
        byte fullCollisionFaces = 0;
        for (BlockFace f : BlockFace.values()) {
            byte res = ShapeImpl.isFaceCovered(ShapeImpl.computeOcclusionSet(f, this.collisionBoundingBoxes));
            fullCollisionFaces = (byte)(fullCollisionFaces | (res == 2 ? (byte)1 : 0) << (byte)f.ordinal());
        }
        this.fullFaces = fullCollisionFaces;
        byte airFaces = 0;
        byte fullFaces = 0;
        for (BlockFace f : BlockFace.values()) {
            byte res = ShapeImpl.isFaceCovered(ShapeImpl.computeOcclusionSet(f, occlusionBoundingBoxes));
            airFaces = (byte)(airFaces | (res == 0 ? (byte)1 : 0) << (byte)f.ordinal());
            fullFaces = (byte)(fullFaces | (res == 2 ? (byte)1 : 0) << (byte)f.ordinal());
        }
        this.airOcclusion = airFaces;
        this.blockOcclusion = fullFaces;
    }

    private static BoundingBox[] parseRegistryBoundingBoxString(String str) {
        Matcher matcher = PATTERN.matcher(str);
        DoubleArrayList vals = new DoubleArrayList();
        while (matcher.find()) {
            double newVal = Double.parseDouble(matcher.group());
            vals.add(newVal);
        }
        int count = vals.size() / 6;
        BoundingBox[] boundingBoxes = new BoundingBox[count];
        for (int i = 0; i < count; ++i) {
            double minX = vals.getDouble(0 + 6 * i);
            double minY = vals.getDouble(1 + 6 * i);
            double minZ = vals.getDouble(2 + 6 * i);
            double boundXSize = vals.getDouble(3 + 6 * i) - minX;
            double boundYSize = vals.getDouble(4 + 6 * i) - minY;
            double boundZSize = vals.getDouble(5 + 6 * i) - minZ;
            BoundingBox bb = new BoundingBox(boundXSize, boundYSize, boundZSize, new Vec(minX, minY, minZ));
            assert (bb.minX() == minX);
            assert (bb.minY() == minY);
            assert (bb.minZ() == minZ);
            boundingBoxes[i] = bb;
        }
        return boundingBoxes;
    }

    private static byte isFaceCovered(List<Rectangle> covering) {
        if (covering.isEmpty()) {
            return 0;
        }
        Rectangle r = new Rectangle(0.0, 0.0, 1.0, 1.0);
        ArrayList<Rectangle> toCover = new ArrayList<Rectangle>();
        toCover.add(r);
        for (Rectangle rect : covering) {
            ArrayList<Rectangle> nextCovering = new ArrayList<Rectangle>();
            for (Rectangle toCoverRect : toCover) {
                List<Rectangle> remaining = ShapeImpl.getRemaining(rect, toCoverRect);
                nextCovering.addAll(remaining);
            }
            toCover = nextCovering;
            if (!toCover.isEmpty()) continue;
            return 2;
        }
        return 1;
    }

    static ShapeImpl parseBlockFromRegistry(String collision, String occlusion, Registry.BlockEntry blockEntry) {
        BoundingBox[] collisionBoundingBoxes = ShapeImpl.parseRegistryBoundingBoxString(collision);
        BoundingBox[] occlusionBoundingBoxes = blockEntry.occludes() ? ShapeImpl.parseRegistryBoundingBoxString(occlusion) : new BoundingBox[]{};
        return new ShapeImpl(collisionBoundingBoxes, occlusionBoundingBoxes, blockEntry);
    }

    @Override
    @NotNull
    public Point relativeStart() {
        return this.relativeStart;
    }

    @Override
    @NotNull
    public Point relativeEnd() {
        return this.relativeEnd;
    }

    @Override
    public boolean isOccluded(@NotNull Shape shape, @NotNull BlockFace face) {
        boolean hasAirOcclusionOther;
        boolean hasBlockOcclusionOther;
        ShapeImpl shapeImpl = (ShapeImpl)shape;
        boolean hasBlockOcclusion = (this.blockOcclusion >> face.ordinal() & 1) == 1;
        boolean bl = hasBlockOcclusionOther = (shapeImpl.blockOcclusion >> face.getOppositeFace().ordinal() & 1) == 1;
        if (this.blockEntry.lightEmission() > 0) {
            return hasBlockOcclusionOther;
        }
        if (hasBlockOcclusion || hasBlockOcclusionOther) {
            return true;
        }
        boolean hasAirOcclusion = (this.airOcclusion >> face.ordinal() & 1) == 1;
        boolean bl2 = hasAirOcclusionOther = (shapeImpl.airOcclusion >> face.getOppositeFace().ordinal() & 1) == 1;
        if (hasAirOcclusion || hasAirOcclusionOther) {
            return false;
        }
        List<Rectangle> allRectangles = ShapeImpl.computeOcclusionSet(face.getOppositeFace(), shapeImpl.occlusionBoundingBoxes);
        allRectangles.addAll(ShapeImpl.computeOcclusionSet(face, this.occlusionBoundingBoxes));
        return ShapeImpl.isFaceCovered(allRectangles) == 2;
    }

    @Override
    public boolean isFaceFull(@NotNull BlockFace face) {
        return (this.fullFaces >> face.ordinal() & 1) == 1;
    }

    @Override
    public boolean intersectBox(@NotNull Point position, @NotNull BoundingBox boundingBox) {
        for (BoundingBox blockSection : this.collisionBoundingBoxes) {
            if (!boundingBox.intersectBox(position, blockSection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectBoxSwept(@NotNull Point rayStart, @NotNull Point rayDirection, @NotNull Point shapePos, @NotNull BoundingBox moving, @NotNull SweepResult finalResult) {
        boolean hitBlock = false;
        for (BoundingBox blockSection : this.collisionBoundingBoxes) {
            if (!RayUtils.BoundingBoxIntersectionCheck(moving, rayStart, rayDirection, blockSection, shapePos, finalResult)) continue;
            finalResult.collidedPositionX = rayStart.x() + rayDirection.x() * finalResult.res;
            finalResult.collidedPositionY = rayStart.y() + rayDirection.y() * finalResult.res;
            finalResult.collidedPositionZ = rayStart.z() + rayDirection.z() * finalResult.res;
            finalResult.collidedShape = this;
            hitBlock = true;
        }
        return hitBlock;
    }

    public Block block() {
        Block block = this.block;
        if (block == null) {
            this.block = block = Block.fromStateId((short)this.blockEntry.stateId());
        }
        return block;
    }

    @NotNull
    private static List<Rectangle> computeOcclusionSet(BlockFace face, BoundingBox[] boundingBoxes) {
        ArrayList<Rectangle> rSet = new ArrayList<Rectangle>();
        block8: for (BoundingBox boundingBox : boundingBoxes) {
            switch (face) {
                case NORTH: {
                    if (boundingBox.minZ() != 0.0) continue block8;
                    rSet.add(new Rectangle(boundingBox.minX(), boundingBox.minY(), boundingBox.maxX(), boundingBox.maxY()));
                    continue block8;
                }
                case SOUTH: {
                    if (boundingBox.maxZ() != 1.0) continue block8;
                    rSet.add(new Rectangle(boundingBox.minX(), boundingBox.minY(), boundingBox.maxX(), boundingBox.maxY()));
                    continue block8;
                }
                case WEST: {
                    if (boundingBox.minX() != 0.0) continue block8;
                    rSet.add(new Rectangle(boundingBox.minY(), boundingBox.minZ(), boundingBox.maxY(), boundingBox.maxZ()));
                    continue block8;
                }
                case EAST: {
                    if (boundingBox.maxX() != 1.0) continue block8;
                    rSet.add(new Rectangle(boundingBox.minY(), boundingBox.minZ(), boundingBox.maxY(), boundingBox.maxZ()));
                    continue block8;
                }
                case BOTTOM: {
                    if (boundingBox.minY() != 0.0) continue block8;
                    rSet.add(new Rectangle(boundingBox.minX(), boundingBox.minZ(), boundingBox.maxX(), boundingBox.maxZ()));
                    continue block8;
                }
                case TOP: {
                    if (boundingBox.maxY() != 1.0) continue block8;
                    rSet.add(new Rectangle(boundingBox.minX(), boundingBox.minZ(), boundingBox.maxX(), boundingBox.maxZ()));
                }
            }
        }
        return rSet;
    }

    private static List<Rectangle> getRemaining(Rectangle covering, Rectangle toCover) {
        ArrayList<Rectangle> remaining = new ArrayList<Rectangle>();
        if ((covering = ShapeImpl.clipRectangle(covering, toCover)).y1() > toCover.y1()) {
            remaining.add(new Rectangle(toCover.x1(), toCover.y1(), toCover.x2(), covering.y1()));
        }
        if (covering.y2() < toCover.y2()) {
            remaining.add(new Rectangle(toCover.x1(), covering.y2(), toCover.x2(), toCover.y2()));
        }
        if (covering.x1() > toCover.x1()) {
            remaining.add(new Rectangle(toCover.x1(), covering.y1(), covering.x1(), covering.y2()));
        }
        if (covering.x2() < toCover.x2()) {
            remaining.add(new Rectangle(covering.x2(), covering.y1(), toCover.x2(), covering.y2()));
        }
        return remaining;
    }

    private static Rectangle clipRectangle(Rectangle covering, Rectangle toCover) {
        double x1 = Math.max(covering.x1(), toCover.x1());
        double y1 = Math.max(covering.y1(), toCover.y1());
        double x2 = Math.min(covering.x2(), toCover.x2());
        double y2 = Math.min(covering.y2(), toCover.y2());
        return new Rectangle(x1, y1, x2, y2);
    }

    private record Rectangle(double x1, double y1, double x2, double y2) {
    }
}

