/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.damage;

import net.minestom.server.entity.damage.DamageTypeImpl;
import net.minestom.server.entity.damage.DamageTypes;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DamageType
extends ProtocolObject,
DamageTypes
permits DamageTypeImpl {
    @NotNull
    public static final BinaryTagSerializer<DynamicRegistry.Key<DamageType>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::damageType);

    @NotNull
    public static DamageType create(float exhaustion, @NotNull String messageId, @NotNull String scaling) {
        return new DamageTypeImpl(exhaustion, messageId, scaling, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<DamageType> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:damage_type", DamageTypeImpl.REGISTRY_NBT_TYPE, Registry.Resource.DAMAGE_TYPES, (namespace, props) -> new DamageTypeImpl(Registry.damageType(namespace, props)));
    }

    public float exhaustion();

    @NotNull
    public String messageId();

    @NotNull
    public String scaling();

    @Override
    @Nullable
    public Registry.DamageTypeEntry registry();

    public static final class Builder {
        private float exhaustion = 0.0f;
        private String messageId;
        private String scaling;

        private Builder() {
        }

        @NotNull
        public Builder exhaustion(float exhaustion) {
            this.exhaustion = exhaustion;
            return this;
        }

        @NotNull
        public Builder messageId(@NotNull String messageId) {
            this.messageId = messageId;
            return this;
        }

        @NotNull
        public Builder scaling(@NotNull String scaling) {
            this.scaling = scaling;
            return this;
        }

        @NotNull
        public DamageType build() {
            return new DamageTypeImpl(this.exhaustion, this.messageId, this.scaling, null);
        }
    }
}

