/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.gamedata.tags;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.EntityType;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.Material;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.FluidRegistries;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Tag
implements ProtocolObject,
Keyed {
    private final NamespaceID name;
    private final Set<NamespaceID> values;

    public Tag(@NotNull NamespaceID name) {
        this.name = name;
        this.values = new HashSet<NamespaceID>();
    }

    public Tag(@NotNull NamespaceID name, @NotNull Set<NamespaceID> values) {
        this.name = name;
        this.values = new HashSet<NamespaceID>(values);
    }

    public boolean contains(@NotNull NamespaceID id) {
        return this.values.contains(id);
    }

    @NotNull
    public Set<NamespaceID> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    @NotNull
    public NamespaceID namespace() {
        return this.name;
    }

    @Contract(pure=true)
    @NotNull
    public String name() {
        return this.namespace().asString();
    }

    @Contract(pure=true)
    @NotNull
    public Key key() {
        return this.namespace();
    }

    @Deprecated
    public NamespaceID getName() {
        return this.name;
    }

    public static enum BasicType {
        BLOCKS("minecraft:block", Registry.Resource.BLOCK_TAGS, name -> Objects.requireNonNull(Block.fromNamespaceId(name)).id()),
        ITEMS("minecraft:item", Registry.Resource.ITEM_TAGS, name -> Objects.requireNonNull(Material.fromNamespaceId(name)).id()),
        FLUIDS("minecraft:fluid", Registry.Resource.FLUID_TAGS, name -> FluidRegistries.getFluid(name).ordinal()),
        ENTITY_TYPES("minecraft:entity_type", Registry.Resource.ENTITY_TYPE_TAGS, name -> Objects.requireNonNull(EntityType.fromNamespaceId(name)).id()),
        GAME_EVENTS("minecraft:game_event", Registry.Resource.GAMEPLAY_TAGS, name -> FluidRegistries.getFluid(name).ordinal()),
        SOUND_EVENTS("minecraft:sound_event", null, null),
        POTION_EFFECTS("minecraft:sound_event", null, null),
        ENCHANTMENTS("minecraft:enchantment", Registry.Resource.ENCHANTMENT_TAGS, name -> MinecraftServer.getEnchantmentRegistry().getId(DynamicRegistry.Key.of(name)));

        private static final BasicType[] VALUES;
        private final String identifier;
        private final Registry.Resource resource;
        private final Function<String, Integer> function;

        private BasicType(@Nullable String identifier, Registry.Resource resource, Function<String, Integer> function) {
            this.identifier = identifier;
            this.resource = resource;
            this.function = function;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        public Registry.Resource getResource() {
            return this.resource;
        }

        public Function<String, Integer> getFunction() {
            return this.function;
        }

        @Nullable
        public static BasicType fromIdentifer(@NotNull String identifier) {
            for (BasicType value : VALUES) {
                if (!value.identifier.equals(identifier)) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = BasicType.values();
        }
    }
}

