/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.minestom.server.ServerFlag;
import net.minestom.server.collision.Shape;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.DynamicChunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.heightmap.Heightmap;
import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.play.data.LightData;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightingChunk
extends DynamicChunk {
    private static final ExecutorService pool = Executors.newWorkStealingPool();
    private int[] occlusionMap;
    final CachedPacket partialLightCache = new CachedPacket(this::createLightPacket);
    private LightData partialLightData;
    private LightData fullLightData;
    private int highestBlock;
    private boolean freezeInvalidation = false;
    private final ReentrantLock packetGenerationLock = new ReentrantLock();
    private final AtomicInteger resendTimer = new AtomicInteger(-1);
    private final int resendDelay = ServerFlag.SEND_LIGHT_AFTER_BLOCK_PLACEMENT_DELAY;
    private boolean doneInit = false;
    private static final Set<NamespaceID> DIFFUSE_SKY_LIGHT = Set.of(Block.COBWEB.namespace(), Block.ICE.namespace(), Block.HONEY_BLOCK.namespace(), Block.SLIME_BLOCK.namespace(), Block.WATER.namespace(), Block.ACACIA_LEAVES.namespace(), Block.AZALEA_LEAVES.namespace(), Block.BIRCH_LEAVES.namespace(), Block.DARK_OAK_LEAVES.namespace(), Block.FLOWERING_AZALEA_LEAVES.namespace(), Block.JUNGLE_LEAVES.namespace(), Block.CHERRY_LEAVES.namespace(), Block.OAK_LEAVES.namespace(), Block.SPRUCE_LEAVES.namespace(), Block.SPAWNER.namespace(), Block.BEACON.namespace(), Block.END_GATEWAY.namespace(), Block.CHORUS_PLANT.namespace(), Block.CHORUS_FLOWER.namespace(), Block.FROSTED_ICE.namespace(), Block.SEAGRASS.namespace(), Block.TALL_SEAGRASS.namespace(), Block.LAVA.namespace());

    @Override
    public void invalidate() {
        this.partialLightCache.invalidate();
        this.chunkCache.invalidate();
        this.partialLightData = null;
        this.fullLightData = null;
    }

    public LightingChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        super(instance, chunkX, chunkZ);
    }

    private boolean checkSkyOcclusion(Block block) {
        if (block == Block.AIR) {
            return false;
        }
        if (DIFFUSE_SKY_LIGHT.contains(block.namespace())) {
            return true;
        }
        Shape shape = block.registry().collisionShape();
        boolean occludesTop = Block.AIR.registry().collisionShape().isOccluded(shape, BlockFace.TOP);
        boolean occludesBottom = Block.AIR.registry().collisionShape().isOccluded(shape, BlockFace.BOTTOM);
        return occludesBottom || occludesTop;
    }

    public void setFreezeInvalidation(boolean freezeInvalidation) {
        this.freezeInvalidation = freezeInvalidation;
    }

    public void invalidateNeighborsSection(int coordinate) {
        if (this.freezeInvalidation) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = this.instance.getChunk(this.chunkX + i, this.chunkZ + j);
                if (neighborChunk == null) continue;
                if (neighborChunk instanceof LightingChunk) {
                    LightingChunk light = (LightingChunk)neighborChunk;
                    light.invalidate();
                }
                for (int k = -1; k <= 1; ++k) {
                    if (k + coordinate < neighborChunk.getMinSection() || k + coordinate >= neighborChunk.getMaxSection()) continue;
                    neighborChunk.getSection(k + coordinate).blockLight().invalidate();
                    neighborChunk.getSection(k + coordinate).skyLight().invalidate();
                }
            }
        }
    }

    public void invalidateResendDelay() {
        if (!this.doneInit || this.freezeInvalidation) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = this.instance.getChunk(this.chunkX + i, this.chunkZ + j);
                if (!(neighborChunk instanceof LightingChunk)) continue;
                LightingChunk light = (LightingChunk)neighborChunk;
                light.resendTimer.set(this.resendDelay);
            }
        }
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block, @Nullable BlockHandler.Placement placement, @Nullable BlockHandler.Destroy destroy) {
        super.setBlock(x, y, z, block, placement, destroy);
        this.occlusionMap = null;
        int coordinate = ChunkUtils.getChunkCoordinate(y);
        if (this.doneInit && !this.freezeInvalidation) {
            this.invalidateNeighborsSection(coordinate);
            this.invalidateResendDelay();
            this.partialLightCache.invalidate();
        }
    }

    public void sendLighting() {
        if (!this.isLoaded()) {
            return;
        }
        this.sendPacketToViewers(this.partialLightCache);
    }

    @Override
    protected void onLoad() {
        this.doneInit = true;
    }

    @Override
    public void onGenerate() {
        super.onGenerate();
        for (int section = this.minSection; section < this.maxSection; ++section) {
            this.getSection(section).blockLight().invalidate();
            this.getSection(section).skyLight().invalidate();
        }
        this.invalidate();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = this.instance.getChunk(this.chunkX + i, this.chunkZ + j);
                if (neighborChunk == null || !(neighborChunk instanceof LightingChunk)) continue;
                LightingChunk light = (LightingChunk)neighborChunk;
                if (!light.doneInit) continue;
                light.resendTimer.set(20);
                light.invalidate();
                for (int section = this.minSection; section < this.maxSection; ++section) {
                    light.getSection(section).blockLight().invalidate();
                    light.getSection(section).skyLight().invalidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getOcclusionMap() {
        if (this.occlusionMap != null) {
            return this.occlusionMap;
        }
        int[] occlusionMap = new int[256];
        int minY = this.instance.getCachedDimensionType().minY();
        this.highestBlock = minY - 1;
        LightingChunk lightingChunk = this;
        synchronized (lightingChunk) {
            int startY = Heightmap.getHighestBlockSection(this);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int height;
                    for (height = startY; height >= minY; --height) {
                        Block block = this.getBlock(x, height, z, Block.Getter.Condition.TYPE);
                        if (block != Block.AIR) {
                            this.highestBlock = Math.max(this.highestBlock, height);
                        }
                        if (this.checkSkyOcclusion(block)) break;
                    }
                    occlusionMap[z << 4 | x] = height + 1;
                }
            }
        }
        this.occlusionMap = occlusionMap;
        return occlusionMap;
    }

    @Override
    protected LightData createLightData(boolean requiredFullChunk) {
        this.packetGenerationLock.lock();
        if (requiredFullChunk) {
            if (this.fullLightData != null) {
                this.packetGenerationLock.unlock();
                return this.fullLightData;
            }
        } else if (this.partialLightData != null) {
            this.packetGenerationLock.unlock();
            return this.partialLightData;
        }
        BitSet skyMask = new BitSet();
        BitSet blockMask = new BitSet();
        BitSet emptySkyMask = new BitSet();
        BitSet emptyBlockMask = new BitSet();
        ArrayList<byte[]> skyLights = new ArrayList<byte[]>();
        ArrayList<byte[]> blockLights = new ArrayList<byte[]>();
        int chunkMin = this.instance.getCachedDimensionType().minY();
        int highestNeighborBlock = this.instance.getCachedDimensionType().minY();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = this.instance.getChunk(this.chunkX + i, this.chunkZ + j);
                if (neighborChunk == null || !(neighborChunk instanceof LightingChunk)) continue;
                LightingChunk light = (LightingChunk)neighborChunk;
                light.getOcclusionMap();
                highestNeighborBlock = Math.max(highestNeighborBlock, light.highestBlock);
            }
        }
        int index = 0;
        for (Section section : this.sections) {
            boolean wasUpdatedBlock = false;
            boolean wasUpdatedSky = false;
            if (section.blockLight().requiresUpdate()) {
                LightingChunk.relightSection(this.instance, this.chunkX, index + this.minSection, this.chunkZ, LightType.BLOCK);
                wasUpdatedBlock = true;
            } else if (requiredFullChunk || section.blockLight().requiresSend()) {
                wasUpdatedBlock = true;
            }
            if (section.skyLight().requiresUpdate()) {
                LightingChunk.relightSection(this.instance, this.chunkX, index + this.minSection, this.chunkZ, LightType.SKY);
                wasUpdatedSky = true;
            } else if (requiredFullChunk || section.skyLight().requiresSend()) {
                wasUpdatedSky = true;
            }
            int sectionMinY = index * 16 + chunkMin;
            ++index;
            if (wasUpdatedSky && this.instance.getCachedDimensionType().hasSkylight() && sectionMinY <= highestNeighborBlock + 16) {
                byte[] skyLight = section.skyLight().array();
                if (skyLight.length != 0 && skyLight != LightCompute.emptyContent) {
                    skyLights.add(skyLight);
                    skyMask.set(index);
                } else {
                    emptySkyMask.set(index);
                }
            }
            if (!wasUpdatedBlock) continue;
            byte[] blockLight = section.blockLight().array();
            if (blockLight.length != 0 && blockLight != LightCompute.emptyContent) {
                blockLights.add(blockLight);
                blockMask.set(index);
                continue;
            }
            emptyBlockMask.set(index);
        }
        LightData lightData = new LightData(skyMask, blockMask, emptySkyMask, emptyBlockMask, skyLights, blockLights);
        if (requiredFullChunk) {
            this.fullLightData = lightData;
        } else {
            this.partialLightData = lightData;
        }
        this.packetGenerationLock.unlock();
        return lightData;
    }

    @Override
    public void tick(long time) {
        super.tick(time);
        if (this.doneInit && this.resendTimer.get() > 0 && this.resendTimer.decrementAndGet() == 0) {
            this.sendLighting();
        }
    }

    private static Set<Chunk> flushQueue(Instance instance, Set<Point> queue, LightType type, QueueType queueType) {
        ConcurrentHashMap.KeySetView sections = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView newQueue = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView responseChunks = ConcurrentHashMap.newKeySet();
        ArrayList<CompletableFuture<Void>> tasks = new ArrayList<CompletableFuture<Void>>();
        for (Point point : queue) {
            Chunk chunk = instance.getChunk(point.blockX(), point.blockZ());
            if (chunk == null) continue;
            Section section = chunk.getSection(point.blockY());
            responseChunks.add(chunk);
            Light light = switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> section.blockLight();
                case 0 -> section.skyLight();
            };
            CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                switch (queueType.ordinal()) {
                    case 0: {
                        light.calculateInternal(instance, chunk.getChunkX(), point.blockY(), chunk.getChunkZ());
                        break;
                    }
                    case 1: {
                        light.calculateExternal(instance, chunk, point.blockY());
                    }
                }
                sections.add(light);
                Set<Point> toAdd = light.flip();
                if (toAdd != null) {
                    newQueue.addAll(toAdd);
                }
            }, pool);
            tasks.add(task);
        }
        tasks.forEach(CompletableFuture::join);
        if (!newQueue.isEmpty()) {
            Set<Chunk> newResponse = LightingChunk.flushQueue(instance, newQueue, type, QueueType.EXTERNAL);
            responseChunks.addAll(newResponse);
        }
        return responseChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Chunk> relight(Instance instance, Collection<Chunk> chunks) {
        HashSet<Vec> sections = new HashSet<Vec>();
        Instance instance2 = instance;
        synchronized (instance2) {
            for (Chunk chunk : chunks) {
                if (chunk == null || !(chunk instanceof LightingChunk)) continue;
                LightingChunk lightingChunk = (LightingChunk)chunk;
                for (int i = chunk.minSection; i < chunk.maxSection; ++i) {
                    chunk.getSection(i).blockLight().invalidate();
                    chunk.getSection(i).skyLight().invalidate();
                    sections.add(new Vec(chunk.getChunkX(), i, chunk.getChunkZ()));
                }
                lightingChunk.invalidate();
            }
            HashSet<Point> blockSections = new HashSet<Point>();
            for (Point point : sections) {
                blockSections.addAll(LightingChunk.getNearbyRequired(instance, point, LightType.BLOCK));
            }
            HashSet<Point> hashSet = new HashSet<Point>();
            for (Point point : sections) {
                hashSet.addAll(LightingChunk.getNearbyRequired(instance, point, LightType.SKY));
            }
            LightingChunk.relight(instance, blockSections, LightType.BLOCK);
            LightingChunk.relight(instance, hashSet, LightType.SKY);
            HashSet<Chunk> hashSet2 = new HashSet<Chunk>();
            for (Point point : blockSections) {
                hashSet2.add(instance.getChunk(point.blockX(), point.blockZ()));
            }
            for (Point point : hashSet) {
                hashSet2.add(instance.getChunk(point.blockX(), point.blockZ()));
            }
            return new ArrayList<Chunk>(hashSet2);
        }
    }

    private static Set<Point> getNearbyRequired(Instance instance, Point point, LightType type) {
        Chunk chunkCheck;
        int z;
        int x;
        HashSet<Point> collected = new HashSet<Point>();
        collected.add(point);
        int highestRegionPoint = instance.getCachedDimensionType().minY() - 1;
        for (x = point.blockX() - 1; x <= point.blockX() + 1; ++x) {
            for (z = point.blockZ() - 1; z <= point.blockZ() + 1; ++z) {
                chunkCheck = instance.getChunk(x, z);
                if (chunkCheck == null || !(chunkCheck instanceof LightingChunk)) continue;
                LightingChunk lighting = (LightingChunk)chunkCheck;
                lighting.getOcclusionMap();
                highestRegionPoint = Math.max(highestRegionPoint, lighting.highestBlock);
            }
        }
        for (x = point.blockX() - 1; x <= point.blockX() + 1; ++x) {
            for (z = point.blockZ() - 1; z <= point.blockZ() + 1; ++z) {
                chunkCheck = instance.getChunk(x, z);
                if (chunkCheck == null) continue;
                for (int y = point.blockY() - 1; y <= point.blockY() + 1; ++y) {
                    Vec sectionPosition = new Vec(x, y, z);
                    int sectionHeight = instance.getCachedDimensionType().minY() + 16 * y;
                    if (sectionHeight + 16 > highestRegionPoint && type == LightType.SKY || sectionPosition.blockY() >= chunkCheck.getMaxSection() || sectionPosition.blockY() < chunkCheck.getMinSection()) continue;
                    Section s = chunkCheck.getSection(sectionPosition.blockY());
                    if (type == LightType.BLOCK && !s.blockLight().requiresUpdate() || type == LightType.SKY && !s.skyLight().requiresUpdate()) continue;
                    collected.add(sectionPosition);
                }
            }
        }
        return collected;
    }

    private static Set<Point> collectRequiredNearby(Instance instance, Point point, LightType type) {
        HashSet<Point> found = new HashSet<Point>();
        ArrayDeque<Point> toCheck = new ArrayDeque<Point>();
        toCheck.add(point);
        found.add(point);
        while (!toCheck.isEmpty()) {
            Point current = (Point)toCheck.poll();
            Set<Point> nearby = LightingChunk.getNearbyRequired(instance, current, type);
            nearby.forEach(p -> {
                if (!found.contains(p)) {
                    found.add((Point)p);
                    toCheck.add((Point)p);
                }
            });
        }
        return found;
    }

    static Set<Chunk> relightSection(Instance instance, int chunkX, int sectionY, int chunkZ) {
        HashSet<Chunk> res = new HashSet<Chunk>(LightingChunk.relightSection(instance, chunkX, sectionY, chunkZ, LightType.BLOCK));
        res.addAll(LightingChunk.relightSection(instance, chunkX, sectionY, chunkZ, LightType.SKY));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Chunk> relightSection(Instance instance, int chunkX, int sectionY, int chunkZ, LightType type) {
        Chunk c = instance.getChunk(chunkX, chunkZ);
        if (c == null) {
            return Set.of();
        }
        if (!(c instanceof LightingChunk)) {
            return Set.of();
        }
        Instance instance2 = instance;
        synchronized (instance2) {
            Set<Point> collected = LightingChunk.collectRequiredNearby(instance, new Vec(chunkX, sectionY, chunkZ), type);
            return LightingChunk.relight(instance, collected, type);
        }
    }

    private static Set<Chunk> relight(Instance instance, Set<Point> queue, LightType type) {
        return LightingChunk.flushQueue(instance, queue, type, QueueType.INTERNAL);
    }

    @Override
    @NotNull
    public Chunk copy(@NotNull Instance instance, int chunkX, int chunkZ) {
        LightingChunk lightingChunk = new LightingChunk(instance, chunkX, chunkZ);
        lightingChunk.sections = this.sections.stream().map(Section::clone).toList();
        lightingChunk.entries.putAll((Map)this.entries);
        return lightingChunk;
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded() && this.doneInit;
    }

    static enum LightType {
        SKY,
        BLOCK;

    }

    private static enum QueueType {
        INTERNAL,
        EXTERNAL;

    }
}

