/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Objects;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.particle.Particle;
import org.jetbrains.annotations.NotNull;

public record ParticlePacket(@NotNull Particle particle, boolean longDistance, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float maxSpeed, int particleCount) implements ServerPacket.Play
{
    private ParticlePacket(ParticlePacket copy) {
        this(copy.particle, copy.longDistance, copy.x, copy.y, copy.z, copy.offsetX, copy.offsetY, copy.offsetZ, copy.maxSpeed, copy.particleCount);
    }

    public ParticlePacket(@NotNull NetworkBuffer reader) {
        this(ParticlePacket.readPacket(reader));
    }

    public ParticlePacket(@NotNull Particle particle, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float maxSpeed, int particleCount) {
        this(particle, false, x, y, z, offsetX, offsetY, offsetZ, maxSpeed, particleCount);
    }

    public ParticlePacket(@NotNull Particle particle, boolean longDistance, @NotNull Point position, @NotNull Point offset, float maxSpeed, int particleCount) {
        this(particle, longDistance, position.x(), position.y(), position.z(), (float)offset.x(), (float)offset.y(), (float)offset.z(), maxSpeed, particleCount);
    }

    public ParticlePacket(@NotNull Particle particle, @NotNull Point position, @NotNull Point offset, float maxSpeed, int particleCount) {
        this(particle, false, position, offset, maxSpeed, particleCount);
    }

    private static ParticlePacket readPacket(NetworkBuffer reader) {
        Boolean longDistance = reader.read(NetworkBuffer.BOOLEAN);
        Double x = reader.read(NetworkBuffer.DOUBLE);
        Double y = reader.read(NetworkBuffer.DOUBLE);
        Double z = reader.read(NetworkBuffer.DOUBLE);
        Float offsetX = reader.read(NetworkBuffer.FLOAT);
        Float offsetY = reader.read(NetworkBuffer.FLOAT);
        Float offsetZ = reader.read(NetworkBuffer.FLOAT);
        Float maxSpeed = reader.read(NetworkBuffer.FLOAT);
        Integer particleCount = reader.read(NetworkBuffer.INT);
        Particle particle = Particle.fromId(reader.read(NetworkBuffer.VAR_INT));
        Objects.requireNonNull(particle);
        return new ParticlePacket(particle.readData(reader), longDistance, x, y, z, offsetX.floatValue(), offsetY.floatValue(), offsetZ.floatValue(), maxSpeed.floatValue(), particleCount);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BOOLEAN, this.longDistance);
        writer.write(NetworkBuffer.DOUBLE, this.x);
        writer.write(NetworkBuffer.DOUBLE, this.y);
        writer.write(NetworkBuffer.DOUBLE, this.z);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.offsetX));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.offsetY));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.offsetZ));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.maxSpeed));
        writer.write(NetworkBuffer.INT, this.particleCount);
        writer.write(NetworkBuffer.VAR_INT, this.particle.id());
        this.particle.writeData(writer);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.PARTICLE;
    }
}

