/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mingsoft.base.biz.ISqlAdapter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class SqlQueryWrapper {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected StringBuffer querySql = new StringBuffer();
    private int querySqlTotal = 0;
    protected List params = new ArrayList();
    protected ISqlAdapter sqlAdapter;

    public String getQuerySql() {
        return this.querySql.toString();
    }

    public Object[] getParams() {
        return this.params.toArray();
    }

    public SqlQueryWrapper(@Nullable String querySql, Object ... params) {
        this.querySql.append(querySql);
        boolean hasWhereClause = querySql.toLowerCase().contains("where");
        if (!hasWhereClause && ArrayUtil.isNotEmpty((Object[])params)) {
            this.querySql.append(" WHERE ");
        }
        Collections.addAll(this.params, params);
        this.sqlAdapter = new ISqlAdapter(){};
    }

    public SqlQueryWrapper() {
        this.sqlAdapter = new ISqlAdapter(){};
    }

    public SqlQueryWrapper sqlWhere(@Nullable JSONArray sqlWhere) {
        boolean hasWhereClause = this.querySql.toString().toLowerCase().contains("where");
        if (!hasWhereClause && ArrayUtil.isNotEmpty((Object)this.params) && ArrayUtil.isNotEmpty((Object)sqlWhere)) {
            this.querySql.append(" WHERE ");
        }
        SqlWhere where = null;
        int size = 0;
        for (Object sqlWhereJson : sqlWhere) {
            where = (SqlWhere)BeanUtil.toBean(sqlWhereJson, SqlWhere.class);
            String field = where.getField();
            String value = where.getValue();
            String action = ActionEnum.get(where.getAction()).getValue();
            if (StringUtils.isBlank((CharSequence)field) || StringUtils.isBlank((CharSequence)value)) continue;
            switch (ElEnum.get(where.getEl())) {
                case EQ: {
                    this.sqlAdapter.handleEq(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case GT: {
                    this.sqlAdapter.handleGt(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case GTE: {
                    this.sqlAdapter.handleGet(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case LT: {
                    this.sqlAdapter.handleLt(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case LTE: {
                    this.sqlAdapter.handleLet(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case LIKE: {
                    this.sqlAdapter.handleLike(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case LIKELEFT: {
                    this.sqlAdapter.handleLikeLeft(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case LIKERIGHT: {
                    this.sqlAdapter.handleLikeRight(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case IN: {
                    this.sqlAdapter.handleIn(this.querySql, where);
                    this.params.add(value);
                    break;
                }
                case RANGE: {
                    JSONArray values = JSONUtil.parseArray((String)value);
                    this.params.add(values.getStr((Object)0));
                    this.params.add(values.getStr((Object)1));
                    this.sqlAdapter.handleRange(this.querySql, where);
                    break;
                }
            }
            if (size != sqlWhere.size() - 1) {
                this.querySql.append(" ").append(action).append(" ");
            }
            ++size;
        }
        return this;
    }

    public SqlQueryWrapper sqlWhere(String sqlWhere) {
        if (StringUtils.isEmpty((CharSequence)sqlWhere)) {
            return this;
        }
        return this.sqlWhere(JSONUtil.parseArray((String)sqlWhere));
    }

    public void page(int start, int size) {
        this.querySqlTotal = this.sqlAdapter.handlePage(this.querySql, start, size, this.params);
    }

    public SqlQueryWrapper orderByDesc(String column) {
        if (StringUtils.isBlank((CharSequence)column)) {
            return this;
        }
        this.sqlAdapter.handleOrderByDesc(this.querySql, column);
        return this;
    }

    public SqlQueryWrapper orderByAsc(String column) {
        if (StringUtils.isBlank((CharSequence)column)) {
            return this;
        }
        this.sqlAdapter.handleOrderByAsc(this.querySql, column);
        return this;
    }

    public String handleTime(@Nullable String type) {
        return this.sqlAdapter.handleTime(type);
    }

    public int getTotal() {
        return this.querySqlTotal;
    }

    public List<String> queryTables() {
        return this.sqlAdapter.queryTables();
    }

    public List<String> queryTableColumns(String tableName) {
        if (StrUtil.isBlank((CharSequence)tableName)) {
            return Collections.emptyList();
        }
        return this.sqlAdapter.queryTableColumns(tableName);
    }

    public static class EUListBean {
        private int total;
        private List rows;

        public EUListBean() {
        }

        public EUListBean(List rows, int total) {
            this.total = total;
            this.rows = rows;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public List getRows() {
            return this.rows;
        }

        public void setRows(List rows) {
            this.rows = rows;
        }
    }

    public static enum ElEnum {
        EQ("eq"),
        GT("gt"),
        GTE("gte"),
        LT("lt"),
        LTE("lte"),
        LIKE("like"),
        LIKELEFT("likeLeft"),
        LIKERIGHT("likeRight"),
        IN("in"),
        RANGE("range");

        private String value;

        private ElEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ElEnum get(String value) {
            for (ElEnum el : ElEnum.values()) {
                if (!el.getValue().equalsIgnoreCase(value)) continue;
                return el;
            }
            return EQ;
        }
    }

    public static enum ActionEnum {
        AND("AND"),
        OR("OR");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ActionEnum get(String value) {
            for (ActionEnum action : ActionEnum.values()) {
                if (!action.getValue().equalsIgnoreCase(value)) continue;
                return action;
            }
            return AND;
        }
    }

    public class SqlWhere {
        private String action;
        private String field;
        private String value;
        private String type;
        private String el;
        private Boolean multiple = false;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getEl() {
            return this.el;
        }

        public void setEl(String el) {
            this.el = el;
        }

        public Boolean getMultiple() {
            return this.multiple;
        }

        public void setMultiple(Boolean multiple) {
            this.multiple = multiple;
        }
    }
}

