/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.filter;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.IoUtil;
import cn.hutool.json.JSONUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.JsoupUtil;
import org.apache.commons.lang3.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest request = null;
    private List<String> excludesFiled = new ArrayList<String>();
    public static TimedCache<String, Integer> TIMED_XSS_CACHE = CacheUtil.newTimedCache((long)1800000L);
    public static TimedCache<String, Boolean> TIMED_REQ_CACHE = CacheUtil.newTimedCache((long)1800000L);

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public XssHttpServletRequestWrapper(HttpServletRequest request, List<String> excludesFiled) {
        super(request);
        this.request = request;
        if (CollectionUtil.isNotEmpty(excludesFiled)) {
            this.excludesFiled.addAll(excludesFiled);
        }
    }

    private void xssCountAdd(String ip) {
        if (!TIMED_XSS_CACHE.containsKey((Object)ip)) {
            TIMED_XSS_CACHE.put((Object)ip, (Object)1);
        } else {
            TIMED_XSS_CACHE.put((Object)ip, (Object)((Integer)TIMED_XSS_CACHE.get((Object)ip) + 1));
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        FastByteArrayOutputStream read = IoUtil.read((InputStream)this.request.getInputStream());
        String tmp = read.toString();
        if (JSONUtil.isTypeJSON((String)tmp)) {
            try {
                if (JSONUtil.isTypeJSONArray((String)tmp)) {
                    List jsonList = JSONUtil.toList((String)tmp, Map.class);
                    jsonList.forEach(map -> {
                        Iterator iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            String key = iterator.next().toString();
                            JsoupUtil.cleanOrSqlInjection(key);
                            if (!(map.get(key) instanceof String) || this.excludesFiled.contains(key)) continue;
                            JsoupUtil.cleanOrSqlInjection(String.valueOf(map.get(key)));
                        }
                    });
                } else {
                    Map jsonMap = (Map)JSONUtil.toBean((String)tmp, Map.class);
                    Iterator iterator = jsonMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = iterator.next().toString();
                        JsoupUtil.cleanOrSqlInjection(key);
                        if (!(jsonMap.get(key) instanceof String) || this.excludesFiled.contains(key)) continue;
                        JsoupUtil.cleanOrSqlInjection(String.valueOf(jsonMap.get(key)));
                    }
                }
                TIMED_REQ_CACHE.put((Object)BasicUtil.getIp(), (Object)false);
            }
            catch (BusinessException e) {
                this.xssCountAdd(BasicUtil.getIp());
                TIMED_REQ_CACHE.put((Object)BasicUtil.getIp(), (Object)true);
                throw new BusinessException(e.getMsg());
            }
        }
        if (JsoupUtil.hasXSS(tmp)) {
            this.xssCountAdd(BasicUtil.getIp());
            TIMED_REQ_CACHE.put((Object)BasicUtil.getIp(), (Object)true);
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u5b58\u5728xss\u653b\u51fb");
        }
        TIMED_REQ_CACHE.put((Object)BasicUtil.getIp(), (Object)false);
        return new WrappedServletInputStream(new ByteArrayInputStream(read.toByteArray()));
    }

    public String getParameter(String name) {
        String value = null;
        try {
            name = JsoupUtil.cleanOrSqlInjection(name);
            value = super.getParameter(name);
            if (StringUtils.isNotBlank((CharSequence)value) && !this.excludesFiled.contains(name)) {
                value = JsoupUtil.cleanOrSqlInjection(value);
            }
        }
        catch (BusinessException e) {
            this.xssCountAdd(BasicUtil.getIp());
            throw new BusinessException(e.getMsg());
        }
        return value;
    }

    public Map getParameterMap() {
        Map map = super.getParameterMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator entries = map.entrySet().iterator();
        String name = "";
        String value = "";
        boolean hasXss = false;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            if (this.excludesFiled.contains(name)) {
                returnMap.put(name, value.trim());
                continue;
            }
            try {
                returnMap.put(JsoupUtil.cleanOrSqlInjection(name), JsoupUtil.cleanOrSqlInjection(value).trim());
            }
            catch (BusinessException e) {
                if (!hasXss) {
                    this.xssCountAdd(BasicUtil.getIp());
                }
                hasXss = true;
                TIMED_REQ_CACHE.put((Object)BasicUtil.getIp(), (Object)hasXss);
                throw new BusinessException(e.getMsg());
            }
        }
        TIMED_REQ_CACHE.put((Object)BasicUtil.getIp(), (Object)false);
        return returnMap;
    }

    public String[] getParameterValues(String name) {
        String[] arr = super.getParameterValues(name);
        if (arr != null) {
            boolean hasXss = false;
            for (int i = 0; i < arr.length; ++i) {
                if (this.excludesFiled.contains(name)) continue;
                try {
                    arr[i] = JsoupUtil.cleanOrSqlInjection(arr[i]);
                    continue;
                }
                catch (BusinessException e) {
                    if (!hasXss) {
                        this.xssCountAdd(BasicUtil.getIp());
                    }
                    hasXss = true;
                    throw new BusinessException(e.getMsg());
                }
            }
            if (hasXss) {
                TIMED_REQ_CACHE.put((Object)BasicUtil.getIp(), (Object)true);
            } else {
                TIMED_REQ_CACHE.put((Object)BasicUtil.getIp(), (Object)false);
            }
        }
        return arr;
    }

    public String getHeader(String name) {
        String value = null;
        try {
            name = JsoupUtil.cleanOrSqlInjection(name);
            value = super.getHeader(name);
            if (StringUtils.isNotBlank((CharSequence)value) && !this.excludesFiled.contains(name)) {
                value = JsoupUtil.cleanOrSqlInjection(value);
            }
        }
        catch (BusinessException e) {
            this.xssCountAdd(BasicUtil.getIp());
            throw new BusinessException(e.getMsg());
        }
        return value;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getRequest();
        }
        return req;
    }

    private class WrappedServletInputStream
    extends ServletInputStream {
        private InputStream stream;

        public void setStream(InputStream stream) {
            this.stream = stream;
        }

        public WrappedServletInputStream(InputStream stream) {
            this.stream = stream;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

