package net.mingsoft.clean.action;

import java.util.List;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import cn.hutool.core.util.ObjectUtil;
import java.util.*;

import com.alibaba.fastjson.JSON;
import net.mingsoft.base.entity.ResultData;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.BindingResult;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.ui.ModelMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import org.springframework.web.bind.annotation.*;
import net.mingsoft.clean.biz.ITableBiz;
import net.mingsoft.clean.entity.TableEntity;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import springfox.documentation.annotations.ApiIgnore;
/**
 * 文件清理管理控制层
 * @author 铭飞开源团队
 * 创建日期：2020-6-3 14:53:52<br/>
 * 历史修订：<br/>
 */
@Api(value = "文件清理接口")
@Controller("cleanTableAction")
@RequestMapping("/${ms.manager.path}/clean/table")
public class TableAction extends BaseAction{


	/**
	 * 注入文件清理业务层
	 */
	@Autowired
	private ITableBiz tableBiz;

	/**
	 * 返回主界面index
	 */
	@GetMapping("/index")
	public String index(HttpServletResponse response,HttpServletRequest request){
		return "/clean/table/index";
	}

	/**
	 * 查询文件清理列表
	 * @param table 文件清理实体
	 */
	@ApiOperation(value = "查询文件清理列表接口")
	@ApiImplicitParams({
    	@ApiImplicitParam(name = "cleanTitle", value = "标题", required =false,paramType="query"),
    	@ApiImplicitParam(name = "cleanTable", value = "表名", required =false,paramType="query"),
    	@ApiImplicitParam(name = "cleanField", value = "清理字段", required =false,paramType="query"),
    	@ApiImplicitParam(name = "createBy", value = "创建人", required =false,paramType="query"),
    	@ApiImplicitParam(name = "createDate", value = "创建时间", required =false,paramType="query"),
    	@ApiImplicitParam(name = "updateBy", value = "修改人", required =false,paramType="query"),
    	@ApiImplicitParam(name = "updateDate", value = "修改时间", required =false,paramType="query"),
    	@ApiImplicitParam(name = "del", value = "删除标记", required =false,paramType="query"),
    	@ApiImplicitParam(name = "id", value = "编号", required =false,paramType="query"),
    })
	@RequestMapping(value ="/list",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ResultData list(@ModelAttribute @ApiIgnore TableEntity table,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model,BindingResult result) {
		BasicUtil.startPage();
		List tableList = tableBiz.query(table);
		return ResultData.build().success(new EUListBean(tableList,(int)BasicUtil.endPage(tableList).getTotal()));
	}

	/**
	 * 返回编辑界面table_form
	 */
	@GetMapping("/form")
	public String form(@ModelAttribute TableEntity table,HttpServletResponse response,HttpServletRequest request,ModelMap model){
		if(table.getId()!=null){
			BaseEntity tableEntity = tableBiz.getEntity(Integer.parseInt(table.getId()));
			model.addAttribute("tableEntity",tableEntity);
		}
		return "/clean/table/form";
	}
	/**
	 * 获取文件清理
	 * @param table 文件清理实体
	 */
	@ApiOperation(value = "获取文件清理列表接口")
    @ApiImplicitParam(name = "id", value = "编号", required =true,paramType="query")
	@GetMapping("/get")
	@ResponseBody
	public ResultData get(@ModelAttribute @ApiIgnore TableEntity table,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model){
		if(table.getId()==null) {
			return ResultData.build().error();
		}
		TableEntity _table = (TableEntity)tableBiz.getEntity(Integer.parseInt(table.getId()));
		return ResultData.build().success(_table);
	}

	@ApiOperation(value = "保存文件清理列表接口")
	 @ApiImplicitParams({
    	@ApiImplicitParam(name = "cleanTitle", value = "标题", required =true,paramType="query"),
    	@ApiImplicitParam(name = "cleanTable", value = "表名", required =true,paramType="query"),
    	@ApiImplicitParam(name = "cleanField", value = "清理字段", required =true,paramType="query"),
		@ApiImplicitParam(name = "createBy", value = "创建人", required =false,paramType="query"),
		@ApiImplicitParam(name = "createDate", value = "创建时间", required =false,paramType="query"),
		@ApiImplicitParam(name = "updateBy", value = "修改人", required =false,paramType="query"),
		@ApiImplicitParam(name = "updateDate", value = "修改时间", required =false,paramType="query"),
		@ApiImplicitParam(name = "del", value = "删除标记", required =false,paramType="query"),
		@ApiImplicitParam(name = "id", value = "编号", required =false,paramType="query"),
	})

	/**
	* 保存文件清理
	* @param table 文件清理实体
	*/
	@PostMapping("/save")
	@ResponseBody
	@LogAnn(title = "保存文件清理", businessType = BusinessTypeEnum.INSERT)
	@RequiresPermissions("clean:table:save")
	public ResultData save(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request) {
		//验证标题的值是否合法
		if(StringUtil.isBlank(table.getCleanTitle())){
			return ResultData.build().error(getResString("err.empty", this.getResString("clean.title")));
		}
		if(!StringUtil.checkLength(table.getCleanTitle()+"", 1, 30)){
			return ResultData.build().error(getResString("err.length", this.getResString("clean.title"), "1", "30"));
		}
		//验证表名的值是否合法
		if(StringUtil.isBlank(table.getCleanTable())){
			return ResultData.build().error(getResString("err.empty", this.getResString("clean.table")));
		}
		if(!StringUtil.checkLength(table.getCleanTable()+"", 1, 255)){
			return ResultData.build().error(getResString("err.length", this.getResString("clean.table"), "1", "255"));
		}
		//验证清理字段的值是否合法
		if(StringUtil.isBlank(table.getCleanField())){
			return ResultData.build().error(getResString("err.empty", this.getResString("clean.field")));
		}
		tableBiz.saveEntity(table);
		return ResultData.build().success(table);
	}

	/**
	 * @param table 文件清理实体
	 */
	@ApiOperation(value = "批量删除文件清理列表接口")
	@PostMapping("/delete")
	@ResponseBody
	@LogAnn(title = "删除文件清理", businessType = BusinessTypeEnum.DELETE)
	@RequiresPermissions("clean:table:del")
	public ResultData delete(@RequestBody List<TableEntity> tables,HttpServletResponse response, HttpServletRequest request) {
		int[] ids = new int[tables.size()];
		for(int i = 0;i<tables.size();i++){
			ids[i] =Integer.parseInt(tables.get(i).getId()) ;
		}
		tableBiz.delete(ids);
		return ResultData.build().success();
	}

	/**
	*	更新文件清理列表
	* @param table 文件清理实体
	*/
	 @ApiOperation(value = "更新文件清理列表接口")
	 @ApiImplicitParams({
	    @ApiImplicitParam(name = "id", value = "编号", required =true,paramType="query"),
    	@ApiImplicitParam(name = "cleanTitle", value = "标题", required =true,paramType="query"),
    	@ApiImplicitParam(name = "cleanTable", value = "表名", required =true,paramType="query"),
    	@ApiImplicitParam(name = "cleanField", value = "清理字段", required =true,paramType="query"),
		@ApiImplicitParam(name = "createBy", value = "创建人", required =false,paramType="query"),
		@ApiImplicitParam(name = "createDate", value = "创建时间", required =false,paramType="query"),
		@ApiImplicitParam(name = "updateBy", value = "修改人", required =false,paramType="query"),
		@ApiImplicitParam(name = "updateDate", value = "修改时间", required =false,paramType="query"),
		@ApiImplicitParam(name = "del", value = "删除标记", required =false,paramType="query"),
		@ApiImplicitParam(name = "id", value = "编号", required =false,paramType="query"),
	})
	@PostMapping("/update")
	@ResponseBody
	@LogAnn(title = "更新文件清理", businessType = BusinessTypeEnum.UPDATE)
	@RequiresPermissions("clean:table:update")
	public ResultData update(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response,
			HttpServletRequest request) {
		//验证标题的值是否合法
		if(StringUtil.isBlank(table.getCleanTitle())){
			return ResultData.build().error(getResString("err.empty", this.getResString("clean.title")));
		}
		if(!StringUtil.checkLength(table.getCleanTitle()+"", 1, 30)){
			return ResultData.build().error(getResString("err.length", this.getResString("clean.title"), "1", "30"));
		}
		//验证表名的值是否合法
		if(StringUtil.isBlank(table.getCleanTable())){
			return ResultData.build().error(getResString("err.empty", this.getResString("clean.table")));
		}
		if(!StringUtil.checkLength(table.getCleanTable()+"", 1, 255)){
			return ResultData.build().error(getResString("err.length", this.getResString("clean.table"), "1", "10"));
		}
		//验证清理字段的值是否合法
		if(StringUtil.isBlank(table.getCleanField())){
			return ResultData.build().error(getResString("err.empty", this.getResString("clean.field")));
		}
		tableBiz.updateEntity(table);
		return ResultData.build().success(table);
	}

}
