/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.clean.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.clean.action.BaseAction;
import net.mingsoft.clean.biz.ITableBiz;
import net.mingsoft.clean.entity.TableEntity;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6587\u4ef6\u6e05\u7406\u63a5\u53e3")
@Controller(value="cleanTableAction")
@RequestMapping(value={"/${ms.manager.path}/clean/table"})
public class TableAction
extends BaseAction {
    @Autowired
    private ITableBiz tableBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/clean/table/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u6587\u4ef6\u6e05\u7406\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="cleanTitle", value="\u6807\u9898", required=false, paramType="query"), @ApiImplicitParam(name="cleanTable", value="\u8868\u540d", required=false, paramType="query"), @ApiImplicitParam(name="cleanField", value="\u6e05\u7406\u5b57\u6bb5", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
        BasicUtil.startPage();
        List tableList = this.tableBiz.query(table);
        return ResultData.build().success((Object)new EUListBean(tableList, (int)BasicUtil.endPage((List)tableList).getTotal()));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute TableEntity table, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (table.getId() != null) {
            BaseEntity tableEntity = this.tableBiz.getEntity(Integer.parseInt(table.getId()));
            model.addAttribute("tableEntity", (Object)tableEntity);
        }
        return "/clean/table/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u6e05\u7406\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (table.getId() == null) {
            return ResultData.build().error();
        }
        TableEntity _table = (TableEntity)this.tableBiz.getEntity(Integer.parseInt(table.getId()));
        return ResultData.build().success((Object)_table);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6587\u4ef6\u6e05\u7406\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="cleanTitle", value="\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="cleanTable", value="\u8868\u540d", required=true, paramType="query"), @ApiImplicitParam(name="cleanField", value="\u6e05\u7406\u5b57\u6bb5", required=true, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @LogAnn(title="\u4fdd\u5b58\u6587\u4ef6\u6e05\u7406", businessType=BusinessTypeEnum.INSERT)
    @RequiresPermissions(value={"clean:table:save"})
    public ResultData save(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((Object)table.getCleanTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("clean.title")}));
        }
        if (!StringUtil.checkLength((String)(table.getCleanTitle() + ""), (int)1, (int)30)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("clean.title"), "1", "30"}));
        }
        if (StringUtil.isBlank((Object)table.getCleanTable())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("clean.table")}));
        }
        if (!StringUtil.checkLength((String)(table.getCleanTable() + ""), (int)1, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("clean.table"), "1", "255"}));
        }
        if (StringUtil.isBlank((Object)table.getCleanField())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("clean.field")}));
        }
        this.tableBiz.saveEntity(table);
        return ResultData.build().success((Object)table);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6587\u4ef6\u6e05\u7406\u5217\u8868\u63a5\u53e3")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @LogAnn(title="\u5220\u9664\u6587\u4ef6\u6e05\u7406", businessType=BusinessTypeEnum.DELETE)
    @RequiresPermissions(value={"clean:table:del"})
    public ResultData delete(@RequestBody List<TableEntity> tables, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            ids[i] = Integer.parseInt(tables.get(i).getId());
        }
        this.tableBiz.delete(ids);
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u6587\u4ef6\u6e05\u7406\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="cleanTitle", value="\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="cleanTable", value="\u8868\u540d", required=true, paramType="query"), @ApiImplicitParam(name="cleanField", value="\u6e05\u7406\u5b57\u6bb5", required=true, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @LogAnn(title="\u66f4\u65b0\u6587\u4ef6\u6e05\u7406", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"clean:table:update"})
    public ResultData update(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((Object)table.getCleanTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("clean.title")}));
        }
        if (!StringUtil.checkLength((String)(table.getCleanTitle() + ""), (int)1, (int)30)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("clean.title"), "1", "30"}));
        }
        if (StringUtil.isBlank((Object)table.getCleanTable())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("clean.table")}));
        }
        if (!StringUtil.checkLength((String)(table.getCleanTable() + ""), (int)1, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("clean.table"), "1", "10"}));
        }
        if (StringUtil.isBlank((Object)table.getCleanField())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("clean.field")}));
        }
        this.tableBiz.updateEntity(table);
        return ResultData.build().success((Object)table);
    }
}

