/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.clean.biz.impl;

import cn.hutool.core.util.ObjectUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.clean.biz.ITableBiz;
import net.mingsoft.clean.dao.ITableDao;
import net.mingsoft.clean.entity.TableEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="cleanTableBizImpl")
public class TableBizImpl
extends BaseBizImpl
implements ITableBiz {
    private static final Logger log = LoggerFactory.getLogger(TableBizImpl.class);
    @Autowired
    private AnnotationConfigServletWebServerApplicationContext applicationContext;
    @Autowired
    private ITableDao tableDao;
    @Value(value="${ms.upload.path}")
    private String uploadFloderPath;
    @Value(value="${ms.upload.mapping}")
    private String uploadMapping;
    @Value(value="${ms.clean.pattern:/(upload/.*?(png|gif|bmp|pdf|mp4|avi|jpg|gif))}")
    private String cleanFilePattern;
    private static Pattern filePattern;

    @PostConstruct
    public void init() {
        filePattern = Pattern.compile(this.cleanFilePattern);
    }

    protected IBaseDao getDao() {
        return this.tableDao;
    }

    @Override
    public void clearFile() {
        List list = this.queryAll();
        ArrayList<File> fileList = new ArrayList<File>();
        File relFile = new File(this.uploadFloderPath);
        if (relFile.isAbsolute()) {
            this.findFiles(relFile, fileList);
        } else {
            this.findFiles(new File(this.getRealPath(this.uploadFloderPath)), fileList);
            this.findFiles(new File(this.getRealPath("ueditor")), fileList);
        }
        long startTime = System.currentTimeMillis();
        ArrayList<String> exitFiles = new ArrayList<String>();
        String uploadFile = relFile.isAbsolute() ? relFile.toString() : this.getRealPath("");
        for (TableEntity tableEntity : list) {
            if (!StringUtils.isNotBlank((CharSequence)tableEntity.getCleanField())) continue;
            String[] fields = tableEntity.getCleanField().split(",");
            try {
                exitFiles.addAll(this.tableTraList(tableEntity.getCleanTable(), fields, uploadFile));
            }
            catch (Exception e) {
                log.error("\u6e05\u7406\u9519\u8bef:", (Throwable)e);
            }
        }
        int deleFile = this.deleFile(fileList, exitFiles);
        long endTime = System.currentTimeMillis();
        log.info("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6 {}ms,\u627e\u5230{}\u4e2a\u6587\u4ef6,\u9700\u9a8c\u8bc1{}\u4e2a\u6587\u4ef6,\u5220\u9664{}\u4e2a\u6587\u4ef6", new Object[]{endTime - startTime, list.size(), exitFiles.size(), deleFile});
    }

    private int deleFile(List<File> source, List<String> exitFile) {
        int i = 0;
        for (File file : source) {
            if (exitFile.contains(file.getPath())) continue;
            ++i;
            file.delete();
        }
        return i;
    }

    public List<String> tableTraList(String table, String[] fields, String rootPath) {
        ArrayList<String> paths = new ArrayList<String>();
        List list = (List)this.excuteSql("SELECT * FROM " + table);
        for (Map map : list) {
            for (String key : fields) {
                if (!ObjectUtil.isNotNull(map.get(key))) continue;
                Matcher matcher = filePattern.matcher((CharSequence)map.get(key));
                while (matcher.find()) {
                    String fileName = matcher.group(1);
                    File file = new File(rootPath, this.formatFileName(fileName));
                    if (!file.exists() || !StringUtils.isNotBlank((CharSequence)fileName)) continue;
                    paths.add(file.getPath());
                }
            }
        }
        return paths;
    }

    public String formatFileName(String url) {
        if (new File(this.uploadFloderPath).isAbsolute()) {
            try {
                return url.substring(this.uploadMapping.replace("/**", "").length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    private void findFiles(File diy, List<File> list) {
        File[] files = diy.listFiles();
        if (ObjectUtil.isNotNull((Object)diy) && ObjectUtil.isNotNull(list) && diy.exists()) {
            for (File file : files) {
                if (file.isFile()) {
                    list.add(file);
                    continue;
                }
                this.findFiles(file, list);
            }
        }
    }

    public String getRealPath(String filePath) {
        String classPath = BasicUtil.getClassPath((String)filePath);
        if (classPath.startsWith("file")) {
            return System.getProperty("user.dir") + File.separator + filePath;
        }
        String path = this.applicationContext.getServletContext().getRealPath("/");
        if (!StringUtils.isEmpty((CharSequence)filePath)) {
            String last = path.charAt(path.length() - 1) + "";
            String frist = filePath.charAt(0) + "";
            path = last.equals(File.separator) ? (!frist.equals("\\") && !frist.equals("/") ? path + filePath : path + filePath.substring(1)) : (!frist.equals("\\") && !frist.equals("/") ? path + File.separator + filePath : path + filePath);
        }
        return path;
    }
}

