<el-dialog id="form" v-loading="loading" :close-on-click-modal="false" v-cloak title="文件清理" :visible.sync="dialogVisible" width="50%">
    <el-form ref="form" :model="form" :rules="rules" label-width="120px" label-position="right" size="small">
        <el-form-item  label="标题" prop="cleanTitle">
            <el-input
                    v-model="form.cleanTitle"
                    :disabled="false"
                    :readonly="false"
                    :style="{width:  '100%'}"
                    :clearable="true"
                    maxlength="30"
                    placeholder="请输入标题">
            </el-input>
        </el-form-item>
        <el-form-item  label="表名" prop="cleanTable">
            <el-input
                    v-model="form.cleanTable"
                    :disabled="false"
                    maxlength="50"
                    :style="{width:  '100%'}"
                    :clearable="true"
                    placeholder="请输入表名">
            </el-input>
        </el-form-item>
        <el-form-item  label="清理字段" prop="cleanField">
            <template slot='label'>清理字段
                <el-popover placement="top-start" title="提示" trigger="hover">
                    存放文件的字段，使用逗号(,)分隔
                    <i class="el-icon-question" slot="reference"></i>
                </el-popover>
            </template>
            <el-input
                    type="textarea" :rows="5"
                    :disabled="false"
                    v-model="form.cleanField"
                    :style="{width: '100%'}"
                    maxlength="200"
                    placeholder="请输入清理字段">
            </el-input>
        </el-form-item>
    </el-form>
    <div slot="footer">
        <el-button size="mini" @click="dialogVisible = false">取 消</el-button>
        <el-button size="mini" type="primary" @click="save()" :loading="saveDisabled">保存</el-button>
    </div>
</el-dialog>
<script>
    var form = new Vue({
        el: '#form',
        data:function() {
            return {
                loading: false,
                saveDisabled: false,
                dialogVisible:false,
                //表单数据
                form: {
                    // 标题
                    cleanTitle:'',
                    // 表名
                    cleanTable:'',
                    // 清理字段
                    cleanField:'',
                },
                rules:{
                    // 标题
                    cleanTitle: [{"required":true,"message":"标题不能为空"}],
                    // 表名
                    cleanTable: [{"required":true,"message":"表名不能为空"}],
                    // 清理字段
                    cleanField: [{"required":true,"message":"清理字段不能为空"}],
                },

            }
        },
        watch:{
            dialogVisible:function (v) {
                if(!v){
                    this.$refs.form.resetFields();
                    this.form.id =0
                }
            }
        },
        computed:{
        },
        methods: {
            open:function(id){
                if (id) {
                    this.get(id);
                }
                this.$nextTick(function () {
                    this.dialogVisible = true;
                })
            },
            save:function() {
                var that = this;
                var url = ms.manager + "/clean/table/save.do"
                if (that.form.id > 0) {
                    url = ms.manager + "/clean/table/update.do";
                }
                this.$refs.form.validate(function(valid) {
                    if (valid) {
                        that.saveDisabled = true;
                        var data = JSON.parse(JSON.stringify(that.form));
                        ms.http.post(url, data).then(function (data) {
                            if (data.result) {
                                that.$notify({
                                    title: '成功',
                                    message: '保存成功',
                                    type: 'success'
                                });
                                that.dialogVisible = false;
                                indexVue.list();
                            } else {
                                that.$notify({
                                    title: '失败',
                                    message: data.msg,
                                    type: 'warning'
                                });
                            }
                            that.saveDisabled = false;
                        });
                    } else {
                        return false;
                    }
                })
            },

            //获取当前文件清理
            get:function(id) {
                var that = this;
                this.loading = true
                ms.http.get(ms.manager + "/clean/table/get.do", {"id":id}).then(function (res) {
                    that.loading = false
                    if(res.result&&res.data){
                        that.form = res.data;
                    }
                }).catch(function (err) {
                    console.log(err);
                });
            },
        },
        created:function() {
            var that = this;
        }
    });
</script>