/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.dao.IConfigDao;
import net.mingsoft.mdiy.entity.ConfigEntity;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mdiyConfigBizImpl")
public class ConfigBizImpl
extends BaseBizImpl<IConfigDao, ConfigEntity>
implements IConfigBiz {
    @Autowired
    private IConfigDao configDao;
    @Autowired
    private IModelBiz modelBiz;

    protected IBaseDao getDao() {
        return this.configDao;
    }

    @Override
    public boolean importConfig(String customType, ModelJsonBean modelJsonBean) {
        if (StringUtils.isBlank((CharSequence)modelJsonBean.getTitle())) {
            return false;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ModelEntity::getModelName, (Object)modelJsonBean.getTitle())).eq(ModelEntity::getModelCustomType, (Object)customType);
        List modelEntities = this.modelBiz.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)modelEntities)) {
            return false;
        }
        ModelEntity model = new ModelEntity();
        model.setModelName(modelJsonBean.getTitle());
        model.setModelCustomType(customType);
        model.setModelIdType(modelJsonBean.getId());
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("html", modelJsonBean.getHtml());
        json.put("searchJson", modelJsonBean.getSearchJson());
        json.put("script", modelJsonBean.getScript());
        json.put("isWebSubmit", modelJsonBean.isWebSubmit());
        json.put("isWebCode", modelJsonBean.isWebCode());
        json.put("id", modelJsonBean.getId());
        if (BasicUtil.getWebsiteApp() != null) {
            json.put("sql", modelJsonBean.getSql().replace("_" + BasicUtil.getWebsiteApp().getId(), ""));
            json.put("tableName", modelJsonBean.getTableName().replace("_" + BasicUtil.getWebsiteApp().getId(), ""));
        } else {
            json.put("tableName", modelJsonBean.getTableName());
            json.put("sql", modelJsonBean.getSql());
        }
        json.put("form", modelJsonBean.getForm());
        model.setModelField(modelJsonBean.getField());
        model.setModelType("");
        model.setModelJson(JSONUtil.toJsonStr(json));
        model.setCreateDate(new Date());
        this.modelBiz.save((Object)model);
        ConfigEntity configEntity = new ConfigEntity();
        configEntity.setConfigName(modelJsonBean.getTitle());
        configEntity.setConfigType(customType);
        configEntity.setModelId(model.getId());
        this.save((Object)configEntity);
        return true;
    }

    @Override
    public boolean updateConfig(String modelId, ModelJsonBean modelJsonBean) {
        if (StringUtils.isEmpty((CharSequence)modelId) || modelJsonBean == null) {
            return false;
        }
        ModelEntity modelEntity = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        if (ObjectUtil.isNull((Object)((Object)modelEntity))) {
            return false;
        }
        ModelEntity model = new ModelEntity();
        model.setModelName(modelJsonBean.getTitle());
        model.setModelCustomType(modelEntity.getModelCustomType());
        ModelEntity oldModel = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)new QueryWrapper((Object)model)));
        if (ObjectUtil.isNotNull((Object)((Object)oldModel)) && !modelEntity.getId().equals(oldModel.getId())) {
            return false;
        }
        this.modelBiz.updateModelField(modelJsonBean, modelEntity, "");
        List mapList = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)modelJsonBean.getField()), Map.class);
        List fieldList = mapList.stream().map(map -> StrUtil.toCamelCase((CharSequence)map.get("field").toString().toLowerCase())).collect(Collectors.toList());
        fieldList.add("linkId");
        fieldList.add("modelId");
        ConfigEntity configEntity = (ConfigEntity)((Object)this.getOne((Wrapper)new QueryWrapper().eq((Object)"model_id", (Object)modelId)));
        Map map2 = (Map)JSONUtil.toBean((String)configEntity.getConfigData(), Map.class);
        if (CollUtil.isNotEmpty((Map)map2)) {
            Object[] keys;
            for (Object key : keys = map2.keySet().toArray()) {
                if (fieldList.contains(key)) continue;
                map2.remove(key);
            }
            configEntity.setConfigName(modelJsonBean.getTitle());
            configEntity.setConfigData(JSONUtil.toJsonStr((Object)map2));
            this.updateById((Object)configEntity);
        }
        return true;
    }
}

