/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.base.util.BundleUtil;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.dao.IModelDao;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mdiyModelBizImpl")
@Transactional(rollbackFor={Exception.class})
public class ModelBizImpl
extends BaseBizImpl<IModelDao, ModelEntity>
implements IModelBiz {
    @Autowired
    private IModelDao modelDao;

    protected IBaseDao getDao() {
        return this.modelDao;
    }

    @Override
    public boolean importConfig(String customType, ModelJsonBean modelJsonBean) {
        if (StringUtils.isEmpty((CharSequence)customType) || modelJsonBean == null) {
            return false;
        }
        return this.importModel(customType, modelJsonBean, "");
    }

    @Override
    public boolean importModel(String customType, ModelJsonBean modelJsonBean, String modelType) {
        Pattern alterPattern;
        Pattern createPattern;
        String alterRegex;
        String createRegex;
        if (StringUtils.isEmpty((CharSequence)customType) || modelJsonBean == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)modelJsonBean.getTitle())) {
            return false;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(StringUtils.isNotBlank((CharSequence)customType), ModelEntity::getModelCustomType, (Object)customType)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ModelEntity::getModelName, (Object)modelJsonBean.getTitle())).or()).eq(StrUtil.isNotBlank((CharSequence)modelJsonBean.getTableName()), ModelEntity::getModelTableName, (Object)("mdiy_" + customType + "_" + modelJsonBean.getTableName()));
        });
        List modelEntities = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)modelEntities)) {
            return false;
        }
        ModelEntity model = new ModelEntity();
        model.setModelName(modelJsonBean.getTitle());
        model.setModelTableName(modelJsonBean.getTableName());
        model.setModelCustomType(customType);
        model.setModelIdType(modelJsonBean.getId());
        String tmpSql = modelJsonBean.getSql();
        Pattern compile = Pattern.compile(";[\\s\\S]*?(CREATE OR REPLACE[\\s\\S]*;)", 2);
        Matcher matcher = compile.matcher(tmpSql);
        if (matcher.find()) {
            tmpSql = matcher.group(1);
            modelJsonBean.setSql(modelJsonBean.getSql().replace(tmpSql, ""));
        } else {
            tmpSql = "";
        }
        if (customType.equalsIgnoreCase(ModelCustomTypeEnum.MODEL.getLabel())) {
            model.setModelTableName("MDIY_MODEL_" + modelJsonBean.getTableName());
            tmpSql = tmpSql.replace("{model}", "MDIY_MODEL_");
            if (StringUtils.isNotBlank((CharSequence)modelJsonBean.getSql())) {
                String[] modelSqls;
                for (String sql : modelSqls = modelJsonBean.getSql().replace("{model}", "MDIY_MODEL_").trim().split(";")) {
                    if (StringUtils.containsAnyIgnoreCase((CharSequence)sql, (CharSequence[])new CharSequence[]{"CREATE TABLE", "ALTER TABLE"})) {
                        createRegex = "CREATE[\\s]*TABLE[\\s\\S]*MDIY_MODEL_" + modelJsonBean.getTableName().toUpperCase();
                        alterRegex = "ALTER[\\s]*TABLE[\\s\\S]*MDIY_MODEL_" + modelJsonBean.getTableName().toUpperCase();
                        createPattern = Pattern.compile(createRegex);
                        alterPattern = Pattern.compile(alterRegex);
                        if (createPattern.matcher(sql.toUpperCase()).find() || alterPattern.matcher(sql.toUpperCase()).find()) {
                            this.execute(sql);
                            continue;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)sql) || StrUtil.containsAnyIgnoreCase((CharSequence)sql, (CharSequence[])new CharSequence[]{"INSERT ", "SELECT ", "UPDATE ", "DELETE ", "DROP ", "ALTER ", "TRUNCATE ", "RENAME "})) continue;
                    this.execute(sql);
                }
            }
        }
        if (customType.equalsIgnoreCase(ModelCustomTypeEnum.FORM.getLabel())) {
            String[] formSqls;
            model.setModelTableName("MDIY_FORM_" + modelJsonBean.getTableName());
            modelJsonBean.setSql(modelJsonBean.getSql().replaceAll("ALTER TABLE[\\s\\S]*?UNIQUE[\\s\\S]*?;", ""));
            tmpSql = tmpSql.replace("{model}", "MDIY_FORM_");
            for (String sql : formSqls = modelJsonBean.getSql().replace("{model}", "MDIY_FORM_").trim().split(";")) {
                if (StrUtil.containsAnyIgnoreCase((CharSequence)sql, (CharSequence[])new CharSequence[]{"CREATE TABLE", "ALTER TABLE"})) {
                    createRegex = "CREATE[\\s]*TABLE[\\s\\S]*MDIY_FORM_" + modelJsonBean.getTableName().toUpperCase();
                    alterRegex = "ALTER[\\s]*TABLE[\\s\\S]*MDIY_FORM_" + modelJsonBean.getTableName().toUpperCase();
                    createPattern = Pattern.compile(createRegex);
                    alterPattern = Pattern.compile(alterRegex);
                    if (createPattern.matcher(sql.toUpperCase()).find() || alterPattern.matcher(sql.toUpperCase()).find()) {
                        this.execute(sql);
                        continue;
                    }
                }
                if ((StringUtils.isBlank((CharSequence)sql) || StrUtil.containsAnyIgnoreCase((CharSequence)sql, (CharSequence[])new CharSequence[]{"INSERT ", "SELECT ", "UPDATE ", "DELETE ", "DROP ", "ALTER ", "TRUNCATE ", "RENAME ", "UNIQUE_LINK_ID`(`LINK_ID`)", "UNIQUE(\"LINK_ID\")", "DROP TABLE "})) && sql.indexOf("CREATE") < 0) continue;
                sql = sql.replace("FROM dual", "FROM dual;").replace(" END", " END;");
                try {
                    this.execute(sql);
                }
                catch (Exception e) {
                    this.LOG.debug("\u6076\u610f\u6267\u884c sql: {}", (Object)sql);
                    e.printStackTrace();
                }
                this.LOG.debug(sql);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)tmpSql)) {
            this.execute(tmpSql);
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("html", modelJsonBean.getHtml());
        json.put("searchJson", modelJsonBean.getSearchJson());
        json.put("script", modelJsonBean.getScript());
        json.put("isWebSubmit", modelJsonBean.isWebSubmit());
        json.put("isWebCode", modelJsonBean.isWebCode());
        json.put("id", modelJsonBean.getId());
        if (BasicUtil.getWebsiteApp() != null) {
            json.put("sql", modelJsonBean.getSql().replace("_" + BasicUtil.getWebsiteApp().getId(), ""));
            json.put("tableName", modelJsonBean.getTableName().replace("_" + BasicUtil.getWebsiteApp().getId(), ""));
        } else {
            json.put("tableName", modelJsonBean.getTableName());
            json.put("sql", modelJsonBean.getSql());
        }
        json.put("form", modelJsonBean.getForm());
        model.setModelField(modelJsonBean.getField());
        model.setModelType(modelType);
        model.setModelJson(JSONUtil.toJsonStr(json));
        model.setCreateDate(new Date());
        super.save((Object)model);
        return true;
    }

    @Override
    public boolean updateConfig(String modelId, ModelJsonBean modelJsonBean) {
        if (StringUtils.isEmpty((CharSequence)modelId) || modelJsonBean == null) {
            return false;
        }
        return this.updateConfig(modelId, modelJsonBean, "");
    }

    @Override
    public void updateModelField(ModelJsonBean modelJsonBean, ModelEntity modelEntity, String modelType) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("html", modelJsonBean.getHtml());
        json.put("searchJson", modelJsonBean.getSearchJson());
        json.put("script", modelJsonBean.getScript());
        json.put("isWebSubmit", modelJsonBean.isWebSubmit());
        json.put("isWebCode", modelJsonBean.isWebCode());
        json.put("form", modelJsonBean.getForm());
        json.put("id", modelJsonBean.getId());
        if (BasicUtil.getWebsiteApp() != null) {
            if (StringUtils.isNotEmpty((CharSequence)modelJsonBean.getSql())) {
                json.put("sql", modelJsonBean.getSql().replace("_" + BasicUtil.getWebsiteApp().getId(), ""));
            }
            json.put("tableName", modelJsonBean.getTableName().replace("_" + BasicUtil.getWebsiteApp().getId(), ""));
        } else {
            if (StringUtils.isNotEmpty((CharSequence)modelJsonBean.getSql())) {
                json.put("sql", modelJsonBean.getSql());
            }
            json.put("tableName", modelJsonBean.getTableName());
        }
        if (modelJsonBean.getField() != null) {
            modelEntity.setModelField(modelJsonBean.getField());
        } else {
            modelEntity.setModelField("[]");
        }
        modelEntity.setModelName(modelJsonBean.getTitle());
        modelEntity.setModelType(modelType);
        modelEntity.setModelJson(JSONUtil.toJsonStr(json));
        modelEntity.setUpdateDate(new Date());
        super.updateById((Object)modelEntity);
    }

    @Override
    public boolean updateConfig(String modelId, ModelJsonBean modelJsonBean, String modelType) {
        if (StringUtils.isEmpty((CharSequence)modelId) || modelJsonBean == null) {
            return false;
        }
        ModelEntity modelEntity = (ModelEntity)((Object)super.getById((Serializable)((Object)modelId)));
        if (ObjectUtil.isNull((Object)((Object)modelEntity))) {
            return false;
        }
        ModelEntity model = new ModelEntity();
        model.setModelName(modelJsonBean.getTitle());
        model.setModelCustomType(modelEntity.getModelCustomType());
        ModelEntity oldModel = (ModelEntity)((Object)super.getOne((Wrapper)new QueryWrapper((Object)model)));
        if (ObjectUtil.isNotNull((Object)((Object)oldModel)) && !modelEntity.getId().equals(oldModel.getId())) {
            return false;
        }
        String oldTableName = modelEntity.getModelTableName();
        if (modelEntity.getModelCustomType().equalsIgnoreCase(ModelCustomTypeEnum.MODEL.getLabel())) {
            modelEntity.setModelTableName(("MDIY_MODEL_" + modelJsonBean.getTableName()).toUpperCase());
            if (!oldTableName.equals(modelEntity.getModelTableName())) {
                throw new BusinessException(BundleUtil.getBaseString((String)"err.error", (String[])new String[]{BundleUtil.getString((String)"net.mingsoft.mdiy.resources.resources", (String)"table.name", (String[])new String[0])}));
            }
        }
        if (modelEntity.getModelCustomType().equalsIgnoreCase(ModelCustomTypeEnum.FORM.getLabel())) {
            modelEntity.setModelTableName(("MDIY_FORM_" + modelJsonBean.getTableName()).toUpperCase());
            if (StringUtils.isNotBlank((CharSequence)modelJsonBean.getTableName()) && !oldTableName.equals(modelEntity.getModelTableName())) {
                throw new BusinessException(BundleUtil.getBaseString((String)"err.error", (String[])new String[]{BundleUtil.getString((String)"net.mingsoft.mdiy.resources.resources", (String)"table.name", (String[])new String[0])}));
            }
        }
        this.updateTable(modelEntity.getModelField(), modelJsonBean.getField(), oldTableName);
        this.updateModelField(modelJsonBean, modelEntity, modelType);
        return true;
    }

    @Override
    public boolean delete(List<String> ids) {
        for (String id : ids) {
            ModelEntity modelEntity = (ModelEntity)((Object)super.getById((Serializable)((Object)id)));
            boolean flag = super.removeById((Serializable)((Object)id));
            if (!flag) {
                this.LOG.debug("{}\u5220\u9664\u5931\u8d25", (Object)modelEntity.getModelTableName());
                break;
            }
            try {
                if (StrUtil.isBlank((CharSequence)modelEntity.getModelTableName())) continue;
                SqlInjectionUtil.filterContent((String[])new String[]{modelEntity.getModelTableName()});
                this.execute("DROP TABLE " + modelEntity.getModelTableName());
            }
            catch (Exception e) {
                this.LOG.debug("{}\u8868\u4e0d\u5b58\u5728", (Object)modelEntity.getModelTableName());
                e.printStackTrace();
            }
        }
        return true;
    }

    private void updateTable(String oldStr, String newStr, String tableName) {
        List oldList = JSONUtil.toList((String)oldStr, Dict.class);
        List newList = JSONUtil.toList((String)newStr, Dict.class);
        StringBuffer stringBuffer = new StringBuffer();
        Collection disMap = CollUtil.disjunction((Collection)oldList, (Collection)newList);
        if (CollUtil.isNotEmpty((Collection)disMap)) {
            String[] formSqls;
            Collection newIntersection;
            Collection oldIntersection = CollUtil.intersection((Collection)oldList, (Collection)disMap);
            String alertTable = "";
            stringBuffer.append(alertTable);
            if (CollUtil.isNotEmpty((Collection)oldIntersection)) {
                String dropSql = StrUtil.format((CharSequence)"ALTER TABLE {} ", (Object[])new Object[]{tableName.toUpperCase()}).concat("DROP COLUMN {};");
                List dropList = oldIntersection.stream().map(dict -> {
                    List collect = newList.stream().filter(_dict -> _dict.getStr("field").equals(dict.getStr("field"))).collect(Collectors.toList());
                    if (CollUtil.isEmpty(collect)) {
                        return StrUtil.format((CharSequence)dropSql, (Object[])new Object[]{dict.getStr("field")});
                    }
                    return null;
                }).collect(Collectors.toList());
                dropList.removeAll(Collections.singleton(null));
                if (CollUtil.isNotEmpty(dropList)) {
                    stringBuffer.append(CollUtil.join(dropList, (CharSequence)";"));
                }
            }
            if (CollUtil.isNotEmpty((Collection)(newIntersection = CollUtil.intersection((Collection)newList, (Collection)disMap)))) {
                String addSql = StrUtil.format((CharSequence)"ALTER TABLE {} ", (Object[])new Object[]{tableName.toUpperCase()}).concat("ADD  {} {}({}) NULL;");
                String modifySql = StrUtil.format((CharSequence)"ALTER TABLE {} ", (Object[])new Object[]{tableName.toUpperCase()}).concat("MODIFY {} {}({}) ;");
                List addList = newIntersection.stream().map(dict -> {
                    List collect = oldList.stream().filter(_dict -> _dict.getStr("field").equals(dict.getStr("field"))).collect(Collectors.toList());
                    if (StrUtil.equalsAnyIgnoreCase((CharSequence)dict.getStr("jdbcType"), (CharSequence[])new CharSequence[]{"INT", "BIGINT"})) {
                        dict.set("length", (Object)"0");
                    }
                    if (CollUtil.isEmpty(collect)) {
                        return StrUtil.format((CharSequence)addSql, (Object[])new Object[]{dict.getStr("field"), dict.getStr("jdbcType"), dict.getStr("length")}).replaceAll("\\(0\\)", "");
                    }
                    return StrUtil.format((CharSequence)modifySql, (Object[])new Object[]{dict.getStr("field"), dict.getStr("jdbcType"), dict.getStr("length")}).replaceAll("\\(0\\)", "");
                }).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(addList)) {
                    stringBuffer.append(CollUtil.join(addList, (CharSequence)";"));
                }
            }
            this.LOG.debug("\u6267\u884c\u7684SQL{}", (Object)stringBuffer);
            for (String sql : formSqls = stringBuffer.toString().split(";")) {
                if (StringUtils.isBlank((CharSequence)sql) || StrUtil.containsAnyIgnoreCase((CharSequence)sql, (CharSequence[])new CharSequence[]{"SELECT ", "INSERT ", "DELETE ", "DELETE "})) continue;
                try {
                    this.execute(sql);
                }
                catch (Exception e) {
                    this.LOG.error("\u6267\u884cSQL {} \u5931\u8d25", (Object)sql);
                    e.printStackTrace();
                    throw new BusinessException("\u6a21\u578b\u66f4\u65b0\u5931\u8d25");
                }
            }
        }
    }
}

