/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mingsoft.base.biz.SqlQueryWrapper;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.IModelDataBiz;
import net.mingsoft.mdiy.dao.IModelDao;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelDataImpl
extends BaseBizImpl
implements IModelDataBiz {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IModelDao modelDao;

    protected IBaseDao getDao() {
        return this.modelDao;
    }

    @Override
    public boolean saveDiyFormData(String modelId, Map<String, Object> params) {
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        return this.saveDiyFormData(model, params);
    }

    @Override
    public boolean saveDiyFormData(ModelEntity model, Map<String, Object> params) {
        if (ObjectUtil.isNotNull((Object)((Object)model))) {
            this.spliceInsertSql(model, params);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateDiyFormData(String modelId, Map<String, Object> params) {
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        return this.updateDiyFormData(model, params);
    }

    @Override
    public boolean updateDiyFormData(ModelEntity model, Map<String, Object> params) {
        if (ObjectUtil.isNotNull((Object)((Object)model))) {
            this.spliceUpdateSql(model, params);
            return true;
        }
        return false;
    }

    @Override
    public SqlQueryWrapper.EUListBean queryDiyFormData(String modelId, Map<String, Object> params) {
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        if (ObjectUtil.isNotNull((Object)((Object)model))) {
            Map fieldMap = model.getFieldMap();
            HashMap<String, Object> fields = new HashMap<String, Object>();
            for (String s : params.keySet()) {
                if (!fieldMap.containsKey(s)) continue;
                fields.put(fieldMap.get(s).toString(), params.get(s));
            }
            List sqlWhereList = null;
            if (params.get("sqlWhere") != null) {
                sqlWhereList = JSONUtil.toList((String)params.get("sqlWhere").toString(), Map.class);
            }
            String orderBy = null;
            if (params.get("orderBy") != null) {
                orderBy = params.get("orderBy").toString();
            }
            String order = null;
            if (params.get("order") != null) {
                order = params.get("order").toString();
            }
            SqlInjectionUtil.filterContent((String[])new String[]{orderBy});
            SqlInjectionUtil.filterContent((String[])new String[]{model.getModelTableName()});
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            List formFields = (List)MapUtil.get(params, (Object)"formFields", List.class);
            if (CollUtil.isEmpty((Collection)formFields)) {
                sb.append("*");
            } else {
                sb.append(CollUtil.join((Iterable)formFields, (CharSequence)","));
            }
            sb.append(" FROM ");
            sb.append(model.getModelTableName());
            ArrayList paramsList = new ArrayList();
            if (CollUtil.isNotEmpty(fields)) {
                sb.append(" WHERE ");
                for (String key : fields.keySet()) {
                    sb.append(key).append(" = ").append("?").append(" AND ");
                    paramsList.add(fields.get(key));
                }
                sb.delete(sb.lastIndexOf("AND"), sb.length());
            }
            SqlQueryWrapper select = new SqlQueryWrapper(sb.toString(), paramsList.toArray()).sqlWhere(JSONUtil.toJsonStr((Object)sqlWhereList));
            if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
                if ("desc".equalsIgnoreCase(order)) {
                    select.orderByDesc(orderBy);
                } else {
                    select.orderByAsc(orderBy);
                }
            }
            select.page((BasicUtil.getPageNo() - 1) * BasicUtil.getPageSize(), BasicUtil.getPageSize());
            return this.modelBiz.queryForListPage(select);
        }
        return null;
    }

    @Override
    public Object getFormData(String modelId, String id) {
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)modelId)) {
            this.LOG.debug("\u6a21\u578b\u6216\u4e3b\u952e\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        if (model == null) {
            this.LOG.debug("\u6a21\u578b\u4e0d\u5b58\u5728");
            return null;
        }
        SqlInjectionUtil.filterContent((String[])new String[]{model.getModelTableName()});
        String sql = StrUtil.format((CharSequence)"SELECT * FROM {} WHERE id = ?", (Object[])new Object[]{model.getModelTableName()});
        List list = this.modelBiz.queryForList(sql, new Object[]{id});
        if (CollUtil.isEmpty((Collection)list)) {
            return null;
        }
        HashMap modelEntity = new HashMap();
        Map fieldMap = model.getFieldMap();
        for (String s : ((Map)list.get(0)).keySet()) {
            for (Map.Entry entry : fieldMap.entrySet()) {
                if (!s.equalsIgnoreCase(entry.getValue().toString())) continue;
                modelEntity.put(entry.getKey(), ((Map)list.get(0)).get(s));
            }
        }
        modelEntity.put("id", id);
        return modelEntity;
    }

    @Override
    public void deleteQueryDiyFormData(String id, String diyFormId) {
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)diyFormId)));
        if (ObjectUtil.isNotNull((Object)((Object)model))) {
            SqlInjectionUtil.filterContent((String[])new String[]{model.getModelTableName()});
            String sql = StrUtil.format((CharSequence)"DELETE FROM {} WHERE id = ?", (Object[])new Object[]{model.getModelTableName()});
            this.modelBiz.update(sql, new Object[]{id});
        }
    }

    @Override
    public void spliceInsertSql(ModelEntity model, Map<String, Object> params) {
        SqlInjectionUtil.filterContent((String[])new String[]{model.getModelTableName()});
        CaseInsensitiveMap fieldMap = new CaseInsensitiveMap(model.getFieldMap());
        List fieldList = JSONUtil.toList((String)model.getModelField(), Map.class);
        ArrayList<Object> param = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(model.getModelTableName()).append(" (");
        StringBuilder values = new StringBuilder();
        Set<String> paramKeys = Collections.unmodifiableSet(new HashSet<String>(params.keySet()));
        String fieldName = "";
        String type = "";
        String value = "";
        for (Map map : fieldList) {
            fieldName = MapUtil.getStr((Map)map, (Object)"model").toLowerCase();
            if (!paramKeys.contains(fieldName) || !fieldMap.containsKey(fieldName)) continue;
            type = MapUtil.getStr((Map)map, (Object)"type", (String)"String");
            if ("date".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type)) {
                value = new SqlQueryWrapper().handleTime(type);
                sql.append(fieldMap.get(fieldName)).append(", ");
                values.append(value).append(", ");
                param.add(params.get(fieldName));
                continue;
            }
            sql.append(fieldMap.get(fieldName)).append(", ");
            values.append("?, ");
            param.add(params.get(fieldName));
        }
        if (model.getModelIdType() == 0) {
            Snowflake snowflake = IdUtil.getSnowflake();
            sql.append("ID, ");
            values.append("?, ");
            param.add(snowflake.nextId());
        }
        if (StrUtil.isNotBlank((CharSequence)MapUtil.getStr(params, (Object)"linkid"))) {
            sql.append("LINK_ID, ");
            values.append("?, ");
            param.add(MapUtil.getStr(params, (Object)"linkid"));
        }
        if (BasicUtil.getManager() != null) {
            sql.append("CREATE_BY, ");
            values.append("?, ");
            param.add(BasicUtil.getManager().getId());
        }
        sql.append("CREATE_DATE, ").append("UPDATE_DATE").append(") VALUES (");
        values.append("?, ").append("?");
        param.add(new Date());
        param.add(new Date());
        sql.append((CharSequence)values).append(")");
        this.modelBiz.update(sql.toString(), param.toArray());
    }

    @Override
    public void spliceUpdateSql(ModelEntity model, Map<String, Object> params) {
        SqlInjectionUtil.filterContent((String[])new String[]{model.getModelTableName()});
        Map fieldMap = model.getFieldMap();
        fieldMap = new CaseInsensitiveMap(fieldMap);
        ArrayList<Object> fields = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(model.getModelTableName()).append(" SET ");
        List fieldList = JSONUtil.toList((String)model.getModelField(), Map.class);
        Set<String> paramKeys = Collections.unmodifiableSet(new HashSet<String>(params.keySet()));
        String fieldName = "";
        String type = "";
        String value = "";
        for (Map map : fieldList) {
            fieldName = MapUtil.getStr((Map)map, (Object)"model").toLowerCase();
            if (!paramKeys.contains(fieldName) || !fieldMap.containsKey(fieldName)) continue;
            type = MapUtil.getStr((Map)map, (Object)"type", (String)"String");
            if ("date".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type)) {
                value = new SqlQueryWrapper().handleTime(type);
                sql.append(fieldMap.get(fieldName)).append(" = ").append(value).append(", ");
                fields.add(params.get(fieldName));
                continue;
            }
            sql.append(fieldMap.get(fieldName)).append(" = ").append("?, ");
            fields.add(params.get(fieldName));
        }
        if (StringUtils.isEmpty((CharSequence)params.get("id").toString())) {
            this.LOG.debug("\u8bf7\u6c42\u6570\u636e\u4e0d\u542b\u4e3b\u952eid,\u65e0\u6cd5\u66f4\u65b0");
            throw new BusinessException("\u8bf7\u6c42\u6570\u636e\u4e0d\u542b\u4e3b\u952eid,\u65e0\u6cd5\u66f4\u65b0");
        }
        sql.append("UPDATE_DATE = ?, ");
        fields.add(new Date());
        if (BasicUtil.getManager() != null) {
            sql.append("UPDATE_BY = ?");
            fields.add(BasicUtil.getManager().getId());
        }
        sql.append(" WHERE ID = ?");
        fields.add(params.get("id").toString());
        this.modelBiz.update(sql.toString(), fields.toArray());
    }
}

