/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IDictBiz;
import net.mingsoft.mdiy.entity.DictEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/dict"})
public class DictAction
extends BaseAction {
    @Autowired
    private IDictBiz dictBiz;

    @ApiIgnore
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/dict/index";
    }

    @ApiIgnore
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        return "/mdiy/dict/form";
    }

    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u5b57\u5178")
    @LogAnn(title="\u5bfc\u5165\u81ea\u5b9a\u4e49\u5b57\u5178", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/importJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:importJson"})
    public ResultData importJson(@RequestBody List<DictEntity> dictEntities, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (CollUtil.isEmpty(dictEntities)) {
            return ResultData.build().error("json\u683c\u5f0f\u4e0d\u5339\u914d");
        }
        List list = this.dictBiz.list();
        List dictEntityList = dictEntities.stream().filter(dictEntity -> !list.contains(dictEntity)).map(dictEntity -> {
            dictEntity.setId(null);
            return dictEntity;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(dictEntityList)) {
            this.dictBiz.saveBatch(dictEntityList, dictEntityList.size());
        }
        return ResultData.build().success();
    }

    @ApiOperation(value="\u67e5\u8be2\u5b57\u5178\u8868\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictType", value="\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="dictLabel", value="\u6807\u7b7e\u540d", required=false, paramType="query"), @ApiImplicitParam(name="dictValue", value="\u6570\u636e\u503c", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, paramType="query")})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        BasicUtil.startPage();
        if (dict.getDictEnable() == null) {
            dict.setDictEnable(true);
        } else {
            dict.setDictEnable(null);
        }
        List dictList = this.dictBiz.query(dict);
        return ResultData.build().success((Object)new EUListBean(dictList, (int)BasicUtil.endPage((List)dictList).getTotal()));
    }

    @ApiOperation(value="\u6839\u636e\u5b50\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7c7b\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, paramType="query")})
    @GetMapping(value={"/dictType"})
    @ResponseBody
    public ResultData dictType(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        BasicUtil.startPage();
        QueryWrapper dictEntityQueryWrapper = new QueryWrapper();
        dictEntityQueryWrapper.select(new String[]{"dict_type,min(CREATE_DATE) as min_create_time"});
        dictEntityQueryWrapper.groupBy((Object)"dict_type");
        dictEntityQueryWrapper.orderByDesc((Object)"min_create_time");
        List dictList = this.dictBiz.list((Wrapper)dictEntityQueryWrapper);
        return ResultData.build().success((Object)new EUListBean(dictList, (int)BasicUtil.endPage((List)dictList).getTotal()));
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u83b7\u53d6\u5b57\u5178\uff0c\u53ef\u652f\u6301\u591a\u4e2a\u7c7b\u578b\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictType", value="\u5b57\u5178\u7c7b\u578b", required=true, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, paramType="query")})
    @GetMapping(value={"/dictList"})
    @ResponseBody
    public ResultData dictList(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)dict.getDictType())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("dict.type")}));
        }
        String[] types = dict.getDictType().split(",");
        DictEntity _dict = new DictEntity();
        _dict.setIsChild(dict.getIsChild());
        ArrayList<List> list = new ArrayList<List>();
        for (String type : types) {
            _dict.setDictType(type);
            list.add(this.dictBiz.query(_dict));
        }
        return ResultData.build().success(list);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u8be6\u60c5\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u5b57\u5178\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isBlank((CharSequence)dict.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("dict.id")}));
        }
        DictEntity _dict = (DictEntity)((Object)this.dictBiz.getById((Serializable)((Object)dict.getId())));
        return ResultData.build().success((Object)_dict);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5b57\u5178\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictLabel", value="\u6807\u7b7e\u540d", required=true, paramType="query"), @ApiImplicitParam(name="dictType", value="\u7c7b\u578b", required=true, paramType="query"), @ApiImplicitParam(name="dictValue", value="\u6570\u636e\u503c", required=false, paramType="query"), @ApiImplicitParam(name="dictDescription", value="\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="dictSort", value="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, paramType="query"), @ApiImplicitParam(name="dictRemarks", value="\u5907\u6ce8\u4fe1\u606f", required=false, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u5b57\u5178\u63a5\u53e3", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:save"})
    public ResultData save(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)dict.getDictType())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.type")}));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictLabel())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.label")}));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictValue())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.value")}));
        }
        if (this.dictBiz.getByTypeAndLabelAndValue(dict.getDictType(), dict.getDictLabel(), null) != null) {
            return ResultData.build().error(this.getResString("diy.dict.type.and.label.repeat"));
        }
        if (this.dictBiz.getByTypeAndLabelAndValue(dict.getDictType(), null, dict.getDictValue()) != null) {
            return ResultData.build().error(this.getResString("diy.dict.type.and.value.repeat"));
        }
        this.dictBiz.save((Object)dict);
        this.dictBiz.updateCache();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5b57\u5178")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u5b57\u5178", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:del"})
    public ResultData delete(@RequestBody List<DictEntity> dicts, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[dicts.size()];
        for (int i = 0; i < dicts.size(); ++i) {
            ids[i] = Integer.parseInt(dicts.get(i).getId());
        }
        this.dictBiz.delete(ids);
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5b57\u5178\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="dictLabel", value="\u6807\u7b7e\u540d", required=true, paramType="query"), @ApiImplicitParam(name="dictType", value="\u7c7b\u578b", required=true, paramType="query"), @ApiImplicitParam(name="dictValue", value="\u6570\u636e\u503c", required=false, paramType="query"), @ApiImplicitParam(name="dictDescription", value="\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="dictSort", value="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, paramType="query"), @ApiImplicitParam(name="dictRemarks", value="\u5907\u6ce8\u4fe1\u606f", required=false, paramType="query")})
    @LogAnn(title="\u66f4\u65b0\u5b57\u5178\u4fe1\u606f\u63a5\u53e3", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:update"})
    public ResultData update(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)dict.getDictType())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.type")}));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictLabel())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.label")}));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictValue())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.value")}));
        }
        DictEntity dictEntity = this.dictBiz.getByTypeAndLabelAndValue(dict.getDictType(), dict.getDictLabel(), null);
        if (dictEntity != null && !dictEntity.getId().equals(dict.getId())) {
            return ResultData.build().error(this.getResString("diy.dict.type.and.label.repeat"));
        }
        dictEntity = this.dictBiz.getByTypeAndLabelAndValue(dict.getDictType(), null, dict.getDictValue());
        if (dictEntity != null && !dictEntity.getId().equals(dict.getId())) {
            return ResultData.build().error(this.getResString("diy.dict.type.and.value.repeat"));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictValue())) {
            dict.setDictValue(null);
        }
        this.dictBiz.updateById((Object)dict);
        this.dictBiz.updateCache();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u5237\u65b0\u5b57\u5178\u7f13\u5b58\u63a5\u53e3")
    @PostMapping(value={"/updateCache"})
    @RequiresPermissions(value={"mdiy:dict:update"})
    @ResponseBody
    public ResultData updateCache(HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        this.dictBiz.updateCache();
        return ResultData.build().success();
    }
}

