/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/form"})
public class FormAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;

    @ApiIgnore
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/form/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="modelTableName", value="\u6a21\u578b\u8868\u540d", required=false, paramType="query"), @ApiImplicitParam(name="appId", value="\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="modelJson", value="json", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"mdiy:form:view"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        modelEntity.setModelCustomType(ModelCustomTypeEnum.FORM.getLabel());
        BasicUtil.startPage();
        List modelList = this.modelBiz.list((Wrapper)new LambdaQueryWrapper((Object)modelEntity).orderByDesc(ModelEntity::getId));
        return ResultData.build().success((Object)new EUListBean(modelList, (int)BasicUtil.endPage((List)modelList).getTotal()));
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="modelTableName", value="\u6a21\u578b\u8868\u540d", required=false, paramType="query"), @ApiImplicitParam(name="appId", value="\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="modelJson", value="json", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query")})
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelName()) && StringUtils.isBlank((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.name") + " or " + this.getResString("model.id")}));
        }
        modelEntity.setModelCustomType(ModelCustomTypeEnum.FORM.getLabel());
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)new QueryWrapper((Object)modelEntity)));
        if (model == null) {
            return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("model.name") + " or " + this.getResString("model.id")}));
        }
        if (!this.hasPermissions("mdiy:form:view", "mdiy:formData:" + model.getId() + ":view")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        return ResultData.build().success((Object)model);
    }

    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelJson", value="json", required=true, paramType="query")})
    @LogAnn(title="\u5bfc\u5165", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/importJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:form:importJson"})
    public ResultData importJson(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.modelBiz.importConfig(ModelCustomTypeEnum.FORM.getLabel(), modelJsonBean)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @ApiOperation(value="\u66f4\u65b0\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelJson", value="json", required=true, paramType="query")})
    @LogAnn(title="\u5bfc\u5165", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/updateJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:form:update"})
    public ResultData updateJson(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        if (StringUtils.isBlank((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.modelBiz.updateConfig(modelEntity.getId(), modelJsonBean)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:form:del"})
    public ResultData delete(@RequestBody List<ModelEntity> models, HttpServletResponse response, HttpServletRequest request) {
        List<String> ids = models.stream().map(p -> p.getId()).collect(Collectors.toList());
        if (this.modelBiz.delete(ids)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
    }
}

