/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IPageBiz;
import net.mingsoft.mdiy.entity.PageEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/page"})
public class PageAction
extends BaseAction {
    @Autowired
    private IPageBiz pageBiz;

    @ApiIgnore
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/page/index";
    }

    @ApiIgnore
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute PageEntity page, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (ObjectUtil.isNotEmpty((Object)((Object)page)) && StringUtils.isNotEmpty((CharSequence)page.getId())) {
            BaseEntity pageEntity = (BaseEntity)this.pageBiz.getById((Serializable)((Object)page.getId()));
            model.addAttribute("pageEntity", (Object)pageEntity);
        }
        return "/mdiy/page/form";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u9875\u9762\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pagePath", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="pageTitle", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=false, paramType="query"), @ApiImplicitParam(name="pageKey", value="\u81ea\u5b9a\u4e49\u9875\u9762\u8bbf\u95ee\u8def\u5f84", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:view"})
    public ResultData list(@ModelAttribute @ApiIgnore PageEntity page, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        BasicUtil.startPage();
        List pageList = this.pageBiz.query(page);
        return ResultData.build().success((Object)new EUListBean(pageList, (int)BasicUtil.endPage((List)pageList).getTotal()));
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"mdiy:page:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore PageEntity page, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)page.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("page.id")}));
        }
        PageEntity _page = (PageEntity)((Object)this.pageBiz.getById((Serializable)((Object)page.getId())));
        return ResultData.build().success((Object)_page);
    }

    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pagePath", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=true, paramType="query"), @ApiImplicitParam(name="pageTitle", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="pageKey", value="\u81ea\u5b9a\u4e49\u9875\u9762\u8bbf\u95ee\u8def\u5f84", required=true, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:save"})
    public ResultData save(@ModelAttribute @ApiIgnore PageEntity page, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)page.getPagePath())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("page.path")}));
        }
        if (!StringUtil.checkLength((String)(page.getPagePath() + ""), (int)1, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("page.path"), "1", "255"}));
        }
        if (StringUtils.isBlank((CharSequence)page.getPageTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("page.title")}));
        }
        if (!StringUtil.checkLength((String)(page.getPageTitle() + ""), (int)1, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("page.title"), "1", "255"}));
        }
        if (StringUtils.isBlank((CharSequence)page.getPageKey())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("page.key")}));
        }
        if (!StringUtil.checkLength((String)(page.getPageKey() + ""), (int)1, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("page.key"), "1", "255"}));
        }
        PageEntity pageEntity = new PageEntity();
        pageEntity.setPageKey(page.getPageKey());
        PageEntity pageByPageKey = (PageEntity)((Object)this.pageBiz.getOne((Wrapper)new QueryWrapper((Object)pageEntity), false));
        if (pageByPageKey != null) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("page.key")}));
        }
        this.pageBiz.saveEntity(page);
        return ResultData.build().success((Object)page);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:del"})
    public ResultData delete(@RequestBody List<PageEntity> pages, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[pages.size()];
        for (int i = 0; i < pages.size(); ++i) {
            ids[i] = Integer.parseInt(pages.get(i).getId());
        }
        this.pageBiz.delete(ids);
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="pagePath", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=true, paramType="query"), @ApiImplicitParam(name="pageTitle", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="pageKey", value="\u81ea\u5b9a\u4e49\u9875\u9762\u8bbf\u95ee\u8def\u5f84", required=true, paramType="query")})
    @LogAnn(title="\u66f4\u65b0\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:update"})
    public ResultData update(@ModelAttribute @ApiIgnore PageEntity page, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)page.getPagePath())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("page.path")}));
        }
        if (!StringUtil.checkLength((String)(page.getPagePath() + ""), (int)1, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("page.path"), "1", "255"}));
        }
        if (StringUtils.isBlank((CharSequence)page.getPageTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("page.title")}));
        }
        if (!StringUtil.checkLength((String)(page.getPageTitle() + ""), (int)1, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("page.title"), "1", "255"}));
        }
        if (StringUtils.isBlank((CharSequence)page.getPageKey())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("page.key")}));
        }
        if (!StringUtil.checkLength((String)(page.getPageKey() + ""), (int)1, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("page.key"), "1", "255"}));
        }
        PageEntity pageEntity = new PageEntity();
        pageEntity.setPageKey(page.getPageKey());
        PageEntity pageByPageKey = (PageEntity)((Object)this.pageBiz.getOne((Wrapper)new QueryWrapper((Object)pageEntity), false));
        if (pageByPageKey != null && !pageByPageKey.getId().equals(page.getId())) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("page.key")}));
        }
        this.pageBiz.updateById((Object)page);
        return ResultData.build().success((Object)page);
    }

    @ApiOperation(value="\u6821\u9a8c\u53c2\u6570\u63a5\u53e3")
    @GetMapping(value={"/verify"})
    @ResponseBody
    public ResultData verify(String fieldName, String fieldValue, String id, String idName) {
        boolean verify = false;
        verify = StringUtils.isBlank((CharSequence)id) ? super.validated("mdiy_page", fieldName, fieldValue) : super.validated("mdiy_page", fieldName, fieldValue, id, idName);
        if (verify) {
            return ResultData.build().success((Object)false);
        }
        return ResultData.build().success((Object)true);
    }
}

