/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.HashMap;
import java.util.Map;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ConfigEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfigUtil.class);
    public static Map<String, ConfigEntity> CONFIG_HASH_MAP = MapUtil.newHashMap();
    public static Map<String, HashMap<String, ConfigEntity>> APP_CONFIG_HASH_MAP = MapUtil.newHashMap();

    public static String getString(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String getString(String configName, String key, String defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        return object.toString();
    }

    public static boolean getBoolean(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return Boolean.FALSE;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean(String.valueOf(object));
        }
        return (Boolean)object;
    }

    public static boolean getBoolean(String configName, String key, Boolean defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean(String.valueOf(object));
        }
        return (Boolean)object;
    }

    public static int getInt(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return Integer.parseInt(String.valueOf(object));
        }
        return (Integer)object;
    }

    public static int getInt(String configName, String key, int defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof String) {
            return Integer.parseInt(String.valueOf(object));
        }
        return (Integer)object;
    }

    public static long getLong(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return 0L;
        }
        if (object instanceof String) {
            return Long.parseLong(String.valueOf(object));
        }
        return (Long)object;
    }

    public static long getLong(String configName, String key, int defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof String) {
            return Long.parseLong(String.valueOf(object));
        }
        return (Long)object;
    }

    public static Object getObject(String configName, String key) {
        ConfigEntity configEntity = ConfigUtil.getEntity(configName);
        if (configEntity == null) {
            return null;
        }
        HashMap map = (HashMap)JSONUtil.toBean((String)configEntity.getConfigData(), HashMap.class);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static Map getMap(String configName) {
        ConfigEntity configEntity = ConfigUtil.getEntity(configName);
        if (configEntity == null || StringUtils.isEmpty((CharSequence)configEntity.getConfigData())) {
            return null;
        }
        return (Map)JSONUtil.toBean((String)configEntity.getConfigData(), HashMap.class);
    }

    public static ConfigEntity getEntity(String configName) {
        if (StringUtils.isEmpty((CharSequence)configName)) {
            return null;
        }
        IConfigBiz configBiz = (IConfigBiz)SpringUtil.getBean(IConfigBiz.class);
        ConfigEntity config = new ConfigEntity();
        ConfigEntity configEntity = new ConfigEntity();
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        if (ObjectUtil.isNull((Object)websiteApp)) {
            if (CONFIG_HASH_MAP.get(configName) != null) {
                return CONFIG_HASH_MAP.get(configName);
            }
            config = new ConfigEntity();
            config.setConfigName(configName);
            config.setConfigType(ModelCustomTypeEnum.CONFIG.getLabel());
            configEntity = (ConfigEntity)((Object)configBiz.getOne((Wrapper)new LambdaQueryWrapper((Object)config)));
            if (configEntity == null) {
                LOG.error("{}\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8be5\u81ea\u5b9a\u4e49\u914d\u7f6e", (Object)configName);
                return null;
            }
            CONFIG_HASH_MAP.put(configName, configEntity);
            return configEntity;
        }
        HashMap<String, ConfigEntity> appConfigMap = APP_CONFIG_HASH_MAP.get(websiteApp.getAppId());
        configEntity = (ConfigEntity)((Object)MapUtil.get(appConfigMap, (Object)configName, ConfigEntity.class));
        if (!ObjectUtil.isNull((Object)((Object)configEntity))) {
            return configEntity;
        }
        config = new ConfigEntity();
        config.setConfigName(configName);
        config.setConfigType(ModelCustomTypeEnum.CONFIG.getLabel());
        config.setAppId(websiteApp.getAppId());
        configEntity = configBiz.getByEntity(config);
        if (!ObjectUtil.isNull((Object)((Object)configEntity))) {
            if (CollUtil.isEmpty(appConfigMap)) {
                appConfigMap = new HashMap();
            }
            appConfigMap.put(configName, configEntity);
            APP_CONFIG_HASH_MAP.put(websiteApp.getAppId(), appConfigMap);
            return configEntity;
        }
        configEntity = CONFIG_HASH_MAP.get(configName);
        if (!ObjectUtil.isNull((Object)((Object)configEntity))) {
            return configEntity;
        }
        config = new ConfigEntity();
        config.setConfigName(configName);
        config.setConfigType(ModelCustomTypeEnum.CONFIG.getLabel());
        configEntity = configBiz.getByEntity(config);
        if (ObjectUtil.isNotNull((Object)((Object)configEntity))) {
            CONFIG_HASH_MAP.put(configName, configEntity);
        } else {
            LOG.error("{}\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8be5\u81ea\u5b9a\u4e49\u914d\u7f6e", (Object)configName);
        }
        return configEntity;
    }

    public static void removeEntity(String configName) {
        if (StringUtils.isNotEmpty((CharSequence)configName)) {
            AppEntity websiteApp;
            if (CONFIG_HASH_MAP.get(configName) != null) {
                CONFIG_HASH_MAP.remove(configName);
            }
            if (ObjectUtil.isNotNull((Object)(websiteApp = BasicUtil.getWebsiteApp()))) {
                APP_CONFIG_HASH_MAP.get(websiteApp.getAppId()).remove(configName);
            }
        }
    }
}

