/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.store.action;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.basic.action.BaseFileAction;
import net.mingsoft.basic.bean.UploadConfigBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import net.mingsoft.store.biz.IShareBiz;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u5206\u4eab\u76ae\u80a4\u4e0a\u4f20\u63a5\u53e3"})
@Controller(value="cmsShareManageFileAction")
@RequestMapping(value={"${ms.manager.path}/store/file"})
public class ShareManagerFileAction
extends BaseFileAction {
    @Autowired
    private IShareBiz shareBiz;

    @ApiOperation(value="\u5904\u7406post\u8bf7\u6c42\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="uploadPath", value="\u4e0a\u4f20\u6587\u4ef6\u5939\u5730\u5740", required=false, paramType="form"), @ApiImplicitParam(name="file", value="\u6587\u4ef6\u6d41", dataType="__file", required=false, paramType="form"), @ApiImplicitParam(name="rename", value="\u662f\u5426\u91cd\u547d\u540d", required=false, paramType="form", defaultValue="true"), @ApiImplicitParam(name="appId", value="\u4e0a\u4f20\u8def\u5f84\u662f\u5426\u9700\u8981\u62fc\u63a5appId", required=false, paramType="form", defaultValue="false"), @ApiImplicitParam(name="uploadFolderPath", value="\u662f\u5426\u4fee\u6539\u4e0a\u4f20\u76ee\u5f55", required=false, paramType="form", defaultValue="false"), @ApiImplicitParam(name="uploadData", value="\u662f\u5426\u4e0a\u4f20\u6a21\u677f\u6570\u636e", required=false, paramType="form", defaultValue="false")})
    @PostMapping(value={"/uploadTemplate"})
    @ResponseBody
    public ResultData uploadTemplate(@ApiIgnore UploadConfigBean bean, @ApiIgnore boolean uploadFolderPath, @ApiIgnore boolean uploadData, HttpServletResponse res) throws IOException {
        File[] data;
        String uploadTemplatePath = MSProperties.upload.template;
        String rootPath = BasicUtil.getRealPath((String)"/");
        if (this.checkUploadPath(bean)) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.type")}));
        }
        if (StringUtils.isEmpty((CharSequence)bean.getUploadPath())) {
            bean.setUploadPath(uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId());
        } else if (!bean.getUploadPath().substring(0, uploadTemplatePath.length()).equalsIgnoreCase(uploadTemplatePath)) {
            throw new BusinessException("uploadPath\u53c2\u6570\u9519\u8bef");
        }
        UploadConfigBean config = new UploadConfigBean(bean.getUploadPath(), bean.getFile(), null, uploadFolderPath, bean.isRename());
        ResultData resultData = this.uploadTemplate(config);
        String targetDir = (String)resultData.get((Object)"data");
        if (targetDir != null && (targetDir.contains("..") || targetDir.contains("../") || targetDir.contains("..\\"))) {
            ResultData.build().error("\u975e\u6cd5\u8def\u5f84");
        }
        File zipFile = new File(BasicUtil.getRealTemplatePath((String)targetDir));
        try {
            ZipUtil.unzip((String)zipFile.getPath(), (String)BasicUtil.getRealPath((String)FileUtil.getPrefix((File)zipFile)), (Charset)Charset.forName("UTF-8"));
        }
        catch (IllegalArgumentException e) {
            ZipUtil.unzip((String)zipFile.getPath(), (String)BasicUtil.getRealPath((String)FileUtil.getPrefix((File)zipFile)), (Charset)Charset.forName("GBK"));
        }
        File tmplZipFile = new File(BasicUtil.getRealPath((String)FileUtil.getPrefix((File)zipFile)));
        File tmplFile = tmplZipFile.listFiles(file -> !file.getName().equals("html") && !file.getName().equals("data"))[0];
        String tmplPath = tmplFile.getPath();
        String tmplName = tmplFile.getName();
        if (BasicUtil.getApp().getAppStyle() != null && BasicUtil.getApp().getAppStyle().equals(tmplName)) {
            FileUtil.del((String)(rootPath + File.separator + uploadTemplatePath + File.separator + BasicUtil.getApp().getId() + File.separator + tmplName));
        }
        FileUtil.copy((String)tmplPath, (String)(rootPath + File.separator + uploadTemplatePath + File.separator + BasicUtil.getApp().getId()), (boolean)true);
        if (uploadData && (data = tmplZipFile.listFiles(file -> file.getName().equals("data"))) != null && data.length > 0) {
            File dataFile = data[0];
            String dataFilePath = dataFile.getPath();
            FileUtil.copy((String)dataFilePath, (String)(rootPath + File.separator + uploadTemplatePath + File.separator + BasicUtil.getApp().getId() + File.separator + tmplName), (boolean)true);
        }
        FileUtil.del((String)BasicUtil.getRealPath((String)FileUtil.getPrefix((File)zipFile)));
        boolean shareTmpl = false;
        ArrayList<File> cssImagesFiles = new ArrayList<File>();
        List files = FileUtil.loopFiles((String)zipFile.getParent());
        List deniedList = Arrays.stream(MSProperties.upload.denied.split(",")).map(String::toLowerCase).collect(Collectors.toList());
        for (File file2 : files) {
            FileInputStream fileInputStream = new FileInputStream(file2);
            String fileType = FileTypeUtil.getType((File)file2).toLowerCase();
            if (deniedList.contains(fileType)) {
                IOUtils.closeQuietly((Closeable)fileInputStream);
                FileUtil.del((String)zipFile.getParent());
                throw new RuntimeException(StrUtil.format((CharSequence)"\u538b\u7f29\u5305\u5185\u6587\u4ef6{}\u7684\u7c7b\u578b{}\u7981\u6b62\u4e0a\u4f20", (Object[])new Object[]{file2.getName(), fileType}));
            }
            if ("CMS_CATEGORY.json".equals(file2.getName()) && "data".equals(FileNameUtil.getName((String)file2.getParent()))) {
                shareTmpl = true;
            }
            if ("upload".equals(FileNameUtil.getName((String)file2.getParent())) && !file2.isDirectory()) {
                cssImagesFiles.add(file2);
            }
            IOUtils.closeQuietly((Closeable)fileInputStream);
        }
        File cssImageFile = new File(rootPath + uploadTemplatePath + "/" + BasicUtil.getApp().getId() + "/" + tmplName + "/images");
        for (File cssFile : cssImagesFiles) {
            if (cssImageFile.exists() && cssImageFile.isDirectory()) {
                FileUtil.move((File)cssFile, (File)cssImageFile, (boolean)true);
                continue;
            }
            FileUtils.moveFileToDirectory((File)cssFile, (File)cssImageFile, (boolean)true);
        }
        FileUtil.del((File)zipFile);
        if (shareTmpl && uploadData) {
            this.shareBiz.tmplUnZip(tmplName);
        }
        return ResultData.build().success();
    }

    protected boolean checkUploadPath(UploadConfigBean bean) {
        return bean.getUploadPath() != null && (bean.getUploadPath().contains("../") || bean.getUploadPath().contains("..\\"));
    }
}

