<html xmlns="http://www.w3.org/1999/html">
<head>
    <title>分享</title>
    <#include "../../include/head-file.ftl">
    <link rel="stylesheet" type="text/css" href="${base}/static/plugins/hover/2.3.1/hover-min.css" />
</head>
<body class="custom-body">
<div id="app" v-cloak class="ms-index" v-loading="loading" element-loading-text="处理中..." element-loading-background="rgba(255, 255, 255, 0.3)">
    <el-main class="ms-container">
        <el-alert
                class="ms-alert-tip"
                title="功能介绍"
                type="info">
            <template slot="title">
                功能介绍 <a href='http://doc.mingsoft.net/ms/fen-xiang-pi-fu.html' target="_blank">说明手册</a>
            </template>
           可以快速将模板分享到MStore赚取收益，导出的模板建议进行导入验证之后再分享到MStore，如果导出的文件大于20M，检查导出压缩包进行清理，只要保持模版的页面正常显示就可以满足Mstore的分享条件<br/>
            一般分享Mstore步骤：<br/>
            1、导出当前的模板；<br/>
            2、删除 <b>html\template\upload</b> 文件夹（注意做好备份）;<br/>
            3、导入 <b>第1步</b> 导出的压缩包；<br/>
            4、手动静态化 <b>首页、文章、栏目</b> 检查压缩包是否存在问题；<br/>
            5、再次导出 模板，进入MS平台通过 <b>分享模板</b> 功能进行分享；<br/>
        </el-alert>

        <el-row :gutter="10" style="margin-bottom: 10px" >
            <el-col :span="12">

                <div class="panel">

                    <el-progress type="circle" v-if="uploadLoading" :percentage="percentage"></el-progress>
                    <el-upload
                            v-else
                            ref="uploadTemplate"
                            :auto-upload="false"
                            class="upload"
                            drag
                            :action="ms.manager+'/store/file/uploadTemplate.do'"
                            accept=".zip"
                            :disabled="false"
                            :on-change="onChange"
                            :on-error="onError"
                            :show-file-list="false"
                            :on-success="onSuccess"
                            :before-upload="beforeUpload"
                            :on-progress="onProgress"
                            :data="uploadParam"
                            :limit="1">
                        <i class="iconfont icon-shangchuan hvr-bob"></i>
                        <div class="el-upload__text">导入ZIP模板，<em>点击上传</em></div>
                    </el-upload>

                    <div class="ms-form-tip">
                        注意: <br>
                        方式一：覆盖数据并上传，<b>栏目、文章及模板中指定的id都会配套修改成新的雪花id</b><br>
                        方式二：仅上传模板(需要对模板有一定了解)，只增加一个模板文件，数据、资源等不修改，需要在<b>先在系统设置->应用设置处重新绑定站点风格;然后在栏目管理，所有栏目编辑重新绑定列表、详情对应的模板</b><br>
                        1、可以上传通过右侧 <b>导出下载</b> 的模板，也可以上传Store中下载的ZIP格式模板<br>
                        2、导入模板后需要全部静态化一次才能看到前台效果<br>
                        3、如果不需要导入数据，可以手动删除压缩包中的 <b>data</b> 文件夹<br>
                        4、如果是分享MStore模板前进行导入验证，可以先手动删除 <b>html\template\upload</b> 文件夹，确保压缩包完整还原资源文件<br>
                        <el-alert
                                style="margin-top: 10px"
                                title="重要提示"
                                type="warning"
                                description="推荐导入MStore有在线演示效果的模板，会自动导入演示数据，其它模板导入不会自动增加演示效果数据"
                                show-icon
                                :closable="false">
                        </el-alert>
                    </div>
                </div>

            </el-col>
            <el-col :span="12">
                <div class="panel">
                    <div class="upload" @click="exp()" >
                        <i class="iconfont icon-xiazai hvr-hang" v-if="!shareLoading"></i>
                        <el-progress type="circle" v-else :percentage="percentage"></el-progress>
                        <div class="el-upload__text" v-if="!shareLoading">导出下载当前模板以及数据</div>
                    </div>
                    <div class="ms-form-tip">
                        注意：如果需要分享到Store，必须按照 <b>功能介绍</b> 里面的步骤操作一遍<br>
                        1、会导出当前站点 <b>模板文件、upload、html </b> 文件夹，以及文章与栏目(必须要静态化)、自定义模型数据<br>
                        2、导出的数据存放在 <b>data</b> 文件夹下,会自动导出 <b>文章、栏目、自定义模型数据</b> <br>
                        3、html存放静态化页面，方便Store分享预览静态效果<br>
                        4、导出压缩包不能大于20M，如果大于20M建议清理无效的附件<br>
                    </div>
                </div>

            </el-col>
        </el-row>

    </el-main>
</div>
</body>
</html>
<script>
    new _Vue({
        el: '#app',
        data(){
            return {
                loading:false,
                shareLoading:false,
                percentage:0,
                uploadLoading: false,
                uploadParam: {
                    uploadFolderPath: true,
                    // 是否覆盖数据
                    uploadData: false
                }

            }
        },
        watch: {
            'shareLoading': function (n, o) {
                this.loading = n;
            }

        },
        methods:{
            // 分享当前使用模板
            exp: function(){
                var that = this;
                that.shareLoading = true;
                that.percentage = 0;
                that.$confirm('导出前先确认前端展示是否完整，导出后可以轻松分享到MStore赚钱收益！分享步骤可以参考 <a target="_blank" href="http://doc.mingsoft.net/ms/fen-xiang-pi-fu.html">分享文档</a>。确认导出？', '提示', {
                    confirmButtonText: '确定',
                    cancelButtonText: '取消',
                    dangerouslyUseHTMLString: true,
                    type: 'warning'
                }).then(function (){
                    that.shareLoading = true;
                    // 下载的压缩包名称  默认是模板文件夹名称
                    ms.http.download(ms.manager + "/store/share/exp.do",{},60000,function(progress) {
                        //	下载相关接口可配置函数,用于获取下载进度信息progress
                        that.percentage = Math.round(progress.loaded / progress.total * 100);
                    }).then(function (res){
                        that.$notify({
                            type: 'success',
                            title: '成功',
                            message: '下载备份压缩包资源成功！'
                        });
                        that.shareLoading = false;
                    }).catch(function (res){
                        that.$notify({
                            type:'warning',
                            title:'失败',
                            message:'备份失败，确认是否按照提示信息操作，具体异常查看系统日志！参考文档：http://doc.mingsoft.net/ms/fen-xiang-pi-fu.html#%E6%A8%A1%E6%9D%BF%E5%AF%BC%E5%87%BA%E5%A4%B1%E8%B4%A5'
                        })
                        that.shareLoading = false;
                    })
                })
                that.shareLoading = false;

            },
            onChange: function (file,fileList){
                var that = this;
                if (file.status == "ready"){
                    that.$confirm('上传模板压缩包并选择导入方式, 请选择: <br/> <b>1.覆盖数据并上传</b>:删除数据并导入新数据 <br/><b>2.仅上传模板</b>:需要重新绑定模板<br>详细信息请查看导入注意事项', {
                        distinguishCancelAndClose: true,
                        confirmButtonText: '覆盖数据并上传模板',
                        cancelButtonText: '仅上传模板',
                        dangerouslyUseHTMLString: true,
                        type: 'warning'
                    }).then(function (action){
                        // 上传模板数据
                        that.uploadParam.uploadData = true;
                        that.$refs.uploadTemplate.submit();
                    }).catch(function (action){
                        // 这里有两个状态 确认框的取消按钮(cancel) 确认框的x按钮(close)
                        if (action == 'cancel'){
                            // 仅上传模板
                            that.$refs.uploadTemplate.submit();
                        }else {
                            // 取消上传
                            that.$refs.uploadTemplate.abort();
                            // 清空上传列表的文件
                            that.$refs.uploadTemplate.clearFiles();
                        }
                    })
                }
            },
            beforeUpload:function(file){
                this.uploadLoading = true;
                this.loading = true;
            },

            // 文件上传时的钩子函数,获取上传进度
            onProgress(event, file, fileList) {
                let num = ((event.loaded / event.total) * 100) | 0; //百分比
                this.percentage = num/2;
            },
            //fileUpload文件上传完成回调
            onSuccess: function (response, file, fileList) {
                var that = this;
                this.percentage=100;
                if(response.result){
                    var message = '模板添加成功，需在应用设置重新绑定模板，栏目也需对应绑定！';
                    if (that.uploadParam.uploadData){
                        message = '模板替换成功，需要手动全部静态化之后才能看到最新的模板效果！'
                    }
                    that.$notify({
                        type: 'success',
                        title: '成功',
                        message: message
                    });
                }else {
                    this.$notify({
                        type: 'warning',
                        title: '失败',
                        message: '模板上传失败'+response.msg
                    });
                }
                that.uploadLoading = false;
                that.loading = false;
                that.percentage=0;
                this.fileList=[];
            },
            // 上传失败
            onError:function (response, file, fileList) {
                if(response.message){
                    this.$notify({
                        type: 'warning',
                        title: '失败',
                        message: '模板上传失败'+JSON.parse(response.message).msg
                    }); //删除成功，刷新列表
                }else {
                    this.$notify({
                        type: 'warning',
                        title: '失败',
                        message: '模板上传失败，可以联系Mcms官方客服提供技术支持'
                    });
                }
                this.uploadLoading = false;
                this.loading = false;
                this.percentage=0;
                this.fileList=[];
                this.$nextTick(() => {
                    this.$refs.uploadTemplate.clearFiles();
                });
            }
        },
        created:function() {
        }
    });
</script>
<style>
    #app {
        background-color: white;
    }

    #app .panel {
        background-color: white;padding: 20px 40px 20px 40px; height: 270px;border: 1px solid #EBEEF5;
        align-items: center;
        justify-content: center;
        display: flex;
        min-height: 300px;
    }

    #app .panel .upload{
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        width: 200px;
        height: 200px;
    }
    #app .panel .upload .el-upload{
        align-items: center;
        justify-content: center;
        height: 200px;
        display: flex;
    }
    #app .panel .el-upload-dragger {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        border: unset;
        padding-top: 3px;
        height: 200px;
        width: unset;
    }

    #app .panel   .icon-shangchuan
    ,#app .panel  .icon-xiazai ,#app .panel   .el-icon-loading
    {
        font-size: 67px;
        color: #C0C4CC;
        line-height: 50px;

    }

    #app .upload:hover .icon-shangchuan,#app .upload:hover  .icon-xiazai {
        color: #67C23A;
        cursor: pointer;
    }

    #app .panel   .el-upload__text {
        margin-top: 1vh;
        cursor: pointer;
    }

    #app .panel .ms-form-tip {
        width: 80%;
        margin-left: 20px;
    }

</style>
